/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.CryptoProvidersListCopier;
import software.amazon.awssdk.services.pcaconnectorad.model.KeySpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivateKeyAttributesV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivateKeyAttributesV2> {
    private static final SdkField<List<String>> CRYPTO_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CryptoProviders").getter(PrivateKeyAttributesV2.getter(PrivateKeyAttributesV2::cryptoProviders)).setter(PrivateKeyAttributesV2.setter(Builder::cryptoProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CryptoProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeySpec").getter(PrivateKeyAttributesV2.getter(PrivateKeyAttributesV2::keySpecAsString)).setter(PrivateKeyAttributesV2.setter(Builder::keySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySpec").build()}).build();
    private static final SdkField<Integer> MINIMAL_KEY_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimalKeyLength").getter(PrivateKeyAttributesV2.getter(PrivateKeyAttributesV2::minimalKeyLength)).setter(PrivateKeyAttributesV2.setter(Builder::minimalKeyLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimalKeyLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRYPTO_PROVIDERS_FIELD, KEY_SPEC_FIELD, MINIMAL_KEY_LENGTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrivateKeyAttributesV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> cryptoProviders;
    private final String keySpec;
    private final Integer minimalKeyLength;

    private PrivateKeyAttributesV2(BuilderImpl builder) {
        this.cryptoProviders = builder.cryptoProviders;
        this.keySpec = builder.keySpec;
        this.minimalKeyLength = builder.minimalKeyLength;
    }

    public final boolean hasCryptoProviders() {
        return this.cryptoProviders != null && !(this.cryptoProviders instanceof SdkAutoConstructList);
    }

    public final List<String> cryptoProviders() {
        return this.cryptoProviders;
    }

    public final KeySpec keySpec() {
        return KeySpec.fromValue(this.keySpec);
    }

    public final String keySpecAsString() {
        return this.keySpec;
    }

    public final Integer minimalKeyLength() {
        return this.minimalKeyLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCryptoProviders() ? this.cryptoProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimalKeyLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyAttributesV2)) {
            return false;
        }
        PrivateKeyAttributesV2 other = (PrivateKeyAttributesV2)obj;
        return this.hasCryptoProviders() == other.hasCryptoProviders() && Objects.equals(this.cryptoProviders(), other.cryptoProviders()) && Objects.equals(this.keySpecAsString(), other.keySpecAsString()) && Objects.equals(this.minimalKeyLength(), other.minimalKeyLength());
    }

    public final String toString() {
        return ToString.builder((String)"PrivateKeyAttributesV2").add("CryptoProviders", this.hasCryptoProviders() ? this.cryptoProviders() : null).add("KeySpec", (Object)this.keySpecAsString()).add("MinimalKeyLength", (Object)this.minimalKeyLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CryptoProviders": {
                return Optional.ofNullable(clazz.cast(this.cryptoProviders()));
            }
            case "KeySpec": {
                return Optional.ofNullable(clazz.cast(this.keySpecAsString()));
            }
            case "MinimalKeyLength": {
                return Optional.ofNullable(clazz.cast(this.minimalKeyLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CryptoProviders", CRYPTO_PROVIDERS_FIELD);
        map.put("KeySpec", KEY_SPEC_FIELD);
        map.put("MinimalKeyLength", MINIMAL_KEY_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyAttributesV2, T> g) {
        return obj -> g.apply((PrivateKeyAttributesV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cryptoProviders = DefaultSdkAutoConstructList.getInstance();
        private String keySpec;
        private Integer minimalKeyLength;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyAttributesV2 model) {
            this.cryptoProviders(model.cryptoProviders);
            this.keySpec(model.keySpec);
            this.minimalKeyLength(model.minimalKeyLength);
        }

        public final Collection<String> getCryptoProviders() {
            if (this.cryptoProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cryptoProviders;
        }

        public final void setCryptoProviders(Collection<String> cryptoProviders) {
            this.cryptoProviders = CryptoProvidersListCopier.copy(cryptoProviders);
        }

        @Override
        public final Builder cryptoProviders(Collection<String> cryptoProviders) {
            this.cryptoProviders = CryptoProvidersListCopier.copy(cryptoProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cryptoProviders(String ... cryptoProviders) {
            this.cryptoProviders(Arrays.asList(cryptoProviders));
            return this;
        }

        public final String getKeySpec() {
            return this.keySpec;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(KeySpec keySpec) {
            this.keySpec(keySpec == null ? null : keySpec.toString());
            return this;
        }

        public final Integer getMinimalKeyLength() {
            return this.minimalKeyLength;
        }

        public final void setMinimalKeyLength(Integer minimalKeyLength) {
            this.minimalKeyLength = minimalKeyLength;
        }

        @Override
        public final Builder minimalKeyLength(Integer minimalKeyLength) {
            this.minimalKeyLength = minimalKeyLength;
            return this;
        }

        public PrivateKeyAttributesV2 build() {
            return new PrivateKeyAttributesV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivateKeyAttributesV2> {
        public Builder cryptoProviders(Collection<String> var1);

        public Builder cryptoProviders(String ... var1);

        public Builder keySpec(String var1);

        public Builder keySpec(KeySpec var1);

        public Builder minimalKeyLength(Integer var1);
    }
}

