/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.ValidityPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateValidity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateValidity> {
    private static final SdkField<ValidityPeriod> RENEWAL_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenewalPeriod").getter(CertificateValidity.getter(CertificateValidity::renewalPeriod)).setter(CertificateValidity.setter(Builder::renewalPeriod)).constructor(ValidityPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalPeriod").build()}).build();
    private static final SdkField<ValidityPeriod> VALIDITY_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidityPeriod").getter(CertificateValidity.getter(CertificateValidity::validityPeriod)).setter(CertificateValidity.setter(Builder::validityPeriod)).constructor(ValidityPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_PERIOD_FIELD, VALIDITY_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RenewalPeriod", RENEWAL_PERIOD_FIELD);
            this.put("ValidityPeriod", VALIDITY_PERIOD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ValidityPeriod renewalPeriod;
    private final ValidityPeriod validityPeriod;

    private CertificateValidity(BuilderImpl builder) {
        this.renewalPeriod = builder.renewalPeriod;
        this.validityPeriod = builder.validityPeriod;
    }

    public final ValidityPeriod renewalPeriod() {
        return this.renewalPeriod;
    }

    public final ValidityPeriod validityPeriod() {
        return this.validityPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.validityPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateValidity)) {
            return false;
        }
        CertificateValidity other = (CertificateValidity)obj;
        return Objects.equals(this.renewalPeriod(), other.renewalPeriod()) && Objects.equals(this.validityPeriod(), other.validityPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateValidity").add("RenewalPeriod", (Object)this.renewalPeriod()).add("ValidityPeriod", (Object)this.validityPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenewalPeriod": {
                return Optional.ofNullable(clazz.cast(this.renewalPeriod()));
            }
            case "ValidityPeriod": {
                return Optional.ofNullable(clazz.cast(this.validityPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CertificateValidity, T> g) {
        return obj -> g.apply((CertificateValidity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ValidityPeriod renewalPeriod;
        private ValidityPeriod validityPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateValidity model) {
            this.renewalPeriod(model.renewalPeriod);
            this.validityPeriod(model.validityPeriod);
        }

        public final ValidityPeriod.Builder getRenewalPeriod() {
            return this.renewalPeriod != null ? this.renewalPeriod.toBuilder() : null;
        }

        public final void setRenewalPeriod(ValidityPeriod.BuilderImpl renewalPeriod) {
            this.renewalPeriod = renewalPeriod != null ? renewalPeriod.build() : null;
        }

        @Override
        public final Builder renewalPeriod(ValidityPeriod renewalPeriod) {
            this.renewalPeriod = renewalPeriod;
            return this;
        }

        public final ValidityPeriod.Builder getValidityPeriod() {
            return this.validityPeriod != null ? this.validityPeriod.toBuilder() : null;
        }

        public final void setValidityPeriod(ValidityPeriod.BuilderImpl validityPeriod) {
            this.validityPeriod = validityPeriod != null ? validityPeriod.build() : null;
        }

        @Override
        public final Builder validityPeriod(ValidityPeriod validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public CertificateValidity build() {
            return new CertificateValidity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateValidity> {
        public Builder renewalPeriod(ValidityPeriod var1);

        default public Builder renewalPeriod(Consumer<ValidityPeriod.Builder> renewalPeriod) {
            return this.renewalPeriod((ValidityPeriod)((ValidityPeriod.Builder)ValidityPeriod.builder().applyMutation(renewalPeriod)).build());
        }

        public Builder validityPeriod(ValidityPeriod var1);

        default public Builder validityPeriod(Consumer<ValidityPeriod.Builder> validityPeriod) {
            return this.validityPeriod((ValidityPeriod)((ValidityPeriod.Builder)ValidityPeriod.builder().applyMutation(validityPeriod)).build());
        }
    }
}

