/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntryListCopier;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplateGroupAccessControlEntriesResponse
extends PcaConnectorAdResponse
implements ToCopyableBuilder<Builder, ListTemplateGroupAccessControlEntriesResponse> {
    private static final SdkField<List<AccessControlEntrySummary>> ACCESS_CONTROL_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlEntries").getter(ListTemplateGroupAccessControlEntriesResponse.getter(ListTemplateGroupAccessControlEntriesResponse::accessControlEntries)).setter(ListTemplateGroupAccessControlEntriesResponse.setter(Builder::accessControlEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessControlEntrySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTemplateGroupAccessControlEntriesResponse.getter(ListTemplateGroupAccessControlEntriesResponse::nextToken)).setter(ListTemplateGroupAccessControlEntriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccessControlEntries", ACCESS_CONTROL_ENTRIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AccessControlEntrySummary> accessControlEntries;
    private final String nextToken;

    private ListTemplateGroupAccessControlEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.accessControlEntries = builder.accessControlEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccessControlEntries() {
        return this.accessControlEntries != null && !(this.accessControlEntries instanceof SdkAutoConstructList);
    }

    public final List<AccessControlEntrySummary> accessControlEntries() {
        return this.accessControlEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlEntries() ? this.accessControlEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateGroupAccessControlEntriesResponse)) {
            return false;
        }
        ListTemplateGroupAccessControlEntriesResponse other = (ListTemplateGroupAccessControlEntriesResponse)((Object)obj);
        return this.hasAccessControlEntries() == other.hasAccessControlEntries() && Objects.equals(this.accessControlEntries(), other.accessControlEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTemplateGroupAccessControlEntriesResponse").add("AccessControlEntries", this.hasAccessControlEntries() ? this.accessControlEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessControlEntries": {
                return Optional.ofNullable(clazz.cast(this.accessControlEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateGroupAccessControlEntriesResponse, T> g) {
        return obj -> g.apply((ListTemplateGroupAccessControlEntriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdResponse.BuilderImpl
    implements Builder {
        private List<AccessControlEntrySummary> accessControlEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateGroupAccessControlEntriesResponse model) {
            super(model);
            this.accessControlEntries(model.accessControlEntries);
            this.nextToken(model.nextToken);
        }

        public final List<AccessControlEntrySummary.Builder> getAccessControlEntries() {
            List<AccessControlEntrySummary.Builder> result = AccessControlEntryListCopier.copyToBuilder(this.accessControlEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlEntries(Collection<AccessControlEntrySummary.BuilderImpl> accessControlEntries) {
            this.accessControlEntries = AccessControlEntryListCopier.copyFromBuilder(accessControlEntries);
        }

        @Override
        public final Builder accessControlEntries(Collection<AccessControlEntrySummary> accessControlEntries) {
            this.accessControlEntries = AccessControlEntryListCopier.copy(accessControlEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlEntries(AccessControlEntrySummary ... accessControlEntries) {
            this.accessControlEntries(Arrays.asList(accessControlEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlEntries(Consumer<AccessControlEntrySummary.Builder> ... accessControlEntries) {
            this.accessControlEntries(Stream.of(accessControlEntries).map(c -> (AccessControlEntrySummary)((AccessControlEntrySummary.Builder)AccessControlEntrySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTemplateGroupAccessControlEntriesResponse build() {
            return new ListTemplateGroupAccessControlEntriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PcaConnectorAdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplateGroupAccessControlEntriesResponse> {
        public Builder accessControlEntries(Collection<AccessControlEntrySummary> var1);

        public Builder accessControlEntries(AccessControlEntrySummary ... var1);

        public Builder accessControlEntries(Consumer<AccessControlEntrySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

