/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessRight {
    ALLOW("ALLOW"),
    DENY("DENY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessRight> VALUE_MAP;
    private final String value;

    private AccessRight(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessRight fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessRight> knownValues() {
        EnumSet<AccessRight> knownValues = EnumSet.allOf(AccessRight.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessRight.class, AccessRight::toString);
    }
}

