/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdClient;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdServiceClientConfiguration;
import software.amazon.awssdk.services.pcaconnectorad.internal.PcaConnectorAdServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessDeniedException;
import software.amazon.awssdk.services.pcaconnectorad.model.ConflictException;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateDirectoryRegistrationRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateDirectoryRegistrationResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateServicePrincipalNameRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateServicePrincipalNameResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.CreateTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteDirectoryRegistrationRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteDirectoryRegistrationResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteServicePrincipalNameRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteServicePrincipalNameResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetConnectorRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetConnectorResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetDirectoryRegistrationRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetDirectoryRegistrationResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetServicePrincipalNameRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetServicePrincipalNameResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.GetTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.InternalServerException;
import software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListConnectorsResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListServicePrincipalNamesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplateGroupAccessControlEntriesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdException;
import software.amazon.awssdk.services.pcaconnectorad.model.ResourceNotFoundException;
import software.amazon.awssdk.services.pcaconnectorad.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.pcaconnectorad.model.TagResourceRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.TagResourceResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ThrottlingException;
import software.amazon.awssdk.services.pcaconnectorad.model.UntagResourceRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.UntagResourceResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateGroupAccessControlEntryRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateGroupAccessControlEntryResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.pcaconnectorad.model.ValidationException;
import software.amazon.awssdk.services.pcaconnectorad.transform.CreateConnectorRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.CreateDirectoryRegistrationRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.CreateServicePrincipalNameRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.CreateTemplateGroupAccessControlEntryRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.DeleteConnectorRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.DeleteDirectoryRegistrationRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.DeleteServicePrincipalNameRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.DeleteTemplateGroupAccessControlEntryRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.GetConnectorRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.GetDirectoryRegistrationRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.GetServicePrincipalNameRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.GetTemplateGroupAccessControlEntryRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.ListConnectorsRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.ListDirectoryRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.ListServicePrincipalNamesRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.ListTemplateGroupAccessControlEntriesRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.UpdateTemplateGroupAccessControlEntryRequestMarshaller;
import software.amazon.awssdk.services.pcaconnectorad.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPcaConnectorAdClient
implements PcaConnectorAdClient {
    private static final Logger log = Logger.loggerFor(DefaultPcaConnectorAdClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPcaConnectorAdClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectorResponse createConnector(CreateConnectorRequest createConnectorRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, createConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnector");
            CreateConnectorResponse createConnectorResponse = (CreateConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$createConnector$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectoryRegistrationResponse createDirectoryRegistration(CreateDirectoryRegistrationRequest createDirectoryRegistrationRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectoryRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, createDirectoryRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectoryRegistration");
            CreateDirectoryRegistrationResponse createDirectoryRegistrationResponse = (CreateDirectoryRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectoryRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDirectoryRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectoryRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectoryRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$createDirectoryRegistration$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServicePrincipalNameResponse createServicePrincipalName(CreateServicePrincipalNameRequest createServicePrincipalNameRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServicePrincipalNameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createServicePrincipalNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, createServicePrincipalNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateServicePrincipalName");
            CreateServicePrincipalNameResponse createServicePrincipalNameResponse = (CreateServicePrincipalNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateServicePrincipalName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createServicePrincipalNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServicePrincipalNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServicePrincipalNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$createServicePrincipalName$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, createTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTemplate");
            CreateTemplateResponse createTemplateResponse = (CreateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$createTemplate$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTemplateGroupAccessControlEntryResponse createTemplateGroupAccessControlEntry(CreateTemplateGroupAccessControlEntryRequest createTemplateGroupAccessControlEntryRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTemplateGroupAccessControlEntryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTemplateGroupAccessControlEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, createTemplateGroupAccessControlEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTemplateGroupAccessControlEntry");
            CreateTemplateGroupAccessControlEntryResponse createTemplateGroupAccessControlEntryResponse = (CreateTemplateGroupAccessControlEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTemplateGroupAccessControlEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTemplateGroupAccessControlEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTemplateGroupAccessControlEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTemplateGroupAccessControlEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$createTemplateGroupAccessControlEntry$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectorResponse deleteConnector(DeleteConnectorRequest deleteConnectorRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, deleteConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnector");
            DeleteConnectorResponse deleteConnectorResponse = (DeleteConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$deleteConnector$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectoryRegistrationResponse deleteDirectoryRegistration(DeleteDirectoryRegistrationRequest deleteDirectoryRegistrationRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectoryRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, deleteDirectoryRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectoryRegistration");
            DeleteDirectoryRegistrationResponse deleteDirectoryRegistrationResponse = (DeleteDirectoryRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectoryRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDirectoryRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectoryRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectoryRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$deleteDirectoryRegistration$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServicePrincipalNameResponse deleteServicePrincipalName(DeleteServicePrincipalNameRequest deleteServicePrincipalNameRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServicePrincipalNameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServicePrincipalNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, deleteServicePrincipalNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServicePrincipalName");
            DeleteServicePrincipalNameResponse deleteServicePrincipalNameResponse = (DeleteServicePrincipalNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServicePrincipalName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServicePrincipalNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServicePrincipalNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServicePrincipalNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$deleteServicePrincipalName$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, deleteTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTemplate");
            DeleteTemplateResponse deleteTemplateResponse = (DeleteTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$deleteTemplate$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTemplateGroupAccessControlEntryResponse deleteTemplateGroupAccessControlEntry(DeleteTemplateGroupAccessControlEntryRequest deleteTemplateGroupAccessControlEntryRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTemplateGroupAccessControlEntryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTemplateGroupAccessControlEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, deleteTemplateGroupAccessControlEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTemplateGroupAccessControlEntry");
            DeleteTemplateGroupAccessControlEntryResponse deleteTemplateGroupAccessControlEntryResponse = (DeleteTemplateGroupAccessControlEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTemplateGroupAccessControlEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTemplateGroupAccessControlEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTemplateGroupAccessControlEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTemplateGroupAccessControlEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$deleteTemplateGroupAccessControlEntry$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConnectorResponse getConnector(GetConnectorRequest getConnectorRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, getConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnector");
            GetConnectorResponse getConnectorResponse = (GetConnectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConnectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConnectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$getConnector$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDirectoryRegistrationResponse getDirectoryRegistration(GetDirectoryRegistrationRequest getDirectoryRegistrationRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryRegistrationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDirectoryRegistrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, getDirectoryRegistrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectoryRegistration");
            GetDirectoryRegistrationResponse getDirectoryRegistrationResponse = (GetDirectoryRegistrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectoryRegistration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDirectoryRegistrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDirectoryRegistrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDirectoryRegistrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$getDirectoryRegistration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServicePrincipalNameResponse getServicePrincipalName(GetServicePrincipalNameRequest getServicePrincipalNameRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServicePrincipalNameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServicePrincipalNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, getServicePrincipalNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServicePrincipalName");
            GetServicePrincipalNameResponse getServicePrincipalNameResponse = (GetServicePrincipalNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServicePrincipalName").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServicePrincipalNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServicePrincipalNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServicePrincipalNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$getServicePrincipalName$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, getTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemplate");
            GetTemplateResponse getTemplateResponse = (GetTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$getTemplate$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateGroupAccessControlEntryResponse getTemplateGroupAccessControlEntry(GetTemplateGroupAccessControlEntryRequest getTemplateGroupAccessControlEntryRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemplateGroupAccessControlEntryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTemplateGroupAccessControlEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, getTemplateGroupAccessControlEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemplateGroupAccessControlEntry");
            GetTemplateGroupAccessControlEntryResponse getTemplateGroupAccessControlEntryResponse = (GetTemplateGroupAccessControlEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemplateGroupAccessControlEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTemplateGroupAccessControlEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemplateGroupAccessControlEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTemplateGroupAccessControlEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$getTemplateGroupAccessControlEntry$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, listConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectors");
            ListConnectorsResponse listConnectorsResponse = (ListConnectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConnectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConnectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$listConnectors$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDirectoryRegistrationsResponse listDirectoryRegistrations(ListDirectoryRegistrationsRequest listDirectoryRegistrationsRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDirectoryRegistrationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDirectoryRegistrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, listDirectoryRegistrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDirectoryRegistrations");
            ListDirectoryRegistrationsResponse listDirectoryRegistrationsResponse = (ListDirectoryRegistrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDirectoryRegistrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDirectoryRegistrationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDirectoryRegistrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDirectoryRegistrationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$listDirectoryRegistrations$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicePrincipalNamesResponse listServicePrincipalNames(ListServicePrincipalNamesRequest listServicePrincipalNamesRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicePrincipalNamesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicePrincipalNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, listServicePrincipalNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServicePrincipalNames");
            ListServicePrincipalNamesResponse listServicePrincipalNamesResponse = (ListServicePrincipalNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServicePrincipalNames").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServicePrincipalNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicePrincipalNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicePrincipalNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$listServicePrincipalNames$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$listTagsForResource$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTemplateGroupAccessControlEntriesResponse listTemplateGroupAccessControlEntries(ListTemplateGroupAccessControlEntriesRequest listTemplateGroupAccessControlEntriesRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTemplateGroupAccessControlEntriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTemplateGroupAccessControlEntriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, listTemplateGroupAccessControlEntriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTemplateGroupAccessControlEntries");
            ListTemplateGroupAccessControlEntriesResponse listTemplateGroupAccessControlEntriesResponse = (ListTemplateGroupAccessControlEntriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplateGroupAccessControlEntries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTemplateGroupAccessControlEntriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTemplateGroupAccessControlEntriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTemplateGroupAccessControlEntriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$listTemplateGroupAccessControlEntries$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, listTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTemplates");
            ListTemplatesResponse listTemplatesResponse = (ListTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$listTemplates$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$tagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$untagResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, updateTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTemplate");
            UpdateTemplateResponse updateTemplateResponse = (UpdateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$updateTemplate$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTemplateGroupAccessControlEntryResponse updateTemplateGroupAccessControlEntry(UpdateTemplateGroupAccessControlEntryRequest updateTemplateGroupAccessControlEntryRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, PcaConnectorAdException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTemplateGroupAccessControlEntryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTemplateGroupAccessControlEntryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultPcaConnectorAdClient.resolveMetricPublishers(clientConfiguration, updateTemplateGroupAccessControlEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Pca Connector Ad");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTemplateGroupAccessControlEntry");
            UpdateTemplateGroupAccessControlEntryResponse updateTemplateGroupAccessControlEntryResponse = (UpdateTemplateGroupAccessControlEntryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTemplateGroupAccessControlEntry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTemplateGroupAccessControlEntryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTemplateGroupAccessControlEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTemplateGroupAccessControlEntryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPcaConnectorAdClient.lambda$updateTemplateGroupAccessControlEntry$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "pca-connector-ad";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PcaConnectorAdServiceClientConfigurationBuilder serviceConfigBuilder = new PcaConnectorAdServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PcaConnectorAdException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final PcaConnectorAdServiceClientConfiguration serviceClientConfiguration() {
        return new PcaConnectorAdServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTemplateGroupAccessControlEntry$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTemplate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTemplates$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTemplateGroupAccessControlEntries$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServicePrincipalNames$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDirectoryRegistrations$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectors$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemplateGroupAccessControlEntry$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemplate$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServicePrincipalName$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDirectoryRegistration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnector$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTemplateGroupAccessControlEntry$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTemplate$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServicePrincipalName$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectoryRegistration$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnector$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTemplateGroupAccessControlEntry$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTemplate$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createServicePrincipalName$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectoryRegistration$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnector$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

