/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorad.PcaConnectorAdAsyncClient;
import software.amazon.awssdk.services.pcaconnectorad.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.ListDirectoryRegistrationsResponse;

public class ListDirectoryRegistrationsPublisher
implements SdkPublisher<ListDirectoryRegistrationsResponse> {
    private final PcaConnectorAdAsyncClient client;
    private final ListDirectoryRegistrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDirectoryRegistrationsPublisher(PcaConnectorAdAsyncClient client, ListDirectoryRegistrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDirectoryRegistrationsPublisher(PcaConnectorAdAsyncClient client, ListDirectoryRegistrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDirectoryRegistrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDirectoryRegistrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DirectoryRegistrationSummary> directoryRegistrations() {
        Function<ListDirectoryRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.directoryRegistrations() != null) {
                return response.directoryRegistrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDirectoryRegistrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDirectoryRegistrationsResponseFetcher
    implements AsyncPageFetcher<ListDirectoryRegistrationsResponse> {
        private ListDirectoryRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoryRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDirectoryRegistrationsResponse> nextPage(ListDirectoryRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoryRegistrationsPublisher.this.client.listDirectoryRegistrations(ListDirectoryRegistrationsPublisher.this.firstRequest);
            }
            return ListDirectoryRegistrationsPublisher.this.client.listDirectoryRegistrations((ListDirectoryRegistrationsRequest)((Object)ListDirectoryRegistrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

