/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.ServicePrincipalNameStatus;
import software.amazon.awssdk.services.pcaconnectorad.model.ServicePrincipalNameStatusReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServicePrincipalName
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServicePrincipalName> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorArn").getter(ServicePrincipalName.getter(ServicePrincipalName::connectorArn)).setter(ServicePrincipalName.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ServicePrincipalName.getter(ServicePrincipalName::createdAt)).setter(ServicePrincipalName.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DIRECTORY_REGISTRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryRegistrationArn").getter(ServicePrincipalName.getter(ServicePrincipalName::directoryRegistrationArn)).setter(ServicePrincipalName.setter(Builder::directoryRegistrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryRegistrationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ServicePrincipalName.getter(ServicePrincipalName::statusAsString)).setter(ServicePrincipalName.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ServicePrincipalName.getter(ServicePrincipalName::statusReasonAsString)).setter(ServicePrincipalName.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ServicePrincipalName.getter(ServicePrincipalName::updatedAt)).setter(ServicePrincipalName.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, CREATED_AT_FIELD, DIRECTORY_REGISTRATION_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectorArn;
    private final Instant createdAt;
    private final String directoryRegistrationArn;
    private final String status;
    private final String statusReason;
    private final Instant updatedAt;

    private ServicePrincipalName(BuilderImpl builder) {
        this.connectorArn = builder.connectorArn;
        this.createdAt = builder.createdAt;
        this.directoryRegistrationArn = builder.directoryRegistrationArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String directoryRegistrationArn() {
        return this.directoryRegistrationArn;
    }

    public final ServicePrincipalNameStatus status() {
        return ServicePrincipalNameStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ServicePrincipalNameStatusReason statusReason() {
        return ServicePrincipalNameStatusReason.fromValue(this.statusReason);
    }

    public final String statusReasonAsString() {
        return this.statusReason;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryRegistrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServicePrincipalName)) {
            return false;
        }
        ServicePrincipalName other = (ServicePrincipalName)obj;
        return Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.directoryRegistrationArn(), other.directoryRegistrationArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReasonAsString(), other.statusReasonAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ServicePrincipalName").add("ConnectorArn", (Object)this.connectorArn()).add("CreatedAt", (Object)this.createdAt()).add("DirectoryRegistrationArn", (Object)this.directoryRegistrationArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReasonAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DirectoryRegistrationArn": {
                return Optional.ofNullable(clazz.cast(this.directoryRegistrationArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReasonAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServicePrincipalName, T> g) {
        return obj -> g.apply((ServicePrincipalName)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorArn;
        private Instant createdAt;
        private String directoryRegistrationArn;
        private String status;
        private String statusReason;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServicePrincipalName model) {
            this.connectorArn(model.connectorArn);
            this.createdAt(model.createdAt);
            this.directoryRegistrationArn(model.directoryRegistrationArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.updatedAt(model.updatedAt);
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDirectoryRegistrationArn() {
            return this.directoryRegistrationArn;
        }

        public final void setDirectoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
        }

        @Override
        public final Builder directoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServicePrincipalNameStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ServicePrincipalNameStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ServicePrincipalName build() {
            return new ServicePrincipalName(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServicePrincipalName> {
        public Builder connectorArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder directoryRegistrationArn(String var1);

        public Builder status(String var1);

        public Builder status(ServicePrincipalNameStatus var1);

        public Builder statusReason(String var1);

        public Builder statusReason(ServicePrincipalNameStatusReason var1);

        public Builder updatedAt(Instant var1);
    }
}

