/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.WrappedKeyMaterialFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WrappedWorkingKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WrappedWorkingKey> {
    private static final SdkField<String> WRAPPED_KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyMaterial").getter(WrappedWorkingKey.getter(WrappedWorkingKey::wrappedKeyMaterial)).setter(WrappedWorkingKey.setter(Builder::wrappedKeyMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterial").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValue").getter(WrappedWorkingKey.getter(WrappedWorkingKey::keyCheckValue)).setter(WrappedWorkingKey.setter(Builder::keyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()}).build();
    private static final SdkField<String> WRAPPED_KEY_MATERIAL_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyMaterialFormat").getter(WrappedWorkingKey.getter(WrappedWorkingKey::wrappedKeyMaterialFormatAsString)).setter(WrappedWorkingKey.setter(Builder::wrappedKeyMaterialFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterialFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPED_KEY_MATERIAL_FIELD, KEY_CHECK_VALUE_FIELD, WRAPPED_KEY_MATERIAL_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WrappedWorkingKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String wrappedKeyMaterial;
    private final String keyCheckValue;
    private final String wrappedKeyMaterialFormat;

    private WrappedWorkingKey(BuilderImpl builder) {
        this.wrappedKeyMaterial = builder.wrappedKeyMaterial;
        this.keyCheckValue = builder.keyCheckValue;
        this.wrappedKeyMaterialFormat = builder.wrappedKeyMaterialFormat;
    }

    public final String wrappedKeyMaterial() {
        return this.wrappedKeyMaterial;
    }

    public final String keyCheckValue() {
        return this.keyCheckValue;
    }

    public final WrappedKeyMaterialFormat wrappedKeyMaterialFormat() {
        return WrappedKeyMaterialFormat.fromValue(this.wrappedKeyMaterialFormat);
    }

    public final String wrappedKeyMaterialFormatAsString() {
        return this.wrappedKeyMaterialFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyMaterialFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrappedWorkingKey)) {
            return false;
        }
        WrappedWorkingKey other = (WrappedWorkingKey)obj;
        return Objects.equals(this.wrappedKeyMaterial(), other.wrappedKeyMaterial()) && Objects.equals(this.keyCheckValue(), other.keyCheckValue()) && Objects.equals(this.wrappedKeyMaterialFormatAsString(), other.wrappedKeyMaterialFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WrappedWorkingKey").add("WrappedKeyMaterial", (Object)(this.wrappedKeyMaterial() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyCheckValue", (Object)this.keyCheckValue()).add("WrappedKeyMaterialFormat", (Object)this.wrappedKeyMaterialFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WrappedKeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyMaterial()));
            }
            case "KeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValue()));
            }
            case "WrappedKeyMaterialFormat": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyMaterialFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WrappedKeyMaterial", WRAPPED_KEY_MATERIAL_FIELD);
        map.put("KeyCheckValue", KEY_CHECK_VALUE_FIELD);
        map.put("WrappedKeyMaterialFormat", WRAPPED_KEY_MATERIAL_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WrappedWorkingKey, T> g) {
        return obj -> g.apply((WrappedWorkingKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String wrappedKeyMaterial;
        private String keyCheckValue;
        private String wrappedKeyMaterialFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(WrappedWorkingKey model) {
            this.wrappedKeyMaterial(model.wrappedKeyMaterial);
            this.keyCheckValue(model.keyCheckValue);
            this.wrappedKeyMaterialFormat(model.wrappedKeyMaterialFormat);
        }

        public final String getWrappedKeyMaterial() {
            return this.wrappedKeyMaterial;
        }

        public final void setWrappedKeyMaterial(String wrappedKeyMaterial) {
            this.wrappedKeyMaterial = wrappedKeyMaterial;
        }

        @Override
        public final Builder wrappedKeyMaterial(String wrappedKeyMaterial) {
            this.wrappedKeyMaterial = wrappedKeyMaterial;
            return this;
        }

        public final String getKeyCheckValue() {
            return this.keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final String getWrappedKeyMaterialFormat() {
            return this.wrappedKeyMaterialFormat;
        }

        public final void setWrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
            return this;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat(wrappedKeyMaterialFormat == null ? null : wrappedKeyMaterialFormat.toString());
            return this;
        }

        public WrappedWorkingKey build() {
            return new WrappedWorkingKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WrappedWorkingKey> {
        public Builder wrappedKeyMaterial(String var1);

        public Builder keyCheckValue(String var1);

        public Builder wrappedKeyMaterialFormat(String var1);

        public Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat var1);
    }
}

