/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.As2805PekDerivationAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.TranslationIsoFormats;
import software.amazon.awssdk.services.paymentcryptographydata.model.WrappedKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslatePinDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, TranslatePinDataRequest> {
    private static final SdkField<String> INCOMING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncomingKeyIdentifier").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::incomingKeyIdentifier)).setter(TranslatePinDataRequest.setter(Builder::incomingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingKeyIdentifier").build()}).build();
    private static final SdkField<String> OUTGOING_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutgoingKeyIdentifier").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::outgoingKeyIdentifier)).setter(TranslatePinDataRequest.setter(Builder::outgoingKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingKeyIdentifier").build()}).build();
    private static final SdkField<TranslationIsoFormats> INCOMING_TRANSLATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncomingTranslationAttributes").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::incomingTranslationAttributes)).setter(TranslatePinDataRequest.setter(Builder::incomingTranslationAttributes)).constructor(TranslationIsoFormats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingTranslationAttributes").build()}).build();
    private static final SdkField<TranslationIsoFormats> OUTGOING_TRANSLATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutgoingTranslationAttributes").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::outgoingTranslationAttributes)).setter(TranslatePinDataRequest.setter(Builder::outgoingTranslationAttributes)).constructor(TranslationIsoFormats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingTranslationAttributes").build()}).build();
    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedPinBlock").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::encryptedPinBlock)).setter(TranslatePinDataRequest.setter(Builder::encryptedPinBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()}).build();
    private static final SdkField<DukptDerivationAttributes> INCOMING_DUKPT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncomingDukptAttributes").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::incomingDukptAttributes)).setter(TranslatePinDataRequest.setter(Builder::incomingDukptAttributes)).constructor(DukptDerivationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingDukptAttributes").build()}).build();
    private static final SdkField<DukptDerivationAttributes> OUTGOING_DUKPT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutgoingDukptAttributes").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::outgoingDukptAttributes)).setter(TranslatePinDataRequest.setter(Builder::outgoingDukptAttributes)).constructor(DukptDerivationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingDukptAttributes").build()}).build();
    private static final SdkField<WrappedKey> INCOMING_WRAPPED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncomingWrappedKey").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::incomingWrappedKey)).setter(TranslatePinDataRequest.setter(Builder::incomingWrappedKey)).constructor(WrappedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingWrappedKey").build()}).build();
    private static final SdkField<WrappedKey> OUTGOING_WRAPPED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutgoingWrappedKey").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::outgoingWrappedKey)).setter(TranslatePinDataRequest.setter(Builder::outgoingWrappedKey)).constructor(WrappedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingWrappedKey").build()}).build();
    private static final SdkField<As2805PekDerivationAttributes> INCOMING_AS2805_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncomingAs2805Attributes").getter(TranslatePinDataRequest.getter(TranslatePinDataRequest::incomingAs2805Attributes)).setter(TranslatePinDataRequest.setter(Builder::incomingAs2805Attributes)).constructor(As2805PekDerivationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingAs2805Attributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCOMING_KEY_IDENTIFIER_FIELD, OUTGOING_KEY_IDENTIFIER_FIELD, INCOMING_TRANSLATION_ATTRIBUTES_FIELD, OUTGOING_TRANSLATION_ATTRIBUTES_FIELD, ENCRYPTED_PIN_BLOCK_FIELD, INCOMING_DUKPT_ATTRIBUTES_FIELD, OUTGOING_DUKPT_ATTRIBUTES_FIELD, INCOMING_WRAPPED_KEY_FIELD, OUTGOING_WRAPPED_KEY_FIELD, INCOMING_AS2805_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TranslatePinDataRequest.memberNameToFieldInitializer();
    private final String incomingKeyIdentifier;
    private final String outgoingKeyIdentifier;
    private final TranslationIsoFormats incomingTranslationAttributes;
    private final TranslationIsoFormats outgoingTranslationAttributes;
    private final String encryptedPinBlock;
    private final DukptDerivationAttributes incomingDukptAttributes;
    private final DukptDerivationAttributes outgoingDukptAttributes;
    private final WrappedKey incomingWrappedKey;
    private final WrappedKey outgoingWrappedKey;
    private final As2805PekDerivationAttributes incomingAs2805Attributes;

    private TranslatePinDataRequest(BuilderImpl builder) {
        super(builder);
        this.incomingKeyIdentifier = builder.incomingKeyIdentifier;
        this.outgoingKeyIdentifier = builder.outgoingKeyIdentifier;
        this.incomingTranslationAttributes = builder.incomingTranslationAttributes;
        this.outgoingTranslationAttributes = builder.outgoingTranslationAttributes;
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.incomingDukptAttributes = builder.incomingDukptAttributes;
        this.outgoingDukptAttributes = builder.outgoingDukptAttributes;
        this.incomingWrappedKey = builder.incomingWrappedKey;
        this.outgoingWrappedKey = builder.outgoingWrappedKey;
        this.incomingAs2805Attributes = builder.incomingAs2805Attributes;
    }

    public final String incomingKeyIdentifier() {
        return this.incomingKeyIdentifier;
    }

    public final String outgoingKeyIdentifier() {
        return this.outgoingKeyIdentifier;
    }

    public final TranslationIsoFormats incomingTranslationAttributes() {
        return this.incomingTranslationAttributes;
    }

    public final TranslationIsoFormats outgoingTranslationAttributes() {
        return this.outgoingTranslationAttributes;
    }

    public final String encryptedPinBlock() {
        return this.encryptedPinBlock;
    }

    public final DukptDerivationAttributes incomingDukptAttributes() {
        return this.incomingDukptAttributes;
    }

    public final DukptDerivationAttributes outgoingDukptAttributes() {
        return this.outgoingDukptAttributes;
    }

    public final WrappedKey incomingWrappedKey() {
        return this.incomingWrappedKey;
    }

    public final WrappedKey outgoingWrappedKey() {
        return this.outgoingWrappedKey;
    }

    public final As2805PekDerivationAttributes incomingAs2805Attributes() {
        return this.incomingAs2805Attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingTranslationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingTranslationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingDukptAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingDukptAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingWrappedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.outgoingWrappedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.incomingAs2805Attributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslatePinDataRequest)) {
            return false;
        }
        TranslatePinDataRequest other = (TranslatePinDataRequest)((Object)obj);
        return Objects.equals(this.incomingKeyIdentifier(), other.incomingKeyIdentifier()) && Objects.equals(this.outgoingKeyIdentifier(), other.outgoingKeyIdentifier()) && Objects.equals(this.incomingTranslationAttributes(), other.incomingTranslationAttributes()) && Objects.equals(this.outgoingTranslationAttributes(), other.outgoingTranslationAttributes()) && Objects.equals(this.encryptedPinBlock(), other.encryptedPinBlock()) && Objects.equals(this.incomingDukptAttributes(), other.incomingDukptAttributes()) && Objects.equals(this.outgoingDukptAttributes(), other.outgoingDukptAttributes()) && Objects.equals(this.incomingWrappedKey(), other.incomingWrappedKey()) && Objects.equals(this.outgoingWrappedKey(), other.outgoingWrappedKey()) && Objects.equals(this.incomingAs2805Attributes(), other.incomingAs2805Attributes());
    }

    public final String toString() {
        return ToString.builder((String)"TranslatePinDataRequest").add("IncomingKeyIdentifier", (Object)this.incomingKeyIdentifier()).add("OutgoingKeyIdentifier", (Object)this.outgoingKeyIdentifier()).add("IncomingTranslationAttributes", (Object)this.incomingTranslationAttributes()).add("OutgoingTranslationAttributes", (Object)this.outgoingTranslationAttributes()).add("EncryptedPinBlock", (Object)(this.encryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")).add("IncomingDukptAttributes", (Object)this.incomingDukptAttributes()).add("OutgoingDukptAttributes", (Object)this.outgoingDukptAttributes()).add("IncomingWrappedKey", (Object)this.incomingWrappedKey()).add("OutgoingWrappedKey", (Object)this.outgoingWrappedKey()).add("IncomingAs2805Attributes", (Object)this.incomingAs2805Attributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncomingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.incomingKeyIdentifier()));
            }
            case "OutgoingKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outgoingKeyIdentifier()));
            }
            case "IncomingTranslationAttributes": {
                return Optional.ofNullable(clazz.cast(this.incomingTranslationAttributes()));
            }
            case "OutgoingTranslationAttributes": {
                return Optional.ofNullable(clazz.cast(this.outgoingTranslationAttributes()));
            }
            case "EncryptedPinBlock": {
                return Optional.ofNullable(clazz.cast(this.encryptedPinBlock()));
            }
            case "IncomingDukptAttributes": {
                return Optional.ofNullable(clazz.cast(this.incomingDukptAttributes()));
            }
            case "OutgoingDukptAttributes": {
                return Optional.ofNullable(clazz.cast(this.outgoingDukptAttributes()));
            }
            case "IncomingWrappedKey": {
                return Optional.ofNullable(clazz.cast(this.incomingWrappedKey()));
            }
            case "OutgoingWrappedKey": {
                return Optional.ofNullable(clazz.cast(this.outgoingWrappedKey()));
            }
            case "IncomingAs2805Attributes": {
                return Optional.ofNullable(clazz.cast(this.incomingAs2805Attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IncomingKeyIdentifier", INCOMING_KEY_IDENTIFIER_FIELD);
        map.put("OutgoingKeyIdentifier", OUTGOING_KEY_IDENTIFIER_FIELD);
        map.put("IncomingTranslationAttributes", INCOMING_TRANSLATION_ATTRIBUTES_FIELD);
        map.put("OutgoingTranslationAttributes", OUTGOING_TRANSLATION_ATTRIBUTES_FIELD);
        map.put("EncryptedPinBlock", ENCRYPTED_PIN_BLOCK_FIELD);
        map.put("IncomingDukptAttributes", INCOMING_DUKPT_ATTRIBUTES_FIELD);
        map.put("OutgoingDukptAttributes", OUTGOING_DUKPT_ATTRIBUTES_FIELD);
        map.put("IncomingWrappedKey", INCOMING_WRAPPED_KEY_FIELD);
        map.put("OutgoingWrappedKey", OUTGOING_WRAPPED_KEY_FIELD);
        map.put("IncomingAs2805Attributes", INCOMING_AS2805_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranslatePinDataRequest, T> g) {
        return obj -> g.apply((TranslatePinDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String incomingKeyIdentifier;
        private String outgoingKeyIdentifier;
        private TranslationIsoFormats incomingTranslationAttributes;
        private TranslationIsoFormats outgoingTranslationAttributes;
        private String encryptedPinBlock;
        private DukptDerivationAttributes incomingDukptAttributes;
        private DukptDerivationAttributes outgoingDukptAttributes;
        private WrappedKey incomingWrappedKey;
        private WrappedKey outgoingWrappedKey;
        private As2805PekDerivationAttributes incomingAs2805Attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslatePinDataRequest model) {
            super(model);
            this.incomingKeyIdentifier(model.incomingKeyIdentifier);
            this.outgoingKeyIdentifier(model.outgoingKeyIdentifier);
            this.incomingTranslationAttributes(model.incomingTranslationAttributes);
            this.outgoingTranslationAttributes(model.outgoingTranslationAttributes);
            this.encryptedPinBlock(model.encryptedPinBlock);
            this.incomingDukptAttributes(model.incomingDukptAttributes);
            this.outgoingDukptAttributes(model.outgoingDukptAttributes);
            this.incomingWrappedKey(model.incomingWrappedKey);
            this.outgoingWrappedKey(model.outgoingWrappedKey);
            this.incomingAs2805Attributes(model.incomingAs2805Attributes);
        }

        public final String getIncomingKeyIdentifier() {
            return this.incomingKeyIdentifier;
        }

        public final void setIncomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
        }

        @Override
        public final Builder incomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
            return this;
        }

        public final String getOutgoingKeyIdentifier() {
            return this.outgoingKeyIdentifier;
        }

        public final void setOutgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
        }

        @Override
        public final Builder outgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
            return this;
        }

        public final TranslationIsoFormats.Builder getIncomingTranslationAttributes() {
            return this.incomingTranslationAttributes != null ? this.incomingTranslationAttributes.toBuilder() : null;
        }

        public final void setIncomingTranslationAttributes(TranslationIsoFormats.BuilderImpl incomingTranslationAttributes) {
            this.incomingTranslationAttributes = incomingTranslationAttributes != null ? incomingTranslationAttributes.build() : null;
        }

        @Override
        public final Builder incomingTranslationAttributes(TranslationIsoFormats incomingTranslationAttributes) {
            this.incomingTranslationAttributes = incomingTranslationAttributes;
            return this;
        }

        public final TranslationIsoFormats.Builder getOutgoingTranslationAttributes() {
            return this.outgoingTranslationAttributes != null ? this.outgoingTranslationAttributes.toBuilder() : null;
        }

        public final void setOutgoingTranslationAttributes(TranslationIsoFormats.BuilderImpl outgoingTranslationAttributes) {
            this.outgoingTranslationAttributes = outgoingTranslationAttributes != null ? outgoingTranslationAttributes.build() : null;
        }

        @Override
        public final Builder outgoingTranslationAttributes(TranslationIsoFormats outgoingTranslationAttributes) {
            this.outgoingTranslationAttributes = outgoingTranslationAttributes;
            return this;
        }

        public final String getEncryptedPinBlock() {
            return this.encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final DukptDerivationAttributes.Builder getIncomingDukptAttributes() {
            return this.incomingDukptAttributes != null ? this.incomingDukptAttributes.toBuilder() : null;
        }

        public final void setIncomingDukptAttributes(DukptDerivationAttributes.BuilderImpl incomingDukptAttributes) {
            this.incomingDukptAttributes = incomingDukptAttributes != null ? incomingDukptAttributes.build() : null;
        }

        @Override
        public final Builder incomingDukptAttributes(DukptDerivationAttributes incomingDukptAttributes) {
            this.incomingDukptAttributes = incomingDukptAttributes;
            return this;
        }

        public final DukptDerivationAttributes.Builder getOutgoingDukptAttributes() {
            return this.outgoingDukptAttributes != null ? this.outgoingDukptAttributes.toBuilder() : null;
        }

        public final void setOutgoingDukptAttributes(DukptDerivationAttributes.BuilderImpl outgoingDukptAttributes) {
            this.outgoingDukptAttributes = outgoingDukptAttributes != null ? outgoingDukptAttributes.build() : null;
        }

        @Override
        public final Builder outgoingDukptAttributes(DukptDerivationAttributes outgoingDukptAttributes) {
            this.outgoingDukptAttributes = outgoingDukptAttributes;
            return this;
        }

        public final WrappedKey.Builder getIncomingWrappedKey() {
            return this.incomingWrappedKey != null ? this.incomingWrappedKey.toBuilder() : null;
        }

        public final void setIncomingWrappedKey(WrappedKey.BuilderImpl incomingWrappedKey) {
            this.incomingWrappedKey = incomingWrappedKey != null ? incomingWrappedKey.build() : null;
        }

        @Override
        public final Builder incomingWrappedKey(WrappedKey incomingWrappedKey) {
            this.incomingWrappedKey = incomingWrappedKey;
            return this;
        }

        public final WrappedKey.Builder getOutgoingWrappedKey() {
            return this.outgoingWrappedKey != null ? this.outgoingWrappedKey.toBuilder() : null;
        }

        public final void setOutgoingWrappedKey(WrappedKey.BuilderImpl outgoingWrappedKey) {
            this.outgoingWrappedKey = outgoingWrappedKey != null ? outgoingWrappedKey.build() : null;
        }

        @Override
        public final Builder outgoingWrappedKey(WrappedKey outgoingWrappedKey) {
            this.outgoingWrappedKey = outgoingWrappedKey;
            return this;
        }

        public final As2805PekDerivationAttributes.Builder getIncomingAs2805Attributes() {
            return this.incomingAs2805Attributes != null ? this.incomingAs2805Attributes.toBuilder() : null;
        }

        public final void setIncomingAs2805Attributes(As2805PekDerivationAttributes.BuilderImpl incomingAs2805Attributes) {
            this.incomingAs2805Attributes = incomingAs2805Attributes != null ? incomingAs2805Attributes.build() : null;
        }

        @Override
        public final Builder incomingAs2805Attributes(As2805PekDerivationAttributes incomingAs2805Attributes) {
            this.incomingAs2805Attributes = incomingAs2805Attributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TranslatePinDataRequest build() {
            return new TranslatePinDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TranslatePinDataRequest> {
        public Builder incomingKeyIdentifier(String var1);

        public Builder outgoingKeyIdentifier(String var1);

        public Builder incomingTranslationAttributes(TranslationIsoFormats var1);

        default public Builder incomingTranslationAttributes(Consumer<TranslationIsoFormats.Builder> incomingTranslationAttributes) {
            return this.incomingTranslationAttributes((TranslationIsoFormats)((TranslationIsoFormats.Builder)TranslationIsoFormats.builder().applyMutation(incomingTranslationAttributes)).build());
        }

        public Builder outgoingTranslationAttributes(TranslationIsoFormats var1);

        default public Builder outgoingTranslationAttributes(Consumer<TranslationIsoFormats.Builder> outgoingTranslationAttributes) {
            return this.outgoingTranslationAttributes((TranslationIsoFormats)((TranslationIsoFormats.Builder)TranslationIsoFormats.builder().applyMutation(outgoingTranslationAttributes)).build());
        }

        public Builder encryptedPinBlock(String var1);

        public Builder incomingDukptAttributes(DukptDerivationAttributes var1);

        default public Builder incomingDukptAttributes(Consumer<DukptDerivationAttributes.Builder> incomingDukptAttributes) {
            return this.incomingDukptAttributes((DukptDerivationAttributes)((DukptDerivationAttributes.Builder)DukptDerivationAttributes.builder().applyMutation(incomingDukptAttributes)).build());
        }

        public Builder outgoingDukptAttributes(DukptDerivationAttributes var1);

        default public Builder outgoingDukptAttributes(Consumer<DukptDerivationAttributes.Builder> outgoingDukptAttributes) {
            return this.outgoingDukptAttributes((DukptDerivationAttributes)((DukptDerivationAttributes.Builder)DukptDerivationAttributes.builder().applyMutation(outgoingDukptAttributes)).build());
        }

        public Builder incomingWrappedKey(WrappedKey var1);

        default public Builder incomingWrappedKey(Consumer<WrappedKey.Builder> incomingWrappedKey) {
            return this.incomingWrappedKey((WrappedKey)((WrappedKey.Builder)WrappedKey.builder().applyMutation(incomingWrappedKey)).build());
        }

        public Builder outgoingWrappedKey(WrappedKey var1);

        default public Builder outgoingWrappedKey(Consumer<WrappedKey.Builder> outgoingWrappedKey) {
            return this.outgoingWrappedKey((WrappedKey)((WrappedKey.Builder)WrappedKey.builder().applyMutation(outgoingWrappedKey)).build());
        }

        public Builder incomingAs2805Attributes(As2805PekDerivationAttributes var1);

        default public Builder incomingAs2805Attributes(Consumer<As2805PekDerivationAttributes.Builder> incomingAs2805Attributes) {
            return this.incomingAs2805Attributes((As2805PekDerivationAttributes)((As2805PekDerivationAttributes.Builder)As2805PekDerivationAttributes.builder().applyMutation(incomingAs2805Attributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

