/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.As2805KekValidationType;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.RandomKeySendVariantMask;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateAs2805KekValidationRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, GenerateAs2805KekValidationRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(GenerateAs2805KekValidationRequest.getter(GenerateAs2805KekValidationRequest::keyIdentifier)).setter(GenerateAs2805KekValidationRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<As2805KekValidationType> KEK_VALIDATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KekValidationType").getter(GenerateAs2805KekValidationRequest.getter(GenerateAs2805KekValidationRequest::kekValidationType)).setter(GenerateAs2805KekValidationRequest.setter(Builder::kekValidationType)).constructor(As2805KekValidationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KekValidationType").build()}).build();
    private static final SdkField<String> RANDOM_KEY_SEND_VARIANT_MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RandomKeySendVariantMask").getter(GenerateAs2805KekValidationRequest.getter(GenerateAs2805KekValidationRequest::randomKeySendVariantMaskAsString)).setter(GenerateAs2805KekValidationRequest.setter(Builder::randomKeySendVariantMask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RandomKeySendVariantMask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, KEK_VALIDATION_TYPE_FIELD, RANDOM_KEY_SEND_VARIANT_MASK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateAs2805KekValidationRequest.memberNameToFieldInitializer();
    private final String keyIdentifier;
    private final As2805KekValidationType kekValidationType;
    private final String randomKeySendVariantMask;

    private GenerateAs2805KekValidationRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.kekValidationType = builder.kekValidationType;
        this.randomKeySendVariantMask = builder.randomKeySendVariantMask;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final As2805KekValidationType kekValidationType() {
        return this.kekValidationType;
    }

    public final RandomKeySendVariantMask randomKeySendVariantMask() {
        return RandomKeySendVariantMask.fromValue(this.randomKeySendVariantMask);
    }

    public final String randomKeySendVariantMaskAsString() {
        return this.randomKeySendVariantMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.kekValidationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomKeySendVariantMaskAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateAs2805KekValidationRequest)) {
            return false;
        }
        GenerateAs2805KekValidationRequest other = (GenerateAs2805KekValidationRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.kekValidationType(), other.kekValidationType()) && Objects.equals(this.randomKeySendVariantMaskAsString(), other.randomKeySendVariantMaskAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateAs2805KekValidationRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("KekValidationType", (Object)this.kekValidationType()).add("RandomKeySendVariantMask", (Object)this.randomKeySendVariantMaskAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "KekValidationType": {
                return Optional.ofNullable(clazz.cast(this.kekValidationType()));
            }
            case "RandomKeySendVariantMask": {
                return Optional.ofNullable(clazz.cast(this.randomKeySendVariantMaskAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyIdentifier", KEY_IDENTIFIER_FIELD);
        map.put("KekValidationType", KEK_VALIDATION_TYPE_FIELD);
        map.put("RandomKeySendVariantMask", RANDOM_KEY_SEND_VARIANT_MASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateAs2805KekValidationRequest, T> g) {
        return obj -> g.apply((GenerateAs2805KekValidationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private As2805KekValidationType kekValidationType;
        private String randomKeySendVariantMask;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateAs2805KekValidationRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.kekValidationType(model.kekValidationType);
            this.randomKeySendVariantMask(model.randomKeySendVariantMask);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final As2805KekValidationType.Builder getKekValidationType() {
            return this.kekValidationType != null ? this.kekValidationType.toBuilder() : null;
        }

        public final void setKekValidationType(As2805KekValidationType.BuilderImpl kekValidationType) {
            this.kekValidationType = kekValidationType != null ? kekValidationType.build() : null;
        }

        @Override
        public final Builder kekValidationType(As2805KekValidationType kekValidationType) {
            this.kekValidationType = kekValidationType;
            return this;
        }

        public final String getRandomKeySendVariantMask() {
            return this.randomKeySendVariantMask;
        }

        public final void setRandomKeySendVariantMask(String randomKeySendVariantMask) {
            this.randomKeySendVariantMask = randomKeySendVariantMask;
        }

        @Override
        public final Builder randomKeySendVariantMask(String randomKeySendVariantMask) {
            this.randomKeySendVariantMask = randomKeySendVariantMask;
            return this;
        }

        @Override
        public final Builder randomKeySendVariantMask(RandomKeySendVariantMask randomKeySendVariantMask) {
            this.randomKeySendVariantMask(randomKeySendVariantMask == null ? null : randomKeySendVariantMask.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateAs2805KekValidationRequest build() {
            return new GenerateAs2805KekValidationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateAs2805KekValidationRequest> {
        public Builder keyIdentifier(String var1);

        public Builder kekValidationType(As2805KekValidationType var1);

        default public Builder kekValidationType(Consumer<As2805KekValidationType.Builder> kekValidationType) {
            return this.kekValidationType((As2805KekValidationType)((As2805KekValidationType.Builder)As2805KekValidationType.builder().applyMutation(kekValidationType)).build());
        }

        public Builder randomKeySendVariantMask(String var1);

        public Builder randomKeySendVariantMask(RandomKeySendVariantMask var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

