/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameter information of the outgoing wrapped key block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WrappedWorkingKey implements SdkPojo, Serializable,
        ToCopyableBuilder<WrappedWorkingKey.Builder, WrappedWorkingKey> {
    private static final SdkField<String> WRAPPED_KEY_MATERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappedKeyMaterial").getter(getter(WrappedWorkingKey::wrappedKeyMaterial))
            .setter(setter(Builder::wrappedKeyMaterial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterial").build())
            .build();

    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValue").getter(getter(WrappedWorkingKey::keyCheckValue)).setter(setter(Builder::keyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()).build();

    private static final SdkField<String> WRAPPED_KEY_MATERIAL_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappedKeyMaterialFormat").getter(getter(WrappedWorkingKey::wrappedKeyMaterialFormatAsString))
            .setter(setter(Builder::wrappedKeyMaterialFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterialFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPED_KEY_MATERIAL_FIELD,
            KEY_CHECK_VALUE_FIELD, WRAPPED_KEY_MATERIAL_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String wrappedKeyMaterial;

    private final String keyCheckValue;

    private final String wrappedKeyMaterialFormat;

    private WrappedWorkingKey(BuilderImpl builder) {
        this.wrappedKeyMaterial = builder.wrappedKeyMaterial;
        this.keyCheckValue = builder.keyCheckValue;
        this.wrappedKeyMaterialFormat = builder.wrappedKeyMaterialFormat;
    }

    /**
     * <p>
     * The wrapped key block of the outgoing transaction key.
     * </p>
     * 
     * @return The wrapped key block of the outgoing transaction key.
     */
    public final String wrappedKeyMaterial() {
        return wrappedKeyMaterial;
    }

    /**
     * <p>
     * The key check value (KCV) of the key contained within the outgoing TR31WrappedKeyBlock.
     * </p>
     * <p>
     * The KCV is used to check if all parties holding a given key have the same key or to detect that a key has
     * changed. For more information on KCV, see <a
     * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/terminology.html#terms.kcv">KCV</a> in
     * the <i>Amazon Web Services Payment Cryptography User Guide</i>.
     * </p>
     * 
     * @return The key check value (KCV) of the key contained within the outgoing TR31WrappedKeyBlock.</p>
     *         <p>
     *         The KCV is used to check if all parties holding a given key have the same key or to detect that a key has
     *         changed. For more information on KCV, see <a
     *         href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/terminology.html#terms.kcv"
     *         >KCV</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.
     */
    public final String keyCheckValue() {
        return keyCheckValue;
    }

    /**
     * <p>
     * The key block format of the wrapped key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wrappedKeyMaterialFormat} will return {@link WrappedKeyMaterialFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #wrappedKeyMaterialFormatAsString}.
     * </p>
     * 
     * @return The key block format of the wrapped key.
     * @see WrappedKeyMaterialFormat
     */
    public final WrappedKeyMaterialFormat wrappedKeyMaterialFormat() {
        return WrappedKeyMaterialFormat.fromValue(wrappedKeyMaterialFormat);
    }

    /**
     * <p>
     * The key block format of the wrapped key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wrappedKeyMaterialFormat} will return {@link WrappedKeyMaterialFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #wrappedKeyMaterialFormatAsString}.
     * </p>
     * 
     * @return The key block format of the wrapped key.
     * @see WrappedKeyMaterialFormat
     */
    public final String wrappedKeyMaterialFormatAsString() {
        return wrappedKeyMaterialFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wrappedKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(wrappedKeyMaterialFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrappedWorkingKey)) {
            return false;
        }
        WrappedWorkingKey other = (WrappedWorkingKey) obj;
        return Objects.equals(wrappedKeyMaterial(), other.wrappedKeyMaterial())
                && Objects.equals(keyCheckValue(), other.keyCheckValue())
                && Objects.equals(wrappedKeyMaterialFormatAsString(), other.wrappedKeyMaterialFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WrappedWorkingKey")
                .add("WrappedKeyMaterial", wrappedKeyMaterial() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KeyCheckValue", keyCheckValue()).add("WrappedKeyMaterialFormat", wrappedKeyMaterialFormatAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WrappedKeyMaterial":
            return Optional.ofNullable(clazz.cast(wrappedKeyMaterial()));
        case "KeyCheckValue":
            return Optional.ofNullable(clazz.cast(keyCheckValue()));
        case "WrappedKeyMaterialFormat":
            return Optional.ofNullable(clazz.cast(wrappedKeyMaterialFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WrappedKeyMaterial", WRAPPED_KEY_MATERIAL_FIELD);
        map.put("KeyCheckValue", KEY_CHECK_VALUE_FIELD);
        map.put("WrappedKeyMaterialFormat", WRAPPED_KEY_MATERIAL_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WrappedWorkingKey, T> g) {
        return obj -> g.apply((WrappedWorkingKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WrappedWorkingKey> {
        /**
         * <p>
         * The wrapped key block of the outgoing transaction key.
         * </p>
         * 
         * @param wrappedKeyMaterial
         *        The wrapped key block of the outgoing transaction key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappedKeyMaterial(String wrappedKeyMaterial);

        /**
         * <p>
         * The key check value (KCV) of the key contained within the outgoing TR31WrappedKeyBlock.
         * </p>
         * <p>
         * The KCV is used to check if all parties holding a given key have the same key or to detect that a key has
         * changed. For more information on KCV, see <a
         * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/terminology.html#terms.kcv">KCV</a>
         * in the <i>Amazon Web Services Payment Cryptography User Guide</i>.
         * </p>
         * 
         * @param keyCheckValue
         *        The key check value (KCV) of the key contained within the outgoing TR31WrappedKeyBlock.</p>
         *        <p>
         *        The KCV is used to check if all parties holding a given key have the same key or to detect that a key
         *        has changed. For more information on KCV, see <a
         *        href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/terminology.html#terms.kcv"
         *        >KCV</a> in the <i>Amazon Web Services Payment Cryptography User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCheckValue(String keyCheckValue);

        /**
         * <p>
         * The key block format of the wrapped key.
         * </p>
         * 
         * @param wrappedKeyMaterialFormat
         *        The key block format of the wrapped key.
         * @see WrappedKeyMaterialFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrappedKeyMaterialFormat
         */
        Builder wrappedKeyMaterialFormat(String wrappedKeyMaterialFormat);

        /**
         * <p>
         * The key block format of the wrapped key.
         * </p>
         * 
         * @param wrappedKeyMaterialFormat
         *        The key block format of the wrapped key.
         * @see WrappedKeyMaterialFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrappedKeyMaterialFormat
         */
        Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat wrappedKeyMaterialFormat);
    }

    static final class BuilderImpl implements Builder {
        private String wrappedKeyMaterial;

        private String keyCheckValue;

        private String wrappedKeyMaterialFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(WrappedWorkingKey model) {
            wrappedKeyMaterial(model.wrappedKeyMaterial);
            keyCheckValue(model.keyCheckValue);
            wrappedKeyMaterialFormat(model.wrappedKeyMaterialFormat);
        }

        public final String getWrappedKeyMaterial() {
            return wrappedKeyMaterial;
        }

        public final void setWrappedKeyMaterial(String wrappedKeyMaterial) {
            this.wrappedKeyMaterial = wrappedKeyMaterial;
        }

        @Override
        public final Builder wrappedKeyMaterial(String wrappedKeyMaterial) {
            this.wrappedKeyMaterial = wrappedKeyMaterial;
            return this;
        }

        public final String getKeyCheckValue() {
            return keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final String getWrappedKeyMaterialFormat() {
            return wrappedKeyMaterialFormat;
        }

        public final void setWrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(String wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat = wrappedKeyMaterialFormat;
            return this;
        }

        @Override
        public final Builder wrappedKeyMaterialFormat(WrappedKeyMaterialFormat wrappedKeyMaterialFormat) {
            this.wrappedKeyMaterialFormat(wrappedKeyMaterialFormat == null ? null : wrappedKeyMaterialFormat.toString());
            return this;
        }

        @Override
        public WrappedWorkingKey build() {
            return new WrappedWorkingKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
