/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information of a WrappedKeyBlock for encryption key exchange.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WrappedKeyMaterial implements SdkPojo, Serializable,
        ToCopyableBuilder<WrappedKeyMaterial.Builder, WrappedKeyMaterial> {
    private static final SdkField<String> TR31_KEY_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Tr31KeyBlock").getter(getter(WrappedKeyMaterial::tr31KeyBlock)).setter(setter(Builder::tr31KeyBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr31KeyBlock").build()).build();

    private static final SdkField<EcdhDerivationAttributes> DIFFIE_HELLMAN_SYMMETRIC_KEY_FIELD = SdkField
            .<EcdhDerivationAttributes> builder(MarshallingType.SDK_POJO).memberName("DiffieHellmanSymmetricKey")
            .getter(getter(WrappedKeyMaterial::diffieHellmanSymmetricKey)).setter(setter(Builder::diffieHellmanSymmetricKey))
            .constructor(EcdhDerivationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiffieHellmanSymmetricKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TR31_KEY_BLOCK_FIELD,
            DIFFIE_HELLMAN_SYMMETRIC_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tr31KeyBlock;

    private final EcdhDerivationAttributes diffieHellmanSymmetricKey;

    private final Type type;

    private WrappedKeyMaterial(BuilderImpl builder) {
        this.tr31KeyBlock = builder.tr31KeyBlock;
        this.diffieHellmanSymmetricKey = builder.diffieHellmanSymmetricKey;
        this.type = builder.type;
    }

    /**
     * <p>
     * The TR-31 wrapped key block.
     * </p>
     * 
     * @return The TR-31 wrapped key block.
     */
    public final String tr31KeyBlock() {
        return tr31KeyBlock;
    }

    /**
     * <p>
     * The parameter information for deriving a ECDH shared key.
     * </p>
     * 
     * @return The parameter information for deriving a ECDH shared key.
     */
    public final EcdhDerivationAttributes diffieHellmanSymmetricKey() {
        return diffieHellmanSymmetricKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tr31KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(diffieHellmanSymmetricKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrappedKeyMaterial)) {
            return false;
        }
        WrappedKeyMaterial other = (WrappedKeyMaterial) obj;
        return Objects.equals(tr31KeyBlock(), other.tr31KeyBlock())
                && Objects.equals(diffieHellmanSymmetricKey(), other.diffieHellmanSymmetricKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WrappedKeyMaterial")
                .add("Tr31KeyBlock", tr31KeyBlock() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DiffieHellmanSymmetricKey", diffieHellmanSymmetricKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tr31KeyBlock":
            return Optional.ofNullable(clazz.cast(tr31KeyBlock()));
        case "DiffieHellmanSymmetricKey":
            return Optional.ofNullable(clazz.cast(diffieHellmanSymmetricKey()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * The TR-31 wrapped key block.
     * </p>
     * 
     * @param tr31KeyBlock
     *        The TR-31 wrapped key block.
     */
    public static WrappedKeyMaterial fromTr31KeyBlock(String tr31KeyBlock) {
        return builder().tr31KeyBlock(tr31KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #diffieHellmanSymmetricKey()} initialized to the given value.
     *
     * <p>
     * The parameter information for deriving a ECDH shared key.
     * </p>
     * 
     * @param diffieHellmanSymmetricKey
     *        The parameter information for deriving a ECDH shared key.
     */
    public static WrappedKeyMaterial fromDiffieHellmanSymmetricKey(EcdhDerivationAttributes diffieHellmanSymmetricKey) {
        return builder().diffieHellmanSymmetricKey(diffieHellmanSymmetricKey).build();
    }

    /**
     * Create an instance of this class with {@link #diffieHellmanSymmetricKey()} initialized to the given value.
     *
     * <p>
     * The parameter information for deriving a ECDH shared key.
     * </p>
     * 
     * @param diffieHellmanSymmetricKey
     *        The parameter information for deriving a ECDH shared key.
     */
    public static WrappedKeyMaterial fromDiffieHellmanSymmetricKey(
            Consumer<EcdhDerivationAttributes.Builder> diffieHellmanSymmetricKey) {
        EcdhDerivationAttributes.Builder builder = EcdhDerivationAttributes.builder();
        diffieHellmanSymmetricKey.accept(builder);
        return fromDiffieHellmanSymmetricKey(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tr31KeyBlock", TR31_KEY_BLOCK_FIELD);
        map.put("DiffieHellmanSymmetricKey", DIFFIE_HELLMAN_SYMMETRIC_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WrappedKeyMaterial, T> g) {
        return obj -> g.apply((WrappedKeyMaterial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WrappedKeyMaterial> {
        /**
         * <p>
         * The TR-31 wrapped key block.
         * </p>
         * 
         * @param tr31KeyBlock
         *        The TR-31 wrapped key block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tr31KeyBlock(String tr31KeyBlock);

        /**
         * <p>
         * The parameter information for deriving a ECDH shared key.
         * </p>
         * 
         * @param diffieHellmanSymmetricKey
         *        The parameter information for deriving a ECDH shared key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diffieHellmanSymmetricKey(EcdhDerivationAttributes diffieHellmanSymmetricKey);

        /**
         * <p>
         * The parameter information for deriving a ECDH shared key.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcdhDerivationAttributes.Builder}
         * avoiding the need to create one manually via {@link EcdhDerivationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcdhDerivationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #diffieHellmanSymmetricKey(EcdhDerivationAttributes)}.
         * 
         * @param diffieHellmanSymmetricKey
         *        a consumer that will call methods on {@link EcdhDerivationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diffieHellmanSymmetricKey(EcdhDerivationAttributes)
         */
        default Builder diffieHellmanSymmetricKey(Consumer<EcdhDerivationAttributes.Builder> diffieHellmanSymmetricKey) {
            return diffieHellmanSymmetricKey(EcdhDerivationAttributes.builder().applyMutation(diffieHellmanSymmetricKey).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tr31KeyBlock;

        private EcdhDerivationAttributes diffieHellmanSymmetricKey;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WrappedKeyMaterial model) {
            tr31KeyBlock(model.tr31KeyBlock);
            diffieHellmanSymmetricKey(model.diffieHellmanSymmetricKey);
        }

        public final String getTr31KeyBlock() {
            return tr31KeyBlock;
        }

        public final void setTr31KeyBlock(String tr31KeyBlock) {
            Object oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock;
            handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
        }

        @Override
        public final Builder tr31KeyBlock(String tr31KeyBlock) {
            Object oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock;
            handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
            return this;
        }

        public final EcdhDerivationAttributes.Builder getDiffieHellmanSymmetricKey() {
            return diffieHellmanSymmetricKey != null ? diffieHellmanSymmetricKey.toBuilder() : null;
        }

        public final void setDiffieHellmanSymmetricKey(EcdhDerivationAttributes.BuilderImpl diffieHellmanSymmetricKey) {
            Object oldValue = this.diffieHellmanSymmetricKey;
            this.diffieHellmanSymmetricKey = diffieHellmanSymmetricKey != null ? diffieHellmanSymmetricKey.build() : null;
            handleUnionValueChange(Type.DIFFIE_HELLMAN_SYMMETRIC_KEY, oldValue, this.diffieHellmanSymmetricKey);
        }

        @Override
        public final Builder diffieHellmanSymmetricKey(EcdhDerivationAttributes diffieHellmanSymmetricKey) {
            Object oldValue = this.diffieHellmanSymmetricKey;
            this.diffieHellmanSymmetricKey = diffieHellmanSymmetricKey;
            handleUnionValueChange(Type.DIFFIE_HELLMAN_SYMMETRIC_KEY, oldValue, this.diffieHellmanSymmetricKey);
            return this;
        }

        @Override
        public WrappedKeyMaterial build() {
            return new WrappedKeyMaterial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WrappedKeyMaterial#type()
     */
    public enum Type {
        TR31_KEY_BLOCK,

        DIFFIE_HELLMAN_SYMMETRIC_KEY,

        UNKNOWN_TO_SDK_VERSION
    }
}
