/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslateKeyMaterialRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<TranslateKeyMaterialRequest.Builder, TranslateKeyMaterialRequest> {
    private static final SdkField<IncomingKeyMaterial> INCOMING_KEY_MATERIAL_FIELD = SdkField
            .<IncomingKeyMaterial> builder(MarshallingType.SDK_POJO).memberName("IncomingKeyMaterial")
            .getter(getter(TranslateKeyMaterialRequest::incomingKeyMaterial)).setter(setter(Builder::incomingKeyMaterial))
            .constructor(IncomingKeyMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingKeyMaterial").build())
            .build();

    private static final SdkField<OutgoingKeyMaterial> OUTGOING_KEY_MATERIAL_FIELD = SdkField
            .<OutgoingKeyMaterial> builder(MarshallingType.SDK_POJO).memberName("OutgoingKeyMaterial")
            .getter(getter(TranslateKeyMaterialRequest::outgoingKeyMaterial)).setter(setter(Builder::outgoingKeyMaterial))
            .constructor(OutgoingKeyMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingKeyMaterial").build())
            .build();

    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValueAlgorithm").getter(getter(TranslateKeyMaterialRequest::keyCheckValueAlgorithmAsString))
            .setter(setter(Builder::keyCheckValueAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCOMING_KEY_MATERIAL_FIELD,
            OUTGOING_KEY_MATERIAL_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IncomingKeyMaterial incomingKeyMaterial;

    private final OutgoingKeyMaterial outgoingKeyMaterial;

    private final String keyCheckValueAlgorithm;

    private TranslateKeyMaterialRequest(BuilderImpl builder) {
        super(builder);
        this.incomingKeyMaterial = builder.incomingKeyMaterial;
        this.outgoingKeyMaterial = builder.outgoingKeyMaterial;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
    }

    /**
     * <p>
     * Parameter information of the TR31WrappedKeyBlock containing the transaction key.
     * </p>
     * 
     * @return Parameter information of the TR31WrappedKeyBlock containing the transaction key.
     */
    public final IncomingKeyMaterial incomingKeyMaterial() {
        return incomingKeyMaterial;
    }

    /**
     * <p>
     * Parameter information of the wrapping key used to wrap the transaction key in the outgoing TR31WrappedKeyBlock.
     * </p>
     * 
     * @return Parameter information of the wrapping key used to wrap the transaction key in the outgoing
     *         TR31WrappedKeyBlock.
     */
    public final OutgoingKeyMaterial outgoingKeyMaterial() {
        return outgoingKeyMaterial;
    }

    /**
     * <p>
     * The key check value (KCV) algorithm used for calculating the KCV.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyCheckValueAlgorithm} will return {@link KeyCheckValueAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyCheckValueAlgorithmAsString}.
     * </p>
     * 
     * @return The key check value (KCV) algorithm used for calculating the KCV.
     * @see KeyCheckValueAlgorithm
     */
    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(keyCheckValueAlgorithm);
    }

    /**
     * <p>
     * The key check value (KCV) algorithm used for calculating the KCV.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyCheckValueAlgorithm} will return {@link KeyCheckValueAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyCheckValueAlgorithmAsString}.
     * </p>
     * 
     * @return The key check value (KCV) algorithm used for calculating the KCV.
     * @see KeyCheckValueAlgorithm
     */
    public final String keyCheckValueAlgorithmAsString() {
        return keyCheckValueAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(incomingKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValueAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateKeyMaterialRequest)) {
            return false;
        }
        TranslateKeyMaterialRequest other = (TranslateKeyMaterialRequest) obj;
        return Objects.equals(incomingKeyMaterial(), other.incomingKeyMaterial())
                && Objects.equals(outgoingKeyMaterial(), other.outgoingKeyMaterial())
                && Objects.equals(keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslateKeyMaterialRequest").add("IncomingKeyMaterial", incomingKeyMaterial())
                .add("OutgoingKeyMaterial", outgoingKeyMaterial())
                .add("KeyCheckValueAlgorithm", keyCheckValueAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncomingKeyMaterial":
            return Optional.ofNullable(clazz.cast(incomingKeyMaterial()));
        case "OutgoingKeyMaterial":
            return Optional.ofNullable(clazz.cast(outgoingKeyMaterial()));
        case "KeyCheckValueAlgorithm":
            return Optional.ofNullable(clazz.cast(keyCheckValueAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncomingKeyMaterial", INCOMING_KEY_MATERIAL_FIELD);
        map.put("OutgoingKeyMaterial", OUTGOING_KEY_MATERIAL_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranslateKeyMaterialRequest, T> g) {
        return obj -> g.apply((TranslateKeyMaterialRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TranslateKeyMaterialRequest> {
        /**
         * <p>
         * Parameter information of the TR31WrappedKeyBlock containing the transaction key.
         * </p>
         * 
         * @param incomingKeyMaterial
         *        Parameter information of the TR31WrappedKeyBlock containing the transaction key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingKeyMaterial(IncomingKeyMaterial incomingKeyMaterial);

        /**
         * <p>
         * Parameter information of the TR31WrappedKeyBlock containing the transaction key.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncomingKeyMaterial.Builder} avoiding the
         * need to create one manually via {@link IncomingKeyMaterial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncomingKeyMaterial.Builder#build()} is called immediately and
         * its result is passed to {@link #incomingKeyMaterial(IncomingKeyMaterial)}.
         * 
         * @param incomingKeyMaterial
         *        a consumer that will call methods on {@link IncomingKeyMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incomingKeyMaterial(IncomingKeyMaterial)
         */
        default Builder incomingKeyMaterial(Consumer<IncomingKeyMaterial.Builder> incomingKeyMaterial) {
            return incomingKeyMaterial(IncomingKeyMaterial.builder().applyMutation(incomingKeyMaterial).build());
        }

        /**
         * <p>
         * Parameter information of the wrapping key used to wrap the transaction key in the outgoing
         * TR31WrappedKeyBlock.
         * </p>
         * 
         * @param outgoingKeyMaterial
         *        Parameter information of the wrapping key used to wrap the transaction key in the outgoing
         *        TR31WrappedKeyBlock.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingKeyMaterial(OutgoingKeyMaterial outgoingKeyMaterial);

        /**
         * <p>
         * Parameter information of the wrapping key used to wrap the transaction key in the outgoing
         * TR31WrappedKeyBlock.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutgoingKeyMaterial.Builder} avoiding the
         * need to create one manually via {@link OutgoingKeyMaterial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutgoingKeyMaterial.Builder#build()} is called immediately and
         * its result is passed to {@link #outgoingKeyMaterial(OutgoingKeyMaterial)}.
         * 
         * @param outgoingKeyMaterial
         *        a consumer that will call methods on {@link OutgoingKeyMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outgoingKeyMaterial(OutgoingKeyMaterial)
         */
        default Builder outgoingKeyMaterial(Consumer<OutgoingKeyMaterial.Builder> outgoingKeyMaterial) {
            return outgoingKeyMaterial(OutgoingKeyMaterial.builder().applyMutation(outgoingKeyMaterial).build());
        }

        /**
         * <p>
         * The key check value (KCV) algorithm used for calculating the KCV.
         * </p>
         * 
         * @param keyCheckValueAlgorithm
         *        The key check value (KCV) algorithm used for calculating the KCV.
         * @see KeyCheckValueAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyCheckValueAlgorithm
         */
        Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm);

        /**
         * <p>
         * The key check value (KCV) algorithm used for calculating the KCV.
         * </p>
         * 
         * @param keyCheckValueAlgorithm
         *        The key check value (KCV) algorithm used for calculating the KCV.
         * @see KeyCheckValueAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyCheckValueAlgorithm
         */
        Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private IncomingKeyMaterial incomingKeyMaterial;

        private OutgoingKeyMaterial outgoingKeyMaterial;

        private String keyCheckValueAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateKeyMaterialRequest model) {
            super(model);
            incomingKeyMaterial(model.incomingKeyMaterial);
            outgoingKeyMaterial(model.outgoingKeyMaterial);
            keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
        }

        public final IncomingKeyMaterial.Builder getIncomingKeyMaterial() {
            return incomingKeyMaterial != null ? incomingKeyMaterial.toBuilder() : null;
        }

        public final void setIncomingKeyMaterial(IncomingKeyMaterial.BuilderImpl incomingKeyMaterial) {
            this.incomingKeyMaterial = incomingKeyMaterial != null ? incomingKeyMaterial.build() : null;
        }

        @Override
        public final Builder incomingKeyMaterial(IncomingKeyMaterial incomingKeyMaterial) {
            this.incomingKeyMaterial = incomingKeyMaterial;
            return this;
        }

        public final OutgoingKeyMaterial.Builder getOutgoingKeyMaterial() {
            return outgoingKeyMaterial != null ? outgoingKeyMaterial.toBuilder() : null;
        }

        public final void setOutgoingKeyMaterial(OutgoingKeyMaterial.BuilderImpl outgoingKeyMaterial) {
            this.outgoingKeyMaterial = outgoingKeyMaterial != null ? outgoingKeyMaterial.build() : null;
        }

        @Override
        public final Builder outgoingKeyMaterial(OutgoingKeyMaterial outgoingKeyMaterial) {
            this.outgoingKeyMaterial = outgoingKeyMaterial;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TranslateKeyMaterialRequest build() {
            return new TranslateKeyMaterialRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
