/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to derive session key for Mastercard payment card for ARQC verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionKeyMastercard implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionKeyMastercard.Builder, SessionKeyMastercard> {
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(SessionKeyMastercard::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(SessionKeyMastercard::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationTransactionCounter")
            .getter(getter(SessionKeyMastercard::applicationTransactionCounter))
            .setter(setter(Builder::applicationTransactionCounter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter")
                    .build()).build();

    private static final SdkField<String> UNPREDICTABLE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpredictableNumber").getter(getter(SessionKeyMastercard::unpredictableNumber))
            .setter(setter(Builder::unpredictableNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpredictableNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_ACCOUNT_NUMBER_FIELD,
            PAN_SEQUENCE_NUMBER_FIELD, APPLICATION_TRANSACTION_COUNTER_FIELD, UNPREDICTABLE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String primaryAccountNumber;

    private final String panSequenceNumber;

    private final String applicationTransactionCounter;

    private final String unpredictableNumber;

    private SessionKeyMastercard(BuilderImpl builder) {
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.unpredictableNumber = builder.unpredictableNumber;
    }

    /**
     * <p>
     * The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or debit
     * card and associates the card to a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or
     *         debit card and associates the card to a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * The transaction counter that is provided by the terminal during transaction processing.
     * </p>
     * 
     * @return The transaction counter that is provided by the terminal during transaction processing.
     */
    public final String applicationTransactionCounter() {
        return applicationTransactionCounter;
    }

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     * 
     * @return A random number generated by the issuer.
     */
    public final String unpredictableNumber() {
        return unpredictableNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTransactionCounter());
        hashCode = 31 * hashCode + Objects.hashCode(unpredictableNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyMastercard)) {
            return false;
        }
        SessionKeyMastercard other = (SessionKeyMastercard) obj;
        return Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(applicationTransactionCounter(), other.applicationTransactionCounter())
                && Objects.equals(unpredictableNumber(), other.unpredictableNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionKeyMastercard")
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PanSequenceNumber", panSequenceNumber())
                .add("ApplicationTransactionCounter", applicationTransactionCounter())
                .add("UnpredictableNumber", unpredictableNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "ApplicationTransactionCounter":
            return Optional.ofNullable(clazz.cast(applicationTransactionCounter()));
        case "UnpredictableNumber":
            return Optional.ofNullable(clazz.cast(unpredictableNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryAccountNumber", PRIMARY_ACCOUNT_NUMBER_FIELD);
        map.put("PanSequenceNumber", PAN_SEQUENCE_NUMBER_FIELD);
        map.put("ApplicationTransactionCounter", APPLICATION_TRANSACTION_COUNTER_FIELD);
        map.put("UnpredictableNumber", UNPREDICTABLE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyMastercard, T> g) {
        return obj -> g.apply((SessionKeyMastercard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionKeyMastercard> {
        /**
         * <p>
         * The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit or
         * debit card and associates the card to a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier for a payment credit
         *        or debit card and associates the card to a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * The transaction counter that is provided by the terminal during transaction processing.
         * </p>
         * 
         * @param applicationTransactionCounter
         *        The transaction counter that is provided by the terminal during transaction processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTransactionCounter(String applicationTransactionCounter);

        /**
         * <p>
         * A random number generated by the issuer.
         * </p>
         * 
         * @param unpredictableNumber
         *        A random number generated by the issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpredictableNumber(String unpredictableNumber);
    }

    static final class BuilderImpl implements Builder {
        private String primaryAccountNumber;

        private String panSequenceNumber;

        private String applicationTransactionCounter;

        private String unpredictableNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyMastercard model) {
            primaryAccountNumber(model.primaryAccountNumber);
            panSequenceNumber(model.panSequenceNumber);
            applicationTransactionCounter(model.applicationTransactionCounter);
            unpredictableNumber(model.unpredictableNumber);
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getApplicationTransactionCounter() {
            return applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public final String getUnpredictableNumber() {
            return unpredictableNumber;
        }

        public final void setUnpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
        }

        @Override
        public final Builder unpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
            return this;
        }

        @Override
        public SessionKeyMastercard build() {
            return new SessionKeyMastercard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
