/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for PIN data generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PinGenerationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<PinGenerationAttributes.Builder, PinGenerationAttributes> {
    private static final SdkField<VisaPin> VISA_PIN_FIELD = SdkField.<VisaPin> builder(MarshallingType.SDK_POJO)
            .memberName("VisaPin").getter(getter(PinGenerationAttributes::visaPin)).setter(setter(Builder::visaPin))
            .constructor(VisaPin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaPin").build()).build();

    private static final SdkField<VisaPinVerificationValue> VISA_PIN_VERIFICATION_VALUE_FIELD = SdkField
            .<VisaPinVerificationValue> builder(MarshallingType.SDK_POJO).memberName("VisaPinVerificationValue")
            .getter(getter(PinGenerationAttributes::visaPinVerificationValue)).setter(setter(Builder::visaPinVerificationValue))
            .constructor(VisaPinVerificationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisaPinVerificationValue").build())
            .build();

    private static final SdkField<Ibm3624PinOffset> IBM3624_PIN_OFFSET_FIELD = SdkField
            .<Ibm3624PinOffset> builder(MarshallingType.SDK_POJO).memberName("Ibm3624PinOffset")
            .getter(getter(PinGenerationAttributes::ibm3624PinOffset)).setter(setter(Builder::ibm3624PinOffset))
            .constructor(Ibm3624PinOffset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624PinOffset").build()).build();

    private static final SdkField<Ibm3624NaturalPin> IBM3624_NATURAL_PIN_FIELD = SdkField
            .<Ibm3624NaturalPin> builder(MarshallingType.SDK_POJO).memberName("Ibm3624NaturalPin")
            .getter(getter(PinGenerationAttributes::ibm3624NaturalPin)).setter(setter(Builder::ibm3624NaturalPin))
            .constructor(Ibm3624NaturalPin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624NaturalPin").build()).build();

    private static final SdkField<Ibm3624RandomPin> IBM3624_RANDOM_PIN_FIELD = SdkField
            .<Ibm3624RandomPin> builder(MarshallingType.SDK_POJO).memberName("Ibm3624RandomPin")
            .getter(getter(PinGenerationAttributes::ibm3624RandomPin)).setter(setter(Builder::ibm3624RandomPin))
            .constructor(Ibm3624RandomPin::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624RandomPin").build()).build();

    private static final SdkField<Ibm3624PinFromOffset> IBM3624_PIN_FROM_OFFSET_FIELD = SdkField
            .<Ibm3624PinFromOffset> builder(MarshallingType.SDK_POJO).memberName("Ibm3624PinFromOffset")
            .getter(getter(PinGenerationAttributes::ibm3624PinFromOffset)).setter(setter(Builder::ibm3624PinFromOffset))
            .constructor(Ibm3624PinFromOffset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ibm3624PinFromOffset").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISA_PIN_FIELD,
            VISA_PIN_VERIFICATION_VALUE_FIELD, IBM3624_PIN_OFFSET_FIELD, IBM3624_NATURAL_PIN_FIELD, IBM3624_RANDOM_PIN_FIELD,
            IBM3624_PIN_FROM_OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VisaPin visaPin;

    private final VisaPinVerificationValue visaPinVerificationValue;

    private final Ibm3624PinOffset ibm3624PinOffset;

    private final Ibm3624NaturalPin ibm3624NaturalPin;

    private final Ibm3624RandomPin ibm3624RandomPin;

    private final Ibm3624PinFromOffset ibm3624PinFromOffset;

    private final Type type;

    private PinGenerationAttributes(BuilderImpl builder) {
        this.visaPin = builder.visaPin;
        this.visaPinVerificationValue = builder.visaPinVerificationValue;
        this.ibm3624PinOffset = builder.ibm3624PinOffset;
        this.ibm3624NaturalPin = builder.ibm3624NaturalPin;
        this.ibm3624RandomPin = builder.ibm3624RandomPin;
        this.ibm3624PinFromOffset = builder.ibm3624PinFromOffset;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Visa PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Visa PIN.
     */
    public final VisaPin visaPin() {
        return visaPin;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
     * </p>
     * 
     * @return Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
     */
    public final VisaPinVerificationValue visaPinVerificationValue() {
        return visaPinVerificationValue;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
     */
    public final Ibm3624PinOffset ibm3624PinOffset() {
        return ibm3624PinOffset;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Ibm3624 natural PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Ibm3624 natural PIN.
     */
    public final Ibm3624NaturalPin ibm3624NaturalPin() {
        return ibm3624NaturalPin;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Ibm3624 random PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Ibm3624 random PIN.
     */
    public final Ibm3624RandomPin ibm3624RandomPin() {
        return ibm3624RandomPin;
    }

    /**
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
     * </p>
     * 
     * @return Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
     */
    public final Ibm3624PinFromOffset ibm3624PinFromOffset() {
        return ibm3624PinFromOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visaPin());
        hashCode = 31 * hashCode + Objects.hashCode(visaPinVerificationValue());
        hashCode = 31 * hashCode + Objects.hashCode(ibm3624PinOffset());
        hashCode = 31 * hashCode + Objects.hashCode(ibm3624NaturalPin());
        hashCode = 31 * hashCode + Objects.hashCode(ibm3624RandomPin());
        hashCode = 31 * hashCode + Objects.hashCode(ibm3624PinFromOffset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PinGenerationAttributes)) {
            return false;
        }
        PinGenerationAttributes other = (PinGenerationAttributes) obj;
        return Objects.equals(visaPin(), other.visaPin())
                && Objects.equals(visaPinVerificationValue(), other.visaPinVerificationValue())
                && Objects.equals(ibm3624PinOffset(), other.ibm3624PinOffset())
                && Objects.equals(ibm3624NaturalPin(), other.ibm3624NaturalPin())
                && Objects.equals(ibm3624RandomPin(), other.ibm3624RandomPin())
                && Objects.equals(ibm3624PinFromOffset(), other.ibm3624PinFromOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PinGenerationAttributes").add("VisaPin", visaPin())
                .add("VisaPinVerificationValue", visaPinVerificationValue()).add("Ibm3624PinOffset", ibm3624PinOffset())
                .add("Ibm3624NaturalPin", ibm3624NaturalPin()).add("Ibm3624RandomPin", ibm3624RandomPin())
                .add("Ibm3624PinFromOffset", ibm3624PinFromOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisaPin":
            return Optional.ofNullable(clazz.cast(visaPin()));
        case "VisaPinVerificationValue":
            return Optional.ofNullable(clazz.cast(visaPinVerificationValue()));
        case "Ibm3624PinOffset":
            return Optional.ofNullable(clazz.cast(ibm3624PinOffset()));
        case "Ibm3624NaturalPin":
            return Optional.ofNullable(clazz.cast(ibm3624NaturalPin()));
        case "Ibm3624RandomPin":
            return Optional.ofNullable(clazz.cast(ibm3624RandomPin()));
        case "Ibm3624PinFromOffset":
            return Optional.ofNullable(clazz.cast(ibm3624PinFromOffset()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #visaPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Visa PIN.
     * </p>
     * 
     * @param visaPin
     *        Parameters that are required to generate or verify Visa PIN.
     */
    public static PinGenerationAttributes fromVisaPin(VisaPin visaPin) {
        return builder().visaPin(visaPin).build();
    }

    /**
     * Create an instance of this class with {@link #visaPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Visa PIN.
     * </p>
     * 
     * @param visaPin
     *        Parameters that are required to generate or verify Visa PIN.
     */
    public static PinGenerationAttributes fromVisaPin(Consumer<VisaPin.Builder> visaPin) {
        VisaPin.Builder builder = VisaPin.builder();
        visaPin.accept(builder);
        return fromVisaPin(builder.build());
    }

    /**
     * Create an instance of this class with {@link #visaPinVerificationValue()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
     * </p>
     * 
     * @param visaPinVerificationValue
     *        Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
     */
    public static PinGenerationAttributes fromVisaPinVerificationValue(VisaPinVerificationValue visaPinVerificationValue) {
        return builder().visaPinVerificationValue(visaPinVerificationValue).build();
    }

    /**
     * Create an instance of this class with {@link #visaPinVerificationValue()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
     * </p>
     * 
     * @param visaPinVerificationValue
     *        Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
     */
    public static PinGenerationAttributes fromVisaPinVerificationValue(
            Consumer<VisaPinVerificationValue.Builder> visaPinVerificationValue) {
        VisaPinVerificationValue.Builder builder = VisaPinVerificationValue.builder();
        visaPinVerificationValue.accept(builder);
        return fromVisaPinVerificationValue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibm3624PinOffset()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
     * </p>
     * 
     * @param ibm3624PinOffset
     *        Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
     */
    public static PinGenerationAttributes fromIbm3624PinOffset(Ibm3624PinOffset ibm3624PinOffset) {
        return builder().ibm3624PinOffset(ibm3624PinOffset).build();
    }

    /**
     * Create an instance of this class with {@link #ibm3624PinOffset()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
     * </p>
     * 
     * @param ibm3624PinOffset
     *        Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
     */
    public static PinGenerationAttributes fromIbm3624PinOffset(Consumer<Ibm3624PinOffset.Builder> ibm3624PinOffset) {
        Ibm3624PinOffset.Builder builder = Ibm3624PinOffset.builder();
        ibm3624PinOffset.accept(builder);
        return fromIbm3624PinOffset(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibm3624NaturalPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 natural PIN.
     * </p>
     * 
     * @param ibm3624NaturalPin
     *        Parameters that are required to generate or verify Ibm3624 natural PIN.
     */
    public static PinGenerationAttributes fromIbm3624NaturalPin(Ibm3624NaturalPin ibm3624NaturalPin) {
        return builder().ibm3624NaturalPin(ibm3624NaturalPin).build();
    }

    /**
     * Create an instance of this class with {@link #ibm3624NaturalPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 natural PIN.
     * </p>
     * 
     * @param ibm3624NaturalPin
     *        Parameters that are required to generate or verify Ibm3624 natural PIN.
     */
    public static PinGenerationAttributes fromIbm3624NaturalPin(Consumer<Ibm3624NaturalPin.Builder> ibm3624NaturalPin) {
        Ibm3624NaturalPin.Builder builder = Ibm3624NaturalPin.builder();
        ibm3624NaturalPin.accept(builder);
        return fromIbm3624NaturalPin(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibm3624RandomPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 random PIN.
     * </p>
     * 
     * @param ibm3624RandomPin
     *        Parameters that are required to generate or verify Ibm3624 random PIN.
     */
    public static PinGenerationAttributes fromIbm3624RandomPin(Ibm3624RandomPin ibm3624RandomPin) {
        return builder().ibm3624RandomPin(ibm3624RandomPin).build();
    }

    /**
     * Create an instance of this class with {@link #ibm3624RandomPin()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 random PIN.
     * </p>
     * 
     * @param ibm3624RandomPin
     *        Parameters that are required to generate or verify Ibm3624 random PIN.
     */
    public static PinGenerationAttributes fromIbm3624RandomPin(Consumer<Ibm3624RandomPin.Builder> ibm3624RandomPin) {
        Ibm3624RandomPin.Builder builder = Ibm3624RandomPin.builder();
        ibm3624RandomPin.accept(builder);
        return fromIbm3624RandomPin(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibm3624PinFromOffset()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
     * </p>
     * 
     * @param ibm3624PinFromOffset
     *        Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
     */
    public static PinGenerationAttributes fromIbm3624PinFromOffset(Ibm3624PinFromOffset ibm3624PinFromOffset) {
        return builder().ibm3624PinFromOffset(ibm3624PinFromOffset).build();
    }

    /**
     * Create an instance of this class with {@link #ibm3624PinFromOffset()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
     * </p>
     * 
     * @param ibm3624PinFromOffset
     *        Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
     */
    public static PinGenerationAttributes fromIbm3624PinFromOffset(Consumer<Ibm3624PinFromOffset.Builder> ibm3624PinFromOffset) {
        Ibm3624PinFromOffset.Builder builder = Ibm3624PinFromOffset.builder();
        ibm3624PinFromOffset.accept(builder);
        return fromIbm3624PinFromOffset(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VisaPin", VISA_PIN_FIELD);
        map.put("VisaPinVerificationValue", VISA_PIN_VERIFICATION_VALUE_FIELD);
        map.put("Ibm3624PinOffset", IBM3624_PIN_OFFSET_FIELD);
        map.put("Ibm3624NaturalPin", IBM3624_NATURAL_PIN_FIELD);
        map.put("Ibm3624RandomPin", IBM3624_RANDOM_PIN_FIELD);
        map.put("Ibm3624PinFromOffset", IBM3624_PIN_FROM_OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PinGenerationAttributes, T> g) {
        return obj -> g.apply((PinGenerationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PinGenerationAttributes> {
        /**
         * <p>
         * Parameters that are required to generate or verify Visa PIN.
         * </p>
         * 
         * @param visaPin
         *        Parameters that are required to generate or verify Visa PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visaPin(VisaPin visaPin);

        /**
         * <p>
         * Parameters that are required to generate or verify Visa PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisaPin.Builder} avoiding the need to
         * create one manually via {@link VisaPin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisaPin.Builder#build()} is called immediately and its result is
         * passed to {@link #visaPin(VisaPin)}.
         * 
         * @param visaPin
         *        a consumer that will call methods on {@link VisaPin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visaPin(VisaPin)
         */
        default Builder visaPin(Consumer<VisaPin.Builder> visaPin) {
            return visaPin(VisaPin.builder().applyMutation(visaPin).build());
        }

        /**
         * <p>
         * Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
         * </p>
         * 
         * @param visaPinVerificationValue
         *        Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visaPinVerificationValue(VisaPinVerificationValue visaPinVerificationValue);

        /**
         * <p>
         * Parameters that are required to generate or verify Visa PIN Verification Value (PVV).
         * </p>
         * This is a convenience method that creates an instance of the {@link VisaPinVerificationValue.Builder}
         * avoiding the need to create one manually via {@link VisaPinVerificationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisaPinVerificationValue.Builder#build()} is called immediately
         * and its result is passed to {@link #visaPinVerificationValue(VisaPinVerificationValue)}.
         * 
         * @param visaPinVerificationValue
         *        a consumer that will call methods on {@link VisaPinVerificationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visaPinVerificationValue(VisaPinVerificationValue)
         */
        default Builder visaPinVerificationValue(Consumer<VisaPinVerificationValue.Builder> visaPinVerificationValue) {
            return visaPinVerificationValue(VisaPinVerificationValue.builder().applyMutation(visaPinVerificationValue).build());
        }

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
         * </p>
         * 
         * @param ibm3624PinOffset
         *        Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibm3624PinOffset(Ibm3624PinOffset ibm3624PinOffset);

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ibm3624PinOffset.Builder} avoiding the
         * need to create one manually via {@link Ibm3624PinOffset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ibm3624PinOffset.Builder#build()} is called immediately and its
         * result is passed to {@link #ibm3624PinOffset(Ibm3624PinOffset)}.
         * 
         * @param ibm3624PinOffset
         *        a consumer that will call methods on {@link Ibm3624PinOffset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibm3624PinOffset(Ibm3624PinOffset)
         */
        default Builder ibm3624PinOffset(Consumer<Ibm3624PinOffset.Builder> ibm3624PinOffset) {
            return ibm3624PinOffset(Ibm3624PinOffset.builder().applyMutation(ibm3624PinOffset).build());
        }

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 natural PIN.
         * </p>
         * 
         * @param ibm3624NaturalPin
         *        Parameters that are required to generate or verify Ibm3624 natural PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibm3624NaturalPin(Ibm3624NaturalPin ibm3624NaturalPin);

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 natural PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ibm3624NaturalPin.Builder} avoiding the
         * need to create one manually via {@link Ibm3624NaturalPin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ibm3624NaturalPin.Builder#build()} is called immediately and its
         * result is passed to {@link #ibm3624NaturalPin(Ibm3624NaturalPin)}.
         * 
         * @param ibm3624NaturalPin
         *        a consumer that will call methods on {@link Ibm3624NaturalPin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibm3624NaturalPin(Ibm3624NaturalPin)
         */
        default Builder ibm3624NaturalPin(Consumer<Ibm3624NaturalPin.Builder> ibm3624NaturalPin) {
            return ibm3624NaturalPin(Ibm3624NaturalPin.builder().applyMutation(ibm3624NaturalPin).build());
        }

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 random PIN.
         * </p>
         * 
         * @param ibm3624RandomPin
         *        Parameters that are required to generate or verify Ibm3624 random PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibm3624RandomPin(Ibm3624RandomPin ibm3624RandomPin);

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 random PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ibm3624RandomPin.Builder} avoiding the
         * need to create one manually via {@link Ibm3624RandomPin#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ibm3624RandomPin.Builder#build()} is called immediately and its
         * result is passed to {@link #ibm3624RandomPin(Ibm3624RandomPin)}.
         * 
         * @param ibm3624RandomPin
         *        a consumer that will call methods on {@link Ibm3624RandomPin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibm3624RandomPin(Ibm3624RandomPin)
         */
        default Builder ibm3624RandomPin(Consumer<Ibm3624RandomPin.Builder> ibm3624RandomPin) {
            return ibm3624RandomPin(Ibm3624RandomPin.builder().applyMutation(ibm3624RandomPin).build());
        }

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
         * </p>
         * 
         * @param ibm3624PinFromOffset
         *        Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibm3624PinFromOffset(Ibm3624PinFromOffset ibm3624PinFromOffset);

        /**
         * <p>
         * Parameters that are required to generate or verify Ibm3624 PIN from offset PIN.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ibm3624PinFromOffset.Builder} avoiding
         * the need to create one manually via {@link Ibm3624PinFromOffset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ibm3624PinFromOffset.Builder#build()} is called immediately and
         * its result is passed to {@link #ibm3624PinFromOffset(Ibm3624PinFromOffset)}.
         * 
         * @param ibm3624PinFromOffset
         *        a consumer that will call methods on {@link Ibm3624PinFromOffset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibm3624PinFromOffset(Ibm3624PinFromOffset)
         */
        default Builder ibm3624PinFromOffset(Consumer<Ibm3624PinFromOffset.Builder> ibm3624PinFromOffset) {
            return ibm3624PinFromOffset(Ibm3624PinFromOffset.builder().applyMutation(ibm3624PinFromOffset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VisaPin visaPin;

        private VisaPinVerificationValue visaPinVerificationValue;

        private Ibm3624PinOffset ibm3624PinOffset;

        private Ibm3624NaturalPin ibm3624NaturalPin;

        private Ibm3624RandomPin ibm3624RandomPin;

        private Ibm3624PinFromOffset ibm3624PinFromOffset;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PinGenerationAttributes model) {
            visaPin(model.visaPin);
            visaPinVerificationValue(model.visaPinVerificationValue);
            ibm3624PinOffset(model.ibm3624PinOffset);
            ibm3624NaturalPin(model.ibm3624NaturalPin);
            ibm3624RandomPin(model.ibm3624RandomPin);
            ibm3624PinFromOffset(model.ibm3624PinFromOffset);
        }

        public final VisaPin.Builder getVisaPin() {
            return visaPin != null ? visaPin.toBuilder() : null;
        }

        public final void setVisaPin(VisaPin.BuilderImpl visaPin) {
            Object oldValue = this.visaPin;
            this.visaPin = visaPin != null ? visaPin.build() : null;
            handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
        }

        @Override
        public final Builder visaPin(VisaPin visaPin) {
            Object oldValue = this.visaPin;
            this.visaPin = visaPin;
            handleUnionValueChange(Type.VISA_PIN, oldValue, this.visaPin);
            return this;
        }

        public final VisaPinVerificationValue.Builder getVisaPinVerificationValue() {
            return visaPinVerificationValue != null ? visaPinVerificationValue.toBuilder() : null;
        }

        public final void setVisaPinVerificationValue(VisaPinVerificationValue.BuilderImpl visaPinVerificationValue) {
            Object oldValue = this.visaPinVerificationValue;
            this.visaPinVerificationValue = visaPinVerificationValue != null ? visaPinVerificationValue.build() : null;
            handleUnionValueChange(Type.VISA_PIN_VERIFICATION_VALUE, oldValue, this.visaPinVerificationValue);
        }

        @Override
        public final Builder visaPinVerificationValue(VisaPinVerificationValue visaPinVerificationValue) {
            Object oldValue = this.visaPinVerificationValue;
            this.visaPinVerificationValue = visaPinVerificationValue;
            handleUnionValueChange(Type.VISA_PIN_VERIFICATION_VALUE, oldValue, this.visaPinVerificationValue);
            return this;
        }

        public final Ibm3624PinOffset.Builder getIbm3624PinOffset() {
            return ibm3624PinOffset != null ? ibm3624PinOffset.toBuilder() : null;
        }

        public final void setIbm3624PinOffset(Ibm3624PinOffset.BuilderImpl ibm3624PinOffset) {
            Object oldValue = this.ibm3624PinOffset;
            this.ibm3624PinOffset = ibm3624PinOffset != null ? ibm3624PinOffset.build() : null;
            handleUnionValueChange(Type.IBM3624_PIN_OFFSET, oldValue, this.ibm3624PinOffset);
        }

        @Override
        public final Builder ibm3624PinOffset(Ibm3624PinOffset ibm3624PinOffset) {
            Object oldValue = this.ibm3624PinOffset;
            this.ibm3624PinOffset = ibm3624PinOffset;
            handleUnionValueChange(Type.IBM3624_PIN_OFFSET, oldValue, this.ibm3624PinOffset);
            return this;
        }

        public final Ibm3624NaturalPin.Builder getIbm3624NaturalPin() {
            return ibm3624NaturalPin != null ? ibm3624NaturalPin.toBuilder() : null;
        }

        public final void setIbm3624NaturalPin(Ibm3624NaturalPin.BuilderImpl ibm3624NaturalPin) {
            Object oldValue = this.ibm3624NaturalPin;
            this.ibm3624NaturalPin = ibm3624NaturalPin != null ? ibm3624NaturalPin.build() : null;
            handleUnionValueChange(Type.IBM3624_NATURAL_PIN, oldValue, this.ibm3624NaturalPin);
        }

        @Override
        public final Builder ibm3624NaturalPin(Ibm3624NaturalPin ibm3624NaturalPin) {
            Object oldValue = this.ibm3624NaturalPin;
            this.ibm3624NaturalPin = ibm3624NaturalPin;
            handleUnionValueChange(Type.IBM3624_NATURAL_PIN, oldValue, this.ibm3624NaturalPin);
            return this;
        }

        public final Ibm3624RandomPin.Builder getIbm3624RandomPin() {
            return ibm3624RandomPin != null ? ibm3624RandomPin.toBuilder() : null;
        }

        public final void setIbm3624RandomPin(Ibm3624RandomPin.BuilderImpl ibm3624RandomPin) {
            Object oldValue = this.ibm3624RandomPin;
            this.ibm3624RandomPin = ibm3624RandomPin != null ? ibm3624RandomPin.build() : null;
            handleUnionValueChange(Type.IBM3624_RANDOM_PIN, oldValue, this.ibm3624RandomPin);
        }

        @Override
        public final Builder ibm3624RandomPin(Ibm3624RandomPin ibm3624RandomPin) {
            Object oldValue = this.ibm3624RandomPin;
            this.ibm3624RandomPin = ibm3624RandomPin;
            handleUnionValueChange(Type.IBM3624_RANDOM_PIN, oldValue, this.ibm3624RandomPin);
            return this;
        }

        public final Ibm3624PinFromOffset.Builder getIbm3624PinFromOffset() {
            return ibm3624PinFromOffset != null ? ibm3624PinFromOffset.toBuilder() : null;
        }

        public final void setIbm3624PinFromOffset(Ibm3624PinFromOffset.BuilderImpl ibm3624PinFromOffset) {
            Object oldValue = this.ibm3624PinFromOffset;
            this.ibm3624PinFromOffset = ibm3624PinFromOffset != null ? ibm3624PinFromOffset.build() : null;
            handleUnionValueChange(Type.IBM3624_PIN_FROM_OFFSET, oldValue, this.ibm3624PinFromOffset);
        }

        @Override
        public final Builder ibm3624PinFromOffset(Ibm3624PinFromOffset ibm3624PinFromOffset) {
            Object oldValue = this.ibm3624PinFromOffset;
            this.ibm3624PinFromOffset = ibm3624PinFromOffset;
            handleUnionValueChange(Type.IBM3624_PIN_FROM_OFFSET, oldValue, this.ibm3624PinFromOffset);
            return this;
        }

        @Override
        public PinGenerationAttributes build() {
            return new PinGenerationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PinGenerationAttributes#type()
     */
    public enum Type {
        VISA_PIN,

        VISA_PIN_VERIFICATION_VALUE,

        IBM3624_PIN_OFFSET,

        IBM3624_NATURAL_PIN,

        IBM3624_RANDOM_PIN,

        IBM3624_PIN_FROM_OFFSET,

        UNKNOWN_TO_SDK_VERSION
    }
}
