/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information of the TR31WrappedKeyBlock containing the transaction key wrapped using a KEK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutgoingTr31KeyBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<OutgoingTr31KeyBlock.Builder, OutgoingTr31KeyBlock> {
    private static final SdkField<String> WRAPPING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappingKeyIdentifier").getter(getter(OutgoingTr31KeyBlock::wrappingKeyIdentifier))
            .setter(setter(Builder::wrappingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(WRAPPING_KEY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String wrappingKeyIdentifier;

    private OutgoingTr31KeyBlock(BuilderImpl builder) {
        this.wrappingKeyIdentifier = builder.wrappingKeyIdentifier;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the KEK used to wrap the transaction key.
     * </p>
     * 
     * @return The <code>keyARN</code> of the KEK used to wrap the transaction key.
     */
    public final String wrappingKeyIdentifier() {
        return wrappingKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutgoingTr31KeyBlock)) {
            return false;
        }
        OutgoingTr31KeyBlock other = (OutgoingTr31KeyBlock) obj;
        return Objects.equals(wrappingKeyIdentifier(), other.wrappingKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutgoingTr31KeyBlock").add("WrappingKeyIdentifier", wrappingKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WrappingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(wrappingKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WrappingKeyIdentifier", WRAPPING_KEY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutgoingTr31KeyBlock, T> g) {
        return obj -> g.apply((OutgoingTr31KeyBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutgoingTr31KeyBlock> {
        /**
         * <p>
         * The <code>keyARN</code> of the KEK used to wrap the transaction key.
         * </p>
         * 
         * @param wrappingKeyIdentifier
         *        The <code>keyARN</code> of the KEK used to wrap the transaction key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappingKeyIdentifier(String wrappingKeyIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String wrappingKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(OutgoingTr31KeyBlock model) {
            wrappingKeyIdentifier(model.wrappingKeyIdentifier);
        }

        public final String getWrappingKeyIdentifier() {
            return wrappingKeyIdentifier;
        }

        public final void setWrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
        }

        @Override
        public final Builder wrappingKeyIdentifier(String wrappingKeyIdentifier) {
            this.wrappingKeyIdentifier = wrappingKeyIdentifier;
            return this;
        }

        @Override
        public OutgoingTr31KeyBlock build() {
            return new OutgoingTr31KeyBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
