/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The shared information used when deriving a key using ECDH.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiffieHellmanDerivationData implements SdkPojo, Serializable,
        ToCopyableBuilder<DiffieHellmanDerivationData.Builder, DiffieHellmanDerivationData> {
    private static final SdkField<String> SHARED_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedInformation").getter(getter(DiffieHellmanDerivationData::sharedInformation))
            .setter(setter(Builder::sharedInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedInformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_INFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sharedInformation;

    private final Type type;

    private DiffieHellmanDerivationData(BuilderImpl builder) {
        this.sharedInformation = builder.sharedInformation;
        this.type = builder.type;
    }

    /**
     * <p>
     * A string containing information that binds the ECDH derived key to the two parties involved or to the context of
     * the key.
     * </p>
     * <p>
     * It may include details like identities of the two parties deriving the key, context of the operation, session
     * IDs, and optionally a nonce. It must not contain zero bytes. It is not recommended to reuse shared information
     * for multiple ECDH key derivations, as it could result in derived key material being the same across different
     * derivations.
     * </p>
     * 
     * @return A string containing information that binds the ECDH derived key to the two parties involved or to the
     *         context of the key.</p>
     *         <p>
     *         It may include details like identities of the two parties deriving the key, context of the operation,
     *         session IDs, and optionally a nonce. It must not contain zero bytes. It is not recommended to reuse
     *         shared information for multiple ECDH key derivations, as it could result in derived key material being
     *         the same across different derivations.
     */
    public final String sharedInformation() {
        return sharedInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiffieHellmanDerivationData)) {
            return false;
        }
        DiffieHellmanDerivationData other = (DiffieHellmanDerivationData) obj;
        return Objects.equals(sharedInformation(), other.sharedInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiffieHellmanDerivationData").add("SharedInformation", sharedInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedInformation":
            return Optional.ofNullable(clazz.cast(sharedInformation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #sharedInformation()} initialized to the given value.
     *
     * <p>
     * A string containing information that binds the ECDH derived key to the two parties involved or to the context of
     * the key.
     * </p>
     * <p>
     * It may include details like identities of the two parties deriving the key, context of the operation, session
     * IDs, and optionally a nonce. It must not contain zero bytes. It is not recommended to reuse shared information
     * for multiple ECDH key derivations, as it could result in derived key material being the same across different
     * derivations.
     * </p>
     * 
     * @param sharedInformation
     *        A string containing information that binds the ECDH derived key to the two parties involved or to the
     *        context of the key.</p>
     *        <p>
     *        It may include details like identities of the two parties deriving the key, context of the operation,
     *        session IDs, and optionally a nonce. It must not contain zero bytes. It is not recommended to reuse shared
     *        information for multiple ECDH key derivations, as it could result in derived key material being the same
     *        across different derivations.
     */
    public static DiffieHellmanDerivationData fromSharedInformation(String sharedInformation) {
        return builder().sharedInformation(sharedInformation).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SharedInformation", SHARED_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiffieHellmanDerivationData, T> g) {
        return obj -> g.apply((DiffieHellmanDerivationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiffieHellmanDerivationData> {
        /**
         * <p>
         * A string containing information that binds the ECDH derived key to the two parties involved or to the context
         * of the key.
         * </p>
         * <p>
         * It may include details like identities of the two parties deriving the key, context of the operation, session
         * IDs, and optionally a nonce. It must not contain zero bytes. It is not recommended to reuse shared
         * information for multiple ECDH key derivations, as it could result in derived key material being the same
         * across different derivations.
         * </p>
         * 
         * @param sharedInformation
         *        A string containing information that binds the ECDH derived key to the two parties involved or to the
         *        context of the key.</p>
         *        <p>
         *        It may include details like identities of the two parties deriving the key, context of the operation,
         *        session IDs, and optionally a nonce. It must not contain zero bytes. It is not recommended to reuse
         *        shared information for multiple ECDH key derivations, as it could result in derived key material being
         *        the same across different derivations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedInformation(String sharedInformation);
    }

    static final class BuilderImpl implements Builder {
        private String sharedInformation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DiffieHellmanDerivationData model) {
            sharedInformation(model.sharedInformation);
        }

        public final String getSharedInformation() {
            return sharedInformation;
        }

        public final void setSharedInformation(String sharedInformation) {
            Object oldValue = this.sharedInformation;
            this.sharedInformation = sharedInformation;
            handleUnionValueChange(Type.SHARED_INFORMATION, oldValue, this.sharedInformation);
        }

        @Override
        public final Builder sharedInformation(String sharedInformation) {
            Object oldValue = this.sharedInformation;
            this.sharedInformation = sharedInformation;
            handleUnionValueChange(Type.SHARED_INFORMATION, oldValue, this.sharedInformation);
            return this;
        }

        @Override
        public DiffieHellmanDerivationData build() {
            return new DiffieHellmanDerivationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DiffieHellmanDerivationData#type()
     */
    public enum Type {
        SHARED_INFORMATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
