/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to derive the payment card specific confidentiality and integrity keys.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DerivationMethodAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DerivationMethodAttributes.Builder, DerivationMethodAttributes> {
    private static final SdkField<EmvCommonAttributes> EMV_COMMON_FIELD = SdkField
            .<EmvCommonAttributes> builder(MarshallingType.SDK_POJO).memberName("EmvCommon")
            .getter(getter(DerivationMethodAttributes::emvCommon)).setter(setter(Builder::emvCommon))
            .constructor(EmvCommonAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmvCommon").build()).build();

    private static final SdkField<AmexAttributes> AMEX_FIELD = SdkField.<AmexAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("Amex").getter(getter(DerivationMethodAttributes::amex)).setter(setter(Builder::amex))
            .constructor(AmexAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amex").build()).build();

    private static final SdkField<VisaAttributes> VISA_FIELD = SdkField.<VisaAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("Visa").getter(getter(DerivationMethodAttributes::visa)).setter(setter(Builder::visa))
            .constructor(VisaAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visa").build()).build();

    private static final SdkField<Emv2000Attributes> EMV2000_FIELD = SdkField
            .<Emv2000Attributes> builder(MarshallingType.SDK_POJO).memberName("Emv2000")
            .getter(getter(DerivationMethodAttributes::emv2000)).setter(setter(Builder::emv2000))
            .constructor(Emv2000Attributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emv2000").build()).build();

    private static final SdkField<MasterCardAttributes> MASTERCARD_FIELD = SdkField
            .<MasterCardAttributes> builder(MarshallingType.SDK_POJO).memberName("Mastercard")
            .getter(getter(DerivationMethodAttributes::mastercard)).setter(setter(Builder::mastercard))
            .constructor(MasterCardAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mastercard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMV_COMMON_FIELD, AMEX_FIELD,
            VISA_FIELD, EMV2000_FIELD, MASTERCARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EmvCommonAttributes emvCommon;

    private final AmexAttributes amex;

    private final VisaAttributes visa;

    private final Emv2000Attributes emv2000;

    private final MasterCardAttributes mastercard;

    private final Type type;

    private DerivationMethodAttributes(BuilderImpl builder) {
        this.emvCommon = builder.emvCommon;
        this.amex = builder.amex;
        this.visa = builder.visa;
        this.emv2000 = builder.emv2000;
        this.mastercard = builder.mastercard;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
     * method.
     * </p>
     * 
     * @return Parameters to derive the confidentiality and integrity keys for a payment card using Emv common
     *         derivation method.
     */
    public final EmvCommonAttributes emvCommon() {
        return emvCommon;
    }

    /**
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation method.
     * </p>
     * 
     * @return Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation
     *         method.
     */
    public final AmexAttributes amex() {
        return amex;
    }

    /**
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation method.
     * </p>
     * 
     * @return Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation
     *         method.
     */
    public final VisaAttributes visa() {
        return visa;
    }

    /**
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation method.
     * </p>
     * 
     * @return Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation
     *         method.
     */
    public final Emv2000Attributes emv2000() {
        return emv2000;
    }

    /**
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
     * method.
     * </p>
     * 
     * @return Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard
     *         derivation method.
     */
    public final MasterCardAttributes mastercard() {
        return mastercard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emvCommon());
        hashCode = 31 * hashCode + Objects.hashCode(amex());
        hashCode = 31 * hashCode + Objects.hashCode(visa());
        hashCode = 31 * hashCode + Objects.hashCode(emv2000());
        hashCode = 31 * hashCode + Objects.hashCode(mastercard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DerivationMethodAttributes)) {
            return false;
        }
        DerivationMethodAttributes other = (DerivationMethodAttributes) obj;
        return Objects.equals(emvCommon(), other.emvCommon()) && Objects.equals(amex(), other.amex())
                && Objects.equals(visa(), other.visa()) && Objects.equals(emv2000(), other.emv2000())
                && Objects.equals(mastercard(), other.mastercard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DerivationMethodAttributes").add("EmvCommon", emvCommon()).add("Amex", amex())
                .add("Visa", visa()).add("Emv2000", emv2000()).add("Mastercard", mastercard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmvCommon":
            return Optional.ofNullable(clazz.cast(emvCommon()));
        case "Amex":
            return Optional.ofNullable(clazz.cast(amex()));
        case "Visa":
            return Optional.ofNullable(clazz.cast(visa()));
        case "Emv2000":
            return Optional.ofNullable(clazz.cast(emv2000()));
        case "Mastercard":
            return Optional.ofNullable(clazz.cast(mastercard()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #emvCommon()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
     * method.
     * </p>
     * 
     * @param emvCommon
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
     *        method.
     */
    public static DerivationMethodAttributes fromEmvCommon(EmvCommonAttributes emvCommon) {
        return builder().emvCommon(emvCommon).build();
    }

    /**
     * Create an instance of this class with {@link #emvCommon()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
     * method.
     * </p>
     * 
     * @param emvCommon
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
     *        method.
     */
    public static DerivationMethodAttributes fromEmvCommon(Consumer<EmvCommonAttributes.Builder> emvCommon) {
        EmvCommonAttributes.Builder builder = EmvCommonAttributes.builder();
        emvCommon.accept(builder);
        return fromEmvCommon(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amex()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation method.
     * </p>
     * 
     * @param amex
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation
     *        method.
     */
    public static DerivationMethodAttributes fromAmex(AmexAttributes amex) {
        return builder().amex(amex).build();
    }

    /**
     * Create an instance of this class with {@link #amex()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation method.
     * </p>
     * 
     * @param amex
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation
     *        method.
     */
    public static DerivationMethodAttributes fromAmex(Consumer<AmexAttributes.Builder> amex) {
        AmexAttributes.Builder builder = AmexAttributes.builder();
        amex.accept(builder);
        return fromAmex(builder.build());
    }

    /**
     * Create an instance of this class with {@link #visa()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation method.
     * </p>
     * 
     * @param visa
     *        Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation
     *        method.
     */
    public static DerivationMethodAttributes fromVisa(VisaAttributes visa) {
        return builder().visa(visa).build();
    }

    /**
     * Create an instance of this class with {@link #visa()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation method.
     * </p>
     * 
     * @param visa
     *        Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation
     *        method.
     */
    public static DerivationMethodAttributes fromVisa(Consumer<VisaAttributes.Builder> visa) {
        VisaAttributes.Builder builder = VisaAttributes.builder();
        visa.accept(builder);
        return fromVisa(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emv2000()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation method.
     * </p>
     * 
     * @param emv2000
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation
     *        method.
     */
    public static DerivationMethodAttributes fromEmv2000(Emv2000Attributes emv2000) {
        return builder().emv2000(emv2000).build();
    }

    /**
     * Create an instance of this class with {@link #emv2000()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation method.
     * </p>
     * 
     * @param emv2000
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation
     *        method.
     */
    public static DerivationMethodAttributes fromEmv2000(Consumer<Emv2000Attributes.Builder> emv2000) {
        Emv2000Attributes.Builder builder = Emv2000Attributes.builder();
        emv2000.accept(builder);
        return fromEmv2000(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mastercard()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
     * method.
     * </p>
     * 
     * @param mastercard
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
     *        method.
     */
    public static DerivationMethodAttributes fromMastercard(MasterCardAttributes mastercard) {
        return builder().mastercard(mastercard).build();
    }

    /**
     * Create an instance of this class with {@link #mastercard()} initialized to the given value.
     *
     * <p>
     * Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
     * method.
     * </p>
     * 
     * @param mastercard
     *        Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
     *        method.
     */
    public static DerivationMethodAttributes fromMastercard(Consumer<MasterCardAttributes.Builder> mastercard) {
        MasterCardAttributes.Builder builder = MasterCardAttributes.builder();
        mastercard.accept(builder);
        return fromMastercard(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmvCommon", EMV_COMMON_FIELD);
        map.put("Amex", AMEX_FIELD);
        map.put("Visa", VISA_FIELD);
        map.put("Emv2000", EMV2000_FIELD);
        map.put("Mastercard", MASTERCARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DerivationMethodAttributes, T> g) {
        return obj -> g.apply((DerivationMethodAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DerivationMethodAttributes> {
        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
         * method.
         * </p>
         * 
         * @param emvCommon
         *        Parameters to derive the confidentiality and integrity keys for a payment card using Emv common
         *        derivation method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emvCommon(EmvCommonAttributes emvCommon);

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Emv common derivation
         * method.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmvCommonAttributes.Builder} avoiding the
         * need to create one manually via {@link EmvCommonAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmvCommonAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #emvCommon(EmvCommonAttributes)}.
         * 
         * @param emvCommon
         *        a consumer that will call methods on {@link EmvCommonAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emvCommon(EmvCommonAttributes)
         */
        default Builder emvCommon(Consumer<EmvCommonAttributes.Builder> emvCommon) {
            return emvCommon(EmvCommonAttributes.builder().applyMutation(emvCommon).build());
        }

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation method.
         * </p>
         * 
         * @param amex
         *        Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amex(AmexAttributes amex);

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Amex derivation method.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmexAttributes.Builder} avoiding the need
         * to create one manually via {@link AmexAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmexAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #amex(AmexAttributes)}.
         * 
         * @param amex
         *        a consumer that will call methods on {@link AmexAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amex(AmexAttributes)
         */
        default Builder amex(Consumer<AmexAttributes.Builder> amex) {
            return amex(AmexAttributes.builder().applyMutation(amex).build());
        }

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation
         * method.
         * </p>
         * 
         * @param visa
         *        Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visa(VisaAttributes visa);

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a a payment card using Visa derivation
         * method.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisaAttributes.Builder} avoiding the need
         * to create one manually via {@link VisaAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisaAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #visa(VisaAttributes)}.
         * 
         * @param visa
         *        a consumer that will call methods on {@link VisaAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visa(VisaAttributes)
         */
        default Builder visa(Consumer<VisaAttributes.Builder> visa) {
            return visa(VisaAttributes.builder().applyMutation(visa).build());
        }

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation
         * method.
         * </p>
         * 
         * @param emv2000
         *        Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000
         *        derivation method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emv2000(Emv2000Attributes emv2000);

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Emv2000 derivation
         * method.
         * </p>
         * This is a convenience method that creates an instance of the {@link Emv2000Attributes.Builder} avoiding the
         * need to create one manually via {@link Emv2000Attributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Emv2000Attributes.Builder#build()} is called immediately and its
         * result is passed to {@link #emv2000(Emv2000Attributes)}.
         * 
         * @param emv2000
         *        a consumer that will call methods on {@link Emv2000Attributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emv2000(Emv2000Attributes)
         */
        default Builder emv2000(Consumer<Emv2000Attributes.Builder> emv2000) {
            return emv2000(Emv2000Attributes.builder().applyMutation(emv2000).build());
        }

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
         * method.
         * </p>
         * 
         * @param mastercard
         *        Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard
         *        derivation method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mastercard(MasterCardAttributes mastercard);

        /**
         * <p>
         * Parameters to derive the confidentiality and integrity keys for a payment card using Mastercard derivation
         * method.
         * </p>
         * This is a convenience method that creates an instance of the {@link MasterCardAttributes.Builder} avoiding
         * the need to create one manually via {@link MasterCardAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MasterCardAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #mastercard(MasterCardAttributes)}.
         * 
         * @param mastercard
         *        a consumer that will call methods on {@link MasterCardAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mastercard(MasterCardAttributes)
         */
        default Builder mastercard(Consumer<MasterCardAttributes.Builder> mastercard) {
            return mastercard(MasterCardAttributes.builder().applyMutation(mastercard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EmvCommonAttributes emvCommon;

        private AmexAttributes amex;

        private VisaAttributes visa;

        private Emv2000Attributes emv2000;

        private MasterCardAttributes mastercard;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DerivationMethodAttributes model) {
            emvCommon(model.emvCommon);
            amex(model.amex);
            visa(model.visa);
            emv2000(model.emv2000);
            mastercard(model.mastercard);
        }

        public final EmvCommonAttributes.Builder getEmvCommon() {
            return emvCommon != null ? emvCommon.toBuilder() : null;
        }

        public final void setEmvCommon(EmvCommonAttributes.BuilderImpl emvCommon) {
            Object oldValue = this.emvCommon;
            this.emvCommon = emvCommon != null ? emvCommon.build() : null;
            handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
        }

        @Override
        public final Builder emvCommon(EmvCommonAttributes emvCommon) {
            Object oldValue = this.emvCommon;
            this.emvCommon = emvCommon;
            handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
            return this;
        }

        public final AmexAttributes.Builder getAmex() {
            return amex != null ? amex.toBuilder() : null;
        }

        public final void setAmex(AmexAttributes.BuilderImpl amex) {
            Object oldValue = this.amex;
            this.amex = amex != null ? amex.build() : null;
            handleUnionValueChange(Type.AMEX, oldValue, this.amex);
        }

        @Override
        public final Builder amex(AmexAttributes amex) {
            Object oldValue = this.amex;
            this.amex = amex;
            handleUnionValueChange(Type.AMEX, oldValue, this.amex);
            return this;
        }

        public final VisaAttributes.Builder getVisa() {
            return visa != null ? visa.toBuilder() : null;
        }

        public final void setVisa(VisaAttributes.BuilderImpl visa) {
            Object oldValue = this.visa;
            this.visa = visa != null ? visa.build() : null;
            handleUnionValueChange(Type.VISA, oldValue, this.visa);
        }

        @Override
        public final Builder visa(VisaAttributes visa) {
            Object oldValue = this.visa;
            this.visa = visa;
            handleUnionValueChange(Type.VISA, oldValue, this.visa);
            return this;
        }

        public final Emv2000Attributes.Builder getEmv2000() {
            return emv2000 != null ? emv2000.toBuilder() : null;
        }

        public final void setEmv2000(Emv2000Attributes.BuilderImpl emv2000) {
            Object oldValue = this.emv2000;
            this.emv2000 = emv2000 != null ? emv2000.build() : null;
            handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
        }

        @Override
        public final Builder emv2000(Emv2000Attributes emv2000) {
            Object oldValue = this.emv2000;
            this.emv2000 = emv2000;
            handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
            return this;
        }

        public final MasterCardAttributes.Builder getMastercard() {
            return mastercard != null ? mastercard.toBuilder() : null;
        }

        public final void setMastercard(MasterCardAttributes.BuilderImpl mastercard) {
            Object oldValue = this.mastercard;
            this.mastercard = mastercard != null ? mastercard.build() : null;
            handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
        }

        @Override
        public final Builder mastercard(MasterCardAttributes mastercard) {
            Object oldValue = this.mastercard;
            this.mastercard = mastercard;
            handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
            return this;
        }

        @Override
        public DerivationMethodAttributes build() {
            return new DerivationMethodAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DerivationMethodAttributes#type()
     */
    public enum Type {
        EMV_COMMON,

        AMEX,

        VISA,

        EMV2000,

        MASTERCARD,

        UNKNOWN_TO_SDK_VERSION
    }
}
