/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameter values of the current PIN to be changed on the EMV chip card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentPinAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrentPinAttributes.Builder, CurrentPinAttributes> {
    private static final SdkField<String> CURRENT_PIN_PEK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentPinPekIdentifier").getter(getter(CurrentPinAttributes::currentPinPekIdentifier))
            .setter(setter(Builder::currentPinPekIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPinPekIdentifier").build())
            .build();

    private static final SdkField<String> CURRENT_ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentEncryptedPinBlock").getter(getter(CurrentPinAttributes::currentEncryptedPinBlock))
            .setter(setter(Builder::currentEncryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentEncryptedPinBlock").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CURRENT_PIN_PEK_IDENTIFIER_FIELD, CURRENT_ENCRYPTED_PIN_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currentPinPekIdentifier;

    private final String currentEncryptedPinBlock;

    private CurrentPinAttributes(BuilderImpl builder) {
        this.currentPinPekIdentifier = builder.currentPinPekIdentifier;
        this.currentEncryptedPinBlock = builder.currentEncryptedPinBlock;
    }

    /**
     * <p>
     * The <code>keyArn</code> of the current PIN PEK.
     * </p>
     * 
     * @return The <code>keyArn</code> of the current PIN PEK.
     */
    public final String currentPinPekIdentifier() {
        return currentPinPekIdentifier;
    }

    /**
     * <p>
     * The encrypted pinblock of the current pin stored on the chip card.
     * </p>
     * 
     * @return The encrypted pinblock of the current pin stored on the chip card.
     */
    public final String currentEncryptedPinBlock() {
        return currentEncryptedPinBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentPinPekIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(currentEncryptedPinBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentPinAttributes)) {
            return false;
        }
        CurrentPinAttributes other = (CurrentPinAttributes) obj;
        return Objects.equals(currentPinPekIdentifier(), other.currentPinPekIdentifier())
                && Objects.equals(currentEncryptedPinBlock(), other.currentEncryptedPinBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrentPinAttributes").add("CurrentPinPekIdentifier", currentPinPekIdentifier())
                .add("CurrentEncryptedPinBlock", currentEncryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentPinPekIdentifier":
            return Optional.ofNullable(clazz.cast(currentPinPekIdentifier()));
        case "CurrentEncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(currentEncryptedPinBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CurrentPinPekIdentifier", CURRENT_PIN_PEK_IDENTIFIER_FIELD);
        map.put("CurrentEncryptedPinBlock", CURRENT_ENCRYPTED_PIN_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CurrentPinAttributes, T> g) {
        return obj -> g.apply((CurrentPinAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentPinAttributes> {
        /**
         * <p>
         * The <code>keyArn</code> of the current PIN PEK.
         * </p>
         * 
         * @param currentPinPekIdentifier
         *        The <code>keyArn</code> of the current PIN PEK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPinPekIdentifier(String currentPinPekIdentifier);

        /**
         * <p>
         * The encrypted pinblock of the current pin stored on the chip card.
         * </p>
         * 
         * @param currentEncryptedPinBlock
         *        The encrypted pinblock of the current pin stored on the chip card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentEncryptedPinBlock(String currentEncryptedPinBlock);
    }

    static final class BuilderImpl implements Builder {
        private String currentPinPekIdentifier;

        private String currentEncryptedPinBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentPinAttributes model) {
            currentPinPekIdentifier(model.currentPinPekIdentifier);
            currentEncryptedPinBlock(model.currentEncryptedPinBlock);
        }

        public final String getCurrentPinPekIdentifier() {
            return currentPinPekIdentifier;
        }

        public final void setCurrentPinPekIdentifier(String currentPinPekIdentifier) {
            this.currentPinPekIdentifier = currentPinPekIdentifier;
        }

        @Override
        public final Builder currentPinPekIdentifier(String currentPinPekIdentifier) {
            this.currentPinPekIdentifier = currentPinPekIdentifier;
            return this;
        }

        public final String getCurrentEncryptedPinBlock() {
            return currentEncryptedPinBlock;
        }

        public final void setCurrentEncryptedPinBlock(String currentEncryptedPinBlock) {
            this.currentEncryptedPinBlock = currentEncryptedPinBlock;
        }

        @Override
        public final Builder currentEncryptedPinBlock(String currentEncryptedPinBlock) {
            this.currentEncryptedPinBlock = currentEncryptedPinBlock;
            return this;
        }

        @Override
        public CurrentPinAttributes build() {
            return new CurrentPinAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
