/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.WrappedKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, EncryptDataRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(EncryptDataRequest.getter(EncryptDataRequest::keyIdentifier)).setter(EncryptDataRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> PLAIN_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlainText").getter(EncryptDataRequest.getter(EncryptDataRequest::plainText)).setter(EncryptDataRequest.setter(Builder::plainText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlainText").build()}).build();
    private static final SdkField<EncryptionDecryptionAttributes> ENCRYPTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAttributes").getter(EncryptDataRequest.getter(EncryptDataRequest::encryptionAttributes)).setter(EncryptDataRequest.setter(Builder::encryptionAttributes)).constructor(EncryptionDecryptionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAttributes").build()}).build();
    private static final SdkField<WrappedKey> WRAPPED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WrappedKey").getter(EncryptDataRequest.getter(EncryptDataRequest::wrappedKey)).setter(EncryptDataRequest.setter(Builder::wrappedKey)).constructor(WrappedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, PLAIN_TEXT_FIELD, ENCRYPTION_ATTRIBUTES_FIELD, WRAPPED_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EncryptDataRequest.memberNameToFieldInitializer();
    private final String keyIdentifier;
    private final String plainText;
    private final EncryptionDecryptionAttributes encryptionAttributes;
    private final WrappedKey wrappedKey;

    private EncryptDataRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.plainText = builder.plainText;
        this.encryptionAttributes = builder.encryptionAttributes;
        this.wrappedKey = builder.wrappedKey;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String plainText() {
        return this.plainText;
    }

    public final EncryptionDecryptionAttributes encryptionAttributes() {
        return this.encryptionAttributes;
    }

    public final WrappedKey wrappedKey() {
        return this.wrappedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.plainText());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptDataRequest)) {
            return false;
        }
        EncryptDataRequest other = (EncryptDataRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.plainText(), other.plainText()) && Objects.equals(this.encryptionAttributes(), other.encryptionAttributes()) && Objects.equals(this.wrappedKey(), other.wrappedKey());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptDataRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("PlainText", (Object)(this.plainText() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionAttributes", (Object)this.encryptionAttributes()).add("WrappedKey", (Object)this.wrappedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "PlainText": {
                return Optional.ofNullable(clazz.cast(this.plainText()));
            }
            case "EncryptionAttributes": {
                return Optional.ofNullable(clazz.cast(this.encryptionAttributes()));
            }
            case "WrappedKey": {
                return Optional.ofNullable(clazz.cast(this.wrappedKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyIdentifier", KEY_IDENTIFIER_FIELD);
        map.put("PlainText", PLAIN_TEXT_FIELD);
        map.put("EncryptionAttributes", ENCRYPTION_ATTRIBUTES_FIELD);
        map.put("WrappedKey", WRAPPED_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptDataRequest, T> g) {
        return obj -> g.apply((EncryptDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String plainText;
        private EncryptionDecryptionAttributes encryptionAttributes;
        private WrappedKey wrappedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptDataRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.plainText(model.plainText);
            this.encryptionAttributes(model.encryptionAttributes);
            this.wrappedKey(model.wrappedKey);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getPlainText() {
            return this.plainText;
        }

        public final void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        @Override
        public final Builder plainText(String plainText) {
            this.plainText = plainText;
            return this;
        }

        public final EncryptionDecryptionAttributes.Builder getEncryptionAttributes() {
            return this.encryptionAttributes != null ? this.encryptionAttributes.toBuilder() : null;
        }

        public final void setEncryptionAttributes(EncryptionDecryptionAttributes.BuilderImpl encryptionAttributes) {
            this.encryptionAttributes = encryptionAttributes != null ? encryptionAttributes.build() : null;
        }

        @Override
        public final Builder encryptionAttributes(EncryptionDecryptionAttributes encryptionAttributes) {
            this.encryptionAttributes = encryptionAttributes;
            return this;
        }

        public final WrappedKey.Builder getWrappedKey() {
            return this.wrappedKey != null ? this.wrappedKey.toBuilder() : null;
        }

        public final void setWrappedKey(WrappedKey.BuilderImpl wrappedKey) {
            this.wrappedKey = wrappedKey != null ? wrappedKey.build() : null;
        }

        @Override
        public final Builder wrappedKey(WrappedKey wrappedKey) {
            this.wrappedKey = wrappedKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EncryptDataRequest build() {
            return new EncryptDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EncryptDataRequest> {
        public Builder keyIdentifier(String var1);

        public Builder plainText(String var1);

        public Builder encryptionAttributes(EncryptionDecryptionAttributes var1);

        default public Builder encryptionAttributes(Consumer<EncryptionDecryptionAttributes.Builder> encryptionAttributes) {
            return this.encryptionAttributes((EncryptionDecryptionAttributes)((EncryptionDecryptionAttributes.Builder)EncryptionDecryptionAttributes.builder().applyMutation(encryptionAttributes)).build());
        }

        public Builder wrappedKey(WrappedKey var1);

        default public Builder wrappedKey(Consumer<WrappedKey.Builder> wrappedKey) {
            return this.wrappedKey((WrappedKey)((WrappedKey.Builder)WrappedKey.builder().applyMutation(wrappedKey)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

