/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.services.paymentcryptographydata.model.WrappedKeyMaterial;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WrappedKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WrappedKey> {
    private static final SdkField<WrappedKeyMaterial> WRAPPED_KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WrappedKeyMaterial").getter(WrappedKey.getter(WrappedKey::wrappedKeyMaterial)).setter(WrappedKey.setter(Builder::wrappedKeyMaterial)).constructor(WrappedKeyMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyMaterial").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(WrappedKey.getter(WrappedKey::keyCheckValueAlgorithmAsString)).setter(WrappedKey.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAPPED_KEY_MATERIAL_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WrappedKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final WrappedKeyMaterial wrappedKeyMaterial;
    private final String keyCheckValueAlgorithm;

    private WrappedKey(BuilderImpl builder) {
        this.wrappedKeyMaterial = builder.wrappedKeyMaterial;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
    }

    public final WrappedKeyMaterial wrappedKeyMaterial() {
        return this.wrappedKeyMaterial;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrappedKey)) {
            return false;
        }
        WrappedKey other = (WrappedKey)obj;
        return Objects.equals(this.wrappedKeyMaterial(), other.wrappedKeyMaterial()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WrappedKey").add("WrappedKeyMaterial", (Object)this.wrappedKeyMaterial()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WrappedKeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyMaterial()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WrappedKeyMaterial", WRAPPED_KEY_MATERIAL_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WrappedKey, T> g) {
        return obj -> g.apply((WrappedKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WrappedKeyMaterial wrappedKeyMaterial;
        private String keyCheckValueAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(WrappedKey model) {
            this.wrappedKeyMaterial(model.wrappedKeyMaterial);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
        }

        public final WrappedKeyMaterial.Builder getWrappedKeyMaterial() {
            return this.wrappedKeyMaterial != null ? this.wrappedKeyMaterial.toBuilder() : null;
        }

        public final void setWrappedKeyMaterial(WrappedKeyMaterial.BuilderImpl wrappedKeyMaterial) {
            this.wrappedKeyMaterial = wrappedKeyMaterial != null ? wrappedKeyMaterial.build() : null;
        }

        @Override
        public final Builder wrappedKeyMaterial(WrappedKeyMaterial wrappedKeyMaterial) {
            this.wrappedKeyMaterial = wrappedKeyMaterial;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        public WrappedKey build() {
            return new WrappedKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WrappedKey> {
        public Builder wrappedKeyMaterial(WrappedKeyMaterial var1);

        default public Builder wrappedKeyMaterial(Consumer<WrappedKeyMaterial.Builder> wrappedKeyMaterial) {
            return this.wrappedKeyMaterial((WrappedKeyMaterial)((WrappedKeyMaterial.Builder)WrappedKeyMaterial.builder().applyMutation(wrappedKeyMaterial)).build());
        }

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);
    }
}

