/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.EmvEncryptionMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockLengthPosition;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockPaddingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmvCommonAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmvCommonAttributes> {
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorKeyDerivationMode").getter(EmvCommonAttributes.getter(EmvCommonAttributes::majorKeyDerivationModeAsString)).setter(EmvCommonAttributes.setter(Builder::majorKeyDerivationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(EmvCommonAttributes.getter(EmvCommonAttributes::primaryAccountNumber)).setter(EmvCommonAttributes.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PanSequenceNumber").getter(EmvCommonAttributes.getter(EmvCommonAttributes::panSequenceNumber)).setter(EmvCommonAttributes.setter(Builder::panSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()}).build();
    private static final SdkField<String> APPLICATION_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationCryptogram").getter(EmvCommonAttributes.getter(EmvCommonAttributes::applicationCryptogram)).setter(EmvCommonAttributes.setter(Builder::applicationCryptogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCryptogram").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(EmvCommonAttributes.getter(EmvCommonAttributes::modeAsString)).setter(EmvCommonAttributes.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PIN_BLOCK_PADDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinBlockPaddingType").getter(EmvCommonAttributes.getter(EmvCommonAttributes::pinBlockPaddingTypeAsString)).setter(EmvCommonAttributes.setter(Builder::pinBlockPaddingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockPaddingType").build()}).build();
    private static final SdkField<String> PIN_BLOCK_LENGTH_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinBlockLengthPosition").getter(EmvCommonAttributes.getter(EmvCommonAttributes::pinBlockLengthPositionAsString)).setter(EmvCommonAttributes.setter(Builder::pinBlockLengthPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockLengthPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_KEY_DERIVATION_MODE_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, APPLICATION_CRYPTOGRAM_FIELD, MODE_FIELD, PIN_BLOCK_PADDING_TYPE_FIELD, PIN_BLOCK_LENGTH_POSITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String majorKeyDerivationMode;
    private final String primaryAccountNumber;
    private final String panSequenceNumber;
    private final String applicationCryptogram;
    private final String mode;
    private final String pinBlockPaddingType;
    private final String pinBlockLengthPosition;

    private EmvCommonAttributes(BuilderImpl builder) {
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.applicationCryptogram = builder.applicationCryptogram;
        this.mode = builder.mode;
        this.pinBlockPaddingType = builder.pinBlockPaddingType;
        this.pinBlockLengthPosition = builder.pinBlockLengthPosition;
    }

    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(this.majorKeyDerivationMode);
    }

    public final String majorKeyDerivationModeAsString() {
        return this.majorKeyDerivationMode;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final String panSequenceNumber() {
        return this.panSequenceNumber;
    }

    public final String applicationCryptogram() {
        return this.applicationCryptogram;
    }

    public final EmvEncryptionMode mode() {
        return EmvEncryptionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final PinBlockPaddingType pinBlockPaddingType() {
        return PinBlockPaddingType.fromValue(this.pinBlockPaddingType);
    }

    public final String pinBlockPaddingTypeAsString() {
        return this.pinBlockPaddingType;
    }

    public final PinBlockLengthPosition pinBlockLengthPosition() {
        return PinBlockLengthPosition.fromValue(this.pinBlockLengthPosition);
    }

    public final String pinBlockLengthPositionAsString() {
        return this.pinBlockLengthPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinBlockPaddingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinBlockLengthPositionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmvCommonAttributes)) {
            return false;
        }
        EmvCommonAttributes other = (EmvCommonAttributes)obj;
        return Objects.equals(this.majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.panSequenceNumber(), other.panSequenceNumber()) && Objects.equals(this.applicationCryptogram(), other.applicationCryptogram()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.pinBlockPaddingTypeAsString(), other.pinBlockPaddingTypeAsString()) && Objects.equals(this.pinBlockLengthPositionAsString(), other.pinBlockLengthPositionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EmvCommonAttributes").add("MajorKeyDerivationMode", (Object)this.majorKeyDerivationModeAsString()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PanSequenceNumber", (Object)this.panSequenceNumber()).add("ApplicationCryptogram", (Object)(this.applicationCryptogram() == null ? null : "*** Sensitive Data Redacted ***")).add("Mode", (Object)this.modeAsString()).add("PinBlockPaddingType", (Object)this.pinBlockPaddingTypeAsString()).add("PinBlockLengthPosition", (Object)this.pinBlockLengthPositionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MajorKeyDerivationMode": {
                return Optional.ofNullable(clazz.cast(this.majorKeyDerivationModeAsString()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "PanSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.panSequenceNumber()));
            }
            case "ApplicationCryptogram": {
                return Optional.ofNullable(clazz.cast(this.applicationCryptogram()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "PinBlockPaddingType": {
                return Optional.ofNullable(clazz.cast(this.pinBlockPaddingTypeAsString()));
            }
            case "PinBlockLengthPosition": {
                return Optional.ofNullable(clazz.cast(this.pinBlockLengthPositionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmvCommonAttributes, T> g) {
        return obj -> g.apply((EmvCommonAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String majorKeyDerivationMode;
        private String primaryAccountNumber;
        private String panSequenceNumber;
        private String applicationCryptogram;
        private String mode;
        private String pinBlockPaddingType;
        private String pinBlockLengthPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(EmvCommonAttributes model) {
            this.majorKeyDerivationMode(model.majorKeyDerivationMode);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.panSequenceNumber(model.panSequenceNumber);
            this.applicationCryptogram(model.applicationCryptogram);
            this.mode(model.mode);
            this.pinBlockPaddingType(model.pinBlockPaddingType);
            this.pinBlockLengthPosition(model.pinBlockLengthPosition);
        }

        public final String getMajorKeyDerivationMode() {
            return this.majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getApplicationCryptogram() {
            return this.applicationCryptogram;
        }

        public final void setApplicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
        }

        @Override
        public final Builder applicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(EmvEncryptionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPinBlockPaddingType() {
            return this.pinBlockPaddingType;
        }

        public final void setPinBlockPaddingType(String pinBlockPaddingType) {
            this.pinBlockPaddingType = pinBlockPaddingType;
        }

        @Override
        public final Builder pinBlockPaddingType(String pinBlockPaddingType) {
            this.pinBlockPaddingType = pinBlockPaddingType;
            return this;
        }

        @Override
        public final Builder pinBlockPaddingType(PinBlockPaddingType pinBlockPaddingType) {
            this.pinBlockPaddingType(pinBlockPaddingType == null ? null : pinBlockPaddingType.toString());
            return this;
        }

        public final String getPinBlockLengthPosition() {
            return this.pinBlockLengthPosition;
        }

        public final void setPinBlockLengthPosition(String pinBlockLengthPosition) {
            this.pinBlockLengthPosition = pinBlockLengthPosition;
        }

        @Override
        public final Builder pinBlockLengthPosition(String pinBlockLengthPosition) {
            this.pinBlockLengthPosition = pinBlockLengthPosition;
            return this;
        }

        @Override
        public final Builder pinBlockLengthPosition(PinBlockLengthPosition pinBlockLengthPosition) {
            this.pinBlockLengthPosition(pinBlockLengthPosition == null ? null : pinBlockLengthPosition.toString());
            return this;
        }

        public EmvCommonAttributes build() {
            return new EmvCommonAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmvCommonAttributes> {
        public Builder majorKeyDerivationMode(String var1);

        public Builder majorKeyDerivationMode(MajorKeyDerivationMode var1);

        public Builder primaryAccountNumber(String var1);

        public Builder panSequenceNumber(String var1);

        public Builder applicationCryptogram(String var1);

        public Builder mode(String var1);

        public Builder mode(EmvEncryptionMode var1);

        public Builder pinBlockPaddingType(String var1);

        public Builder pinBlockPaddingType(PinBlockPaddingType var1);

        public Builder pinBlockLengthPosition(String var1);

        public Builder pinBlockLengthPosition(PinBlockLengthPosition var1);
    }
}

