/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.EmvEncryptionMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.EmvMajorKeyDerivationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmvEncryptionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmvEncryptionAttributes> {
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorKeyDerivationMode").getter(EmvEncryptionAttributes.getter(EmvEncryptionAttributes::majorKeyDerivationModeAsString)).setter(EmvEncryptionAttributes.setter(Builder::majorKeyDerivationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(EmvEncryptionAttributes.getter(EmvEncryptionAttributes::primaryAccountNumber)).setter(EmvEncryptionAttributes.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PanSequenceNumber").getter(EmvEncryptionAttributes.getter(EmvEncryptionAttributes::panSequenceNumber)).setter(EmvEncryptionAttributes.setter(Builder::panSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()}).build();
    private static final SdkField<String> SESSION_DERIVATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionDerivationData").getter(EmvEncryptionAttributes.getter(EmvEncryptionAttributes::sessionDerivationData)).setter(EmvEncryptionAttributes.setter(Builder::sessionDerivationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDerivationData").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(EmvEncryptionAttributes.getter(EmvEncryptionAttributes::modeAsString)).setter(EmvEncryptionAttributes.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVector").getter(EmvEncryptionAttributes.getter(EmvEncryptionAttributes::initializationVector)).setter(EmvEncryptionAttributes.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_KEY_DERIVATION_MODE_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, SESSION_DERIVATION_DATA_FIELD, MODE_FIELD, INITIALIZATION_VECTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String majorKeyDerivationMode;
    private final String primaryAccountNumber;
    private final String panSequenceNumber;
    private final String sessionDerivationData;
    private final String mode;
    private final String initializationVector;

    private EmvEncryptionAttributes(BuilderImpl builder) {
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.sessionDerivationData = builder.sessionDerivationData;
        this.mode = builder.mode;
        this.initializationVector = builder.initializationVector;
    }

    public final EmvMajorKeyDerivationMode majorKeyDerivationMode() {
        return EmvMajorKeyDerivationMode.fromValue(this.majorKeyDerivationMode);
    }

    public final String majorKeyDerivationModeAsString() {
        return this.majorKeyDerivationMode;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final String panSequenceNumber() {
        return this.panSequenceNumber;
    }

    public final String sessionDerivationData() {
        return this.sessionDerivationData;
    }

    public final EmvEncryptionMode mode() {
        return EmvEncryptionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String initializationVector() {
        return this.initializationVector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionDerivationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmvEncryptionAttributes)) {
            return false;
        }
        EmvEncryptionAttributes other = (EmvEncryptionAttributes)obj;
        return Objects.equals(this.majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.panSequenceNumber(), other.panSequenceNumber()) && Objects.equals(this.sessionDerivationData(), other.sessionDerivationData()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.initializationVector(), other.initializationVector());
    }

    public final String toString() {
        return ToString.builder((String)"EmvEncryptionAttributes").add("MajorKeyDerivationMode", (Object)this.majorKeyDerivationModeAsString()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PanSequenceNumber", (Object)this.panSequenceNumber()).add("SessionDerivationData", (Object)(this.sessionDerivationData() == null ? null : "*** Sensitive Data Redacted ***")).add("Mode", (Object)this.modeAsString()).add("InitializationVector", (Object)(this.initializationVector() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MajorKeyDerivationMode": {
                return Optional.ofNullable(clazz.cast(this.majorKeyDerivationModeAsString()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "PanSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.panSequenceNumber()));
            }
            case "SessionDerivationData": {
                return Optional.ofNullable(clazz.cast(this.sessionDerivationData()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmvEncryptionAttributes, T> g) {
        return obj -> g.apply((EmvEncryptionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String majorKeyDerivationMode;
        private String primaryAccountNumber;
        private String panSequenceNumber;
        private String sessionDerivationData;
        private String mode;
        private String initializationVector;

        private BuilderImpl() {
        }

        private BuilderImpl(EmvEncryptionAttributes model) {
            this.majorKeyDerivationMode(model.majorKeyDerivationMode);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.panSequenceNumber(model.panSequenceNumber);
            this.sessionDerivationData(model.sessionDerivationData);
            this.mode(model.mode);
            this.initializationVector(model.initializationVector);
        }

        public final String getMajorKeyDerivationMode() {
            return this.majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(EmvMajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getSessionDerivationData() {
            return this.sessionDerivationData;
        }

        public final void setSessionDerivationData(String sessionDerivationData) {
            this.sessionDerivationData = sessionDerivationData;
        }

        @Override
        public final Builder sessionDerivationData(String sessionDerivationData) {
            this.sessionDerivationData = sessionDerivationData;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(EmvEncryptionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public EmvEncryptionAttributes build() {
            return new EmvEncryptionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmvEncryptionAttributes> {
        public Builder majorKeyDerivationMode(String var1);

        public Builder majorKeyDerivationMode(EmvMajorKeyDerivationMode var1);

        public Builder primaryAccountNumber(String var1);

        public Builder panSequenceNumber(String var1);

        public Builder sessionDerivationData(String var1);

        public Builder mode(String var1);

        public Builder mode(EmvEncryptionMode var1);

        public Builder initializationVector(String var1);
    }
}

