/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm;
import software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmDukpt;
import software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmEmv;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MacAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MacAttributes> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(MacAttributes.getter(MacAttributes::algorithmAsString)).setter(MacAttributes.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()}).build();
    private static final SdkField<MacAlgorithmEmv> EMV_MAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmvMac").getter(MacAttributes.getter(MacAttributes::emvMac)).setter(MacAttributes.setter(Builder::emvMac)).constructor(MacAlgorithmEmv::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmvMac").build()}).build();
    private static final SdkField<MacAlgorithmDukpt> DUKPT_ISO9797_ALGORITHM1_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DukptIso9797Algorithm1").getter(MacAttributes.getter(MacAttributes::dukptIso9797Algorithm1)).setter(MacAttributes.setter(Builder::dukptIso9797Algorithm1)).constructor(MacAlgorithmDukpt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptIso9797Algorithm1").build()}).build();
    private static final SdkField<MacAlgorithmDukpt> DUKPT_ISO9797_ALGORITHM3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DukptIso9797Algorithm3").getter(MacAttributes.getter(MacAttributes::dukptIso9797Algorithm3)).setter(MacAttributes.setter(Builder::dukptIso9797Algorithm3)).constructor(MacAlgorithmDukpt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptIso9797Algorithm3").build()}).build();
    private static final SdkField<MacAlgorithmDukpt> DUKPT_CMAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DukptCmac").getter(MacAttributes.getter(MacAttributes::dukptCmac)).setter(MacAttributes.setter(Builder::dukptCmac)).constructor(MacAlgorithmDukpt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptCmac").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, EMV_MAC_FIELD, DUKPT_ISO9797_ALGORITHM1_FIELD, DUKPT_ISO9797_ALGORITHM3_FIELD, DUKPT_CMAC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Algorithm", ALGORITHM_FIELD);
            this.put("EmvMac", EMV_MAC_FIELD);
            this.put("DukptIso9797Algorithm1", DUKPT_ISO9797_ALGORITHM1_FIELD);
            this.put("DukptIso9797Algorithm3", DUKPT_ISO9797_ALGORITHM3_FIELD);
            this.put("DukptCmac", DUKPT_CMAC_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final MacAlgorithmEmv emvMac;
    private final MacAlgorithmDukpt dukptIso9797Algorithm1;
    private final MacAlgorithmDukpt dukptIso9797Algorithm3;
    private final MacAlgorithmDukpt dukptCmac;
    private final Type type;

    private MacAttributes(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.emvMac = builder.emvMac;
        this.dukptIso9797Algorithm1 = builder.dukptIso9797Algorithm1;
        this.dukptIso9797Algorithm3 = builder.dukptIso9797Algorithm3;
        this.dukptCmac = builder.dukptCmac;
        this.type = builder.type;
    }

    public final MacAlgorithm algorithm() {
        return MacAlgorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final MacAlgorithmEmv emvMac() {
        return this.emvMac;
    }

    public final MacAlgorithmDukpt dukptIso9797Algorithm1() {
        return this.dukptIso9797Algorithm1;
    }

    public final MacAlgorithmDukpt dukptIso9797Algorithm3() {
        return this.dukptIso9797Algorithm3;
    }

    public final MacAlgorithmDukpt dukptCmac() {
        return this.dukptCmac;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.emvMac());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptIso9797Algorithm1());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptIso9797Algorithm3());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptCmac());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAttributes)) {
            return false;
        }
        MacAttributes other = (MacAttributes)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.emvMac(), other.emvMac()) && Objects.equals(this.dukptIso9797Algorithm1(), other.dukptIso9797Algorithm1()) && Objects.equals(this.dukptIso9797Algorithm3(), other.dukptIso9797Algorithm3()) && Objects.equals(this.dukptCmac(), other.dukptCmac());
    }

    public final String toString() {
        return ToString.builder((String)"MacAttributes").add("Algorithm", (Object)this.algorithmAsString()).add("EmvMac", (Object)this.emvMac()).add("DukptIso9797Algorithm1", (Object)this.dukptIso9797Algorithm1()).add("DukptIso9797Algorithm3", (Object)this.dukptIso9797Algorithm3()).add("DukptCmac", (Object)this.dukptCmac()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "EmvMac": {
                return Optional.ofNullable(clazz.cast(this.emvMac()));
            }
            case "DukptIso9797Algorithm1": {
                return Optional.ofNullable(clazz.cast(this.dukptIso9797Algorithm1()));
            }
            case "DukptIso9797Algorithm3": {
                return Optional.ofNullable(clazz.cast(this.dukptIso9797Algorithm3()));
            }
            case "DukptCmac": {
                return Optional.ofNullable(clazz.cast(this.dukptCmac()));
            }
        }
        return Optional.empty();
    }

    public static MacAttributes fromAlgorithm(String algorithm) {
        return (MacAttributes)MacAttributes.builder().algorithm(algorithm).build();
    }

    public static MacAttributes fromAlgorithm(MacAlgorithm algorithm) {
        return (MacAttributes)MacAttributes.builder().algorithm(algorithm).build();
    }

    public static MacAttributes fromEmvMac(MacAlgorithmEmv emvMac) {
        return (MacAttributes)MacAttributes.builder().emvMac(emvMac).build();
    }

    public static MacAttributes fromEmvMac(Consumer<MacAlgorithmEmv.Builder> emvMac) {
        MacAlgorithmEmv.Builder builder = MacAlgorithmEmv.builder();
        emvMac.accept(builder);
        return MacAttributes.fromEmvMac((MacAlgorithmEmv)builder.build());
    }

    public static MacAttributes fromDukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1) {
        return (MacAttributes)MacAttributes.builder().dukptIso9797Algorithm1(dukptIso9797Algorithm1).build();
    }

    public static MacAttributes fromDukptIso9797Algorithm1(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm1) {
        MacAlgorithmDukpt.Builder builder = MacAlgorithmDukpt.builder();
        dukptIso9797Algorithm1.accept(builder);
        return MacAttributes.fromDukptIso9797Algorithm1((MacAlgorithmDukpt)builder.build());
    }

    public static MacAttributes fromDukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3) {
        return (MacAttributes)MacAttributes.builder().dukptIso9797Algorithm3(dukptIso9797Algorithm3).build();
    }

    public static MacAttributes fromDukptIso9797Algorithm3(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm3) {
        MacAlgorithmDukpt.Builder builder = MacAlgorithmDukpt.builder();
        dukptIso9797Algorithm3.accept(builder);
        return MacAttributes.fromDukptIso9797Algorithm3((MacAlgorithmDukpt)builder.build());
    }

    public static MacAttributes fromDukptCmac(MacAlgorithmDukpt dukptCmac) {
        return (MacAttributes)MacAttributes.builder().dukptCmac(dukptCmac).build();
    }

    public static MacAttributes fromDukptCmac(Consumer<MacAlgorithmDukpt.Builder> dukptCmac) {
        MacAlgorithmDukpt.Builder builder = MacAlgorithmDukpt.builder();
        dukptCmac.accept(builder);
        return MacAttributes.fromDukptCmac((MacAlgorithmDukpt)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MacAttributes, T> g) {
        return obj -> g.apply((MacAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ALGORITHM,
        EMV_MAC,
        DUKPT_ISO9797_ALGORITHM1,
        DUKPT_ISO9797_ALGORITHM3,
        DUKPT_CMAC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private MacAlgorithmEmv emvMac;
        private MacAlgorithmDukpt dukptIso9797Algorithm1;
        private MacAlgorithmDukpt dukptIso9797Algorithm3;
        private MacAlgorithmDukpt dukptCmac;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MacAttributes model) {
            this.algorithm(model.algorithm);
            this.emvMac(model.emvMac);
            this.dukptIso9797Algorithm1(model.dukptIso9797Algorithm1);
            this.dukptIso9797Algorithm3(model.dukptIso9797Algorithm3);
            this.dukptCmac(model.dukptCmac);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            String oldValue = this.algorithm;
            this.algorithm = algorithm;
            this.handleUnionValueChange(Type.ALGORITHM, oldValue, this.algorithm);
        }

        @Override
        public final Builder algorithm(String algorithm) {
            String oldValue = this.algorithm;
            this.algorithm = algorithm;
            this.handleUnionValueChange(Type.ALGORITHM, oldValue, this.algorithm);
            return this;
        }

        @Override
        public final Builder algorithm(MacAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final MacAlgorithmEmv.Builder getEmvMac() {
            return this.emvMac != null ? this.emvMac.toBuilder() : null;
        }

        public final void setEmvMac(MacAlgorithmEmv.BuilderImpl emvMac) {
            MacAlgorithmEmv oldValue = this.emvMac;
            this.emvMac = emvMac != null ? emvMac.build() : null;
            this.handleUnionValueChange(Type.EMV_MAC, oldValue, this.emvMac);
        }

        @Override
        public final Builder emvMac(MacAlgorithmEmv emvMac) {
            MacAlgorithmEmv oldValue = this.emvMac;
            this.emvMac = emvMac;
            this.handleUnionValueChange(Type.EMV_MAC, oldValue, this.emvMac);
            return this;
        }

        public final MacAlgorithmDukpt.Builder getDukptIso9797Algorithm1() {
            return this.dukptIso9797Algorithm1 != null ? this.dukptIso9797Algorithm1.toBuilder() : null;
        }

        public final void setDukptIso9797Algorithm1(MacAlgorithmDukpt.BuilderImpl dukptIso9797Algorithm1) {
            MacAlgorithmDukpt oldValue = this.dukptIso9797Algorithm1;
            this.dukptIso9797Algorithm1 = dukptIso9797Algorithm1 != null ? dukptIso9797Algorithm1.build() : null;
            this.handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM1, oldValue, this.dukptIso9797Algorithm1);
        }

        @Override
        public final Builder dukptIso9797Algorithm1(MacAlgorithmDukpt dukptIso9797Algorithm1) {
            MacAlgorithmDukpt oldValue = this.dukptIso9797Algorithm1;
            this.dukptIso9797Algorithm1 = dukptIso9797Algorithm1;
            this.handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM1, oldValue, this.dukptIso9797Algorithm1);
            return this;
        }

        public final MacAlgorithmDukpt.Builder getDukptIso9797Algorithm3() {
            return this.dukptIso9797Algorithm3 != null ? this.dukptIso9797Algorithm3.toBuilder() : null;
        }

        public final void setDukptIso9797Algorithm3(MacAlgorithmDukpt.BuilderImpl dukptIso9797Algorithm3) {
            MacAlgorithmDukpt oldValue = this.dukptIso9797Algorithm3;
            this.dukptIso9797Algorithm3 = dukptIso9797Algorithm3 != null ? dukptIso9797Algorithm3.build() : null;
            this.handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM3, oldValue, this.dukptIso9797Algorithm3);
        }

        @Override
        public final Builder dukptIso9797Algorithm3(MacAlgorithmDukpt dukptIso9797Algorithm3) {
            MacAlgorithmDukpt oldValue = this.dukptIso9797Algorithm3;
            this.dukptIso9797Algorithm3 = dukptIso9797Algorithm3;
            this.handleUnionValueChange(Type.DUKPT_ISO9797_ALGORITHM3, oldValue, this.dukptIso9797Algorithm3);
            return this;
        }

        public final MacAlgorithmDukpt.Builder getDukptCmac() {
            return this.dukptCmac != null ? this.dukptCmac.toBuilder() : null;
        }

        public final void setDukptCmac(MacAlgorithmDukpt.BuilderImpl dukptCmac) {
            MacAlgorithmDukpt oldValue = this.dukptCmac;
            this.dukptCmac = dukptCmac != null ? dukptCmac.build() : null;
            this.handleUnionValueChange(Type.DUKPT_CMAC, oldValue, this.dukptCmac);
        }

        @Override
        public final Builder dukptCmac(MacAlgorithmDukpt dukptCmac) {
            MacAlgorithmDukpt oldValue = this.dukptCmac;
            this.dukptCmac = dukptCmac;
            this.handleUnionValueChange(Type.DUKPT_CMAC, oldValue, this.dukptCmac);
            return this;
        }

        public MacAttributes build() {
            return new MacAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MacAttributes> {
        public Builder algorithm(String var1);

        public Builder algorithm(MacAlgorithm var1);

        public Builder emvMac(MacAlgorithmEmv var1);

        default public Builder emvMac(Consumer<MacAlgorithmEmv.Builder> emvMac) {
            return this.emvMac((MacAlgorithmEmv)((MacAlgorithmEmv.Builder)MacAlgorithmEmv.builder().applyMutation(emvMac)).build());
        }

        public Builder dukptIso9797Algorithm1(MacAlgorithmDukpt var1);

        default public Builder dukptIso9797Algorithm1(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm1) {
            return this.dukptIso9797Algorithm1((MacAlgorithmDukpt)((MacAlgorithmDukpt.Builder)MacAlgorithmDukpt.builder().applyMutation(dukptIso9797Algorithm1)).build());
        }

        public Builder dukptIso9797Algorithm3(MacAlgorithmDukpt var1);

        default public Builder dukptIso9797Algorithm3(Consumer<MacAlgorithmDukpt.Builder> dukptIso9797Algorithm3) {
            return this.dukptIso9797Algorithm3((MacAlgorithmDukpt)((MacAlgorithmDukpt.Builder)MacAlgorithmDukpt.builder().applyMutation(dukptIso9797Algorithm3)).build());
        }

        public Builder dukptCmac(MacAlgorithmDukpt var1);

        default public Builder dukptCmac(Consumer<MacAlgorithmDukpt.Builder> dukptCmac) {
            return this.dukptCmac((MacAlgorithmDukpt)((MacAlgorithmDukpt.Builder)MacAlgorithmDukpt.builder().applyMutation(dukptCmac)).build());
        }
    }
}

