/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DukptEncryptionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DukptEncryptionAttributes> {
    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeySerialNumber").getter(DukptEncryptionAttributes.getter(DukptEncryptionAttributes::keySerialNumber)).setter(DukptEncryptionAttributes.setter(Builder::keySerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(DukptEncryptionAttributes.getter(DukptEncryptionAttributes::modeAsString)).setter(DukptEncryptionAttributes.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> DUKPT_KEY_DERIVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptKeyDerivationType").getter(DukptEncryptionAttributes.getter(DukptEncryptionAttributes::dukptKeyDerivationTypeAsString)).setter(DukptEncryptionAttributes.setter(Builder::dukptKeyDerivationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyDerivationType").build()}).build();
    private static final SdkField<String> DUKPT_KEY_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptKeyVariant").getter(DukptEncryptionAttributes.getter(DukptEncryptionAttributes::dukptKeyVariantAsString)).setter(DukptEncryptionAttributes.setter(Builder::dukptKeyVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyVariant").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVector").getter(DukptEncryptionAttributes.getter(DukptEncryptionAttributes::initializationVector)).setter(DukptEncryptionAttributes.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_SERIAL_NUMBER_FIELD, MODE_FIELD, DUKPT_KEY_DERIVATION_TYPE_FIELD, DUKPT_KEY_VARIANT_FIELD, INITIALIZATION_VECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeySerialNumber", KEY_SERIAL_NUMBER_FIELD);
            this.put("Mode", MODE_FIELD);
            this.put("DukptKeyDerivationType", DUKPT_KEY_DERIVATION_TYPE_FIELD);
            this.put("DukptKeyVariant", DUKPT_KEY_VARIANT_FIELD);
            this.put("InitializationVector", INITIALIZATION_VECTOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String keySerialNumber;
    private final String mode;
    private final String dukptKeyDerivationType;
    private final String dukptKeyVariant;
    private final String initializationVector;

    private DukptEncryptionAttributes(BuilderImpl builder) {
        this.keySerialNumber = builder.keySerialNumber;
        this.mode = builder.mode;
        this.dukptKeyDerivationType = builder.dukptKeyDerivationType;
        this.dukptKeyVariant = builder.dukptKeyVariant;
        this.initializationVector = builder.initializationVector;
    }

    public final String keySerialNumber() {
        return this.keySerialNumber;
    }

    public final DukptEncryptionMode mode() {
        return DukptEncryptionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final DukptDerivationType dukptKeyDerivationType() {
        return DukptDerivationType.fromValue(this.dukptKeyDerivationType);
    }

    public final String dukptKeyDerivationTypeAsString() {
        return this.dukptKeyDerivationType;
    }

    public final DukptKeyVariant dukptKeyVariant() {
        return DukptKeyVariant.fromValue(this.dukptKeyVariant);
    }

    public final String dukptKeyVariantAsString() {
        return this.dukptKeyVariant;
    }

    public final String initializationVector() {
        return this.initializationVector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keySerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptKeyDerivationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptKeyVariantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DukptEncryptionAttributes)) {
            return false;
        }
        DukptEncryptionAttributes other = (DukptEncryptionAttributes)obj;
        return Objects.equals(this.keySerialNumber(), other.keySerialNumber()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.dukptKeyDerivationTypeAsString(), other.dukptKeyDerivationTypeAsString()) && Objects.equals(this.dukptKeyVariantAsString(), other.dukptKeyVariantAsString()) && Objects.equals(this.initializationVector(), other.initializationVector());
    }

    public final String toString() {
        return ToString.builder((String)"DukptEncryptionAttributes").add("KeySerialNumber", (Object)this.keySerialNumber()).add("Mode", (Object)this.modeAsString()).add("DukptKeyDerivationType", (Object)this.dukptKeyDerivationTypeAsString()).add("DukptKeyVariant", (Object)this.dukptKeyVariantAsString()).add("InitializationVector", (Object)(this.initializationVector() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeySerialNumber": {
                return Optional.ofNullable(clazz.cast(this.keySerialNumber()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "DukptKeyDerivationType": {
                return Optional.ofNullable(clazz.cast(this.dukptKeyDerivationTypeAsString()));
            }
            case "DukptKeyVariant": {
                return Optional.ofNullable(clazz.cast(this.dukptKeyVariantAsString()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DukptEncryptionAttributes, T> g) {
        return obj -> g.apply((DukptEncryptionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keySerialNumber;
        private String mode;
        private String dukptKeyDerivationType;
        private String dukptKeyVariant;
        private String initializationVector;

        private BuilderImpl() {
        }

        private BuilderImpl(DukptEncryptionAttributes model) {
            this.keySerialNumber(model.keySerialNumber);
            this.mode(model.mode);
            this.dukptKeyDerivationType(model.dukptKeyDerivationType);
            this.dukptKeyVariant(model.dukptKeyVariant);
            this.initializationVector(model.initializationVector);
        }

        public final String getKeySerialNumber() {
            return this.keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DukptEncryptionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getDukptKeyDerivationType() {
            return this.dukptKeyDerivationType;
        }

        public final void setDukptKeyDerivationType(String dukptKeyDerivationType) {
            this.dukptKeyDerivationType = dukptKeyDerivationType;
        }

        @Override
        public final Builder dukptKeyDerivationType(String dukptKeyDerivationType) {
            this.dukptKeyDerivationType = dukptKeyDerivationType;
            return this;
        }

        @Override
        public final Builder dukptKeyDerivationType(DukptDerivationType dukptKeyDerivationType) {
            this.dukptKeyDerivationType(dukptKeyDerivationType == null ? null : dukptKeyDerivationType.toString());
            return this;
        }

        public final String getDukptKeyVariant() {
            return this.dukptKeyVariant;
        }

        public final void setDukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
        }

        @Override
        public final Builder dukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
            return this;
        }

        @Override
        public final Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant) {
            this.dukptKeyVariant(dukptKeyVariant == null ? null : dukptKeyVariant.toString());
            return this;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public DukptEncryptionAttributes build() {
            return new DukptEncryptionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DukptEncryptionAttributes> {
        public Builder keySerialNumber(String var1);

        public Builder mode(String var1);

        public Builder mode(DukptEncryptionMode var1);

        public Builder dukptKeyDerivationType(String var1);

        public Builder dukptKeyDerivationType(DukptDerivationType var1);

        public Builder dukptKeyVariant(String var1);

        public Builder dukptKeyVariant(DukptKeyVariant var1);

        public Builder initializationVector(String var1);
    }
}

