/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DukptAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DukptAttributes> {
    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeySerialNumber").getter(DukptAttributes.getter(DukptAttributes::keySerialNumber)).setter(DukptAttributes.setter(Builder::keySerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()}).build();
    private static final SdkField<String> DUKPT_DERIVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptDerivationType").getter(DukptAttributes.getter(DukptAttributes::dukptDerivationTypeAsString)).setter(DukptAttributes.setter(Builder::dukptDerivationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptDerivationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_SERIAL_NUMBER_FIELD, DUKPT_DERIVATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeySerialNumber", KEY_SERIAL_NUMBER_FIELD);
            this.put("DukptDerivationType", DUKPT_DERIVATION_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String keySerialNumber;
    private final String dukptDerivationType;

    private DukptAttributes(BuilderImpl builder) {
        this.keySerialNumber = builder.keySerialNumber;
        this.dukptDerivationType = builder.dukptDerivationType;
    }

    public final String keySerialNumber() {
        return this.keySerialNumber;
    }

    public final DukptDerivationType dukptDerivationType() {
        return DukptDerivationType.fromValue(this.dukptDerivationType);
    }

    public final String dukptDerivationTypeAsString() {
        return this.dukptDerivationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keySerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptDerivationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DukptAttributes)) {
            return false;
        }
        DukptAttributes other = (DukptAttributes)obj;
        return Objects.equals(this.keySerialNumber(), other.keySerialNumber()) && Objects.equals(this.dukptDerivationTypeAsString(), other.dukptDerivationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DukptAttributes").add("KeySerialNumber", (Object)this.keySerialNumber()).add("DukptDerivationType", (Object)this.dukptDerivationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeySerialNumber": {
                return Optional.ofNullable(clazz.cast(this.keySerialNumber()));
            }
            case "DukptDerivationType": {
                return Optional.ofNullable(clazz.cast(this.dukptDerivationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DukptAttributes, T> g) {
        return obj -> g.apply((DukptAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keySerialNumber;
        private String dukptDerivationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DukptAttributes model) {
            this.keySerialNumber(model.keySerialNumber);
            this.dukptDerivationType(model.dukptDerivationType);
        }

        public final String getKeySerialNumber() {
            return this.keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        public final String getDukptDerivationType() {
            return this.dukptDerivationType;
        }

        public final void setDukptDerivationType(String dukptDerivationType) {
            this.dukptDerivationType = dukptDerivationType;
        }

        @Override
        public final Builder dukptDerivationType(String dukptDerivationType) {
            this.dukptDerivationType = dukptDerivationType;
            return this;
        }

        @Override
        public final Builder dukptDerivationType(DukptDerivationType dukptDerivationType) {
            this.dukptDerivationType(dukptDerivationType == null ? null : dukptDerivationType.toString());
            return this;
        }

        public DukptAttributes build() {
            return new DukptAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DukptAttributes> {
        public Builder keySerialNumber(String var1);

        public Builder dukptDerivationType(String var1);

        public Builder dukptDerivationType(DukptDerivationType var1);
    }
}

