/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CurrentPinAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CurrentPinAttributes> {
    private static final SdkField<String> CURRENT_PIN_PEK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentPinPekIdentifier").getter(CurrentPinAttributes.getter(CurrentPinAttributes::currentPinPekIdentifier)).setter(CurrentPinAttributes.setter(Builder::currentPinPekIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPinPekIdentifier").build()}).build();
    private static final SdkField<String> CURRENT_ENCRYPTED_PIN_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentEncryptedPinBlock").getter(CurrentPinAttributes.getter(CurrentPinAttributes::currentEncryptedPinBlock)).setter(CurrentPinAttributes.setter(Builder::currentEncryptedPinBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentEncryptedPinBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PIN_PEK_IDENTIFIER_FIELD, CURRENT_ENCRYPTED_PIN_BLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CurrentPinPekIdentifier", CURRENT_PIN_PEK_IDENTIFIER_FIELD);
            this.put("CurrentEncryptedPinBlock", CURRENT_ENCRYPTED_PIN_BLOCK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String currentPinPekIdentifier;
    private final String currentEncryptedPinBlock;

    private CurrentPinAttributes(BuilderImpl builder) {
        this.currentPinPekIdentifier = builder.currentPinPekIdentifier;
        this.currentEncryptedPinBlock = builder.currentEncryptedPinBlock;
    }

    public final String currentPinPekIdentifier() {
        return this.currentPinPekIdentifier;
    }

    public final String currentEncryptedPinBlock() {
        return this.currentEncryptedPinBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPinPekIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentEncryptedPinBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentPinAttributes)) {
            return false;
        }
        CurrentPinAttributes other = (CurrentPinAttributes)obj;
        return Objects.equals(this.currentPinPekIdentifier(), other.currentPinPekIdentifier()) && Objects.equals(this.currentEncryptedPinBlock(), other.currentEncryptedPinBlock());
    }

    public final String toString() {
        return ToString.builder((String)"CurrentPinAttributes").add("CurrentPinPekIdentifier", (Object)this.currentPinPekIdentifier()).add("CurrentEncryptedPinBlock", (Object)(this.currentEncryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentPinPekIdentifier": {
                return Optional.ofNullable(clazz.cast(this.currentPinPekIdentifier()));
            }
            case "CurrentEncryptedPinBlock": {
                return Optional.ofNullable(clazz.cast(this.currentEncryptedPinBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CurrentPinAttributes, T> g) {
        return obj -> g.apply((CurrentPinAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentPinPekIdentifier;
        private String currentEncryptedPinBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentPinAttributes model) {
            this.currentPinPekIdentifier(model.currentPinPekIdentifier);
            this.currentEncryptedPinBlock(model.currentEncryptedPinBlock);
        }

        public final String getCurrentPinPekIdentifier() {
            return this.currentPinPekIdentifier;
        }

        public final void setCurrentPinPekIdentifier(String currentPinPekIdentifier) {
            this.currentPinPekIdentifier = currentPinPekIdentifier;
        }

        @Override
        public final Builder currentPinPekIdentifier(String currentPinPekIdentifier) {
            this.currentPinPekIdentifier = currentPinPekIdentifier;
            return this;
        }

        public final String getCurrentEncryptedPinBlock() {
            return this.currentEncryptedPinBlock;
        }

        public final void setCurrentEncryptedPinBlock(String currentEncryptedPinBlock) {
            this.currentEncryptedPinBlock = currentEncryptedPinBlock;
        }

        @Override
        public final Builder currentEncryptedPinBlock(String currentEncryptedPinBlock) {
            this.currentEncryptedPinBlock = currentEncryptedPinBlock;
            return this;
        }

        public CurrentPinAttributes build() {
            return new CurrentPinAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CurrentPinAttributes> {
        public Builder currentPinPekIdentifier(String var1);

        public Builder currentEncryptedPinBlock(String var1);
    }
}

