/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionKeyEmv2000
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionKeyEmv2000> {
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(SessionKeyEmv2000.getter(SessionKeyEmv2000::primaryAccountNumber)).setter(SessionKeyEmv2000.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PanSequenceNumber").getter(SessionKeyEmv2000.getter(SessionKeyEmv2000::panSequenceNumber)).setter(SessionKeyEmv2000.setter(Builder::panSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()}).build();
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationTransactionCounter").getter(SessionKeyEmv2000.getter(SessionKeyEmv2000::applicationTransactionCounter)).setter(SessionKeyEmv2000.setter(Builder::applicationTransactionCounter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_ACCOUNT_NUMBER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, APPLICATION_TRANSACTION_COUNTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String primaryAccountNumber;
    private final String panSequenceNumber;
    private final String applicationTransactionCounter;

    private SessionKeyEmv2000(BuilderImpl builder) {
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final String panSequenceNumber() {
        return this.panSequenceNumber;
    }

    public final String applicationTransactionCounter() {
        return this.applicationTransactionCounter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTransactionCounter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyEmv2000)) {
            return false;
        }
        SessionKeyEmv2000 other = (SessionKeyEmv2000)obj;
        return Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.panSequenceNumber(), other.panSequenceNumber()) && Objects.equals(this.applicationTransactionCounter(), other.applicationTransactionCounter());
    }

    public final String toString() {
        return ToString.builder((String)"SessionKeyEmv2000").add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PanSequenceNumber", (Object)this.panSequenceNumber()).add("ApplicationTransactionCounter", (Object)this.applicationTransactionCounter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "PanSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.panSequenceNumber()));
            }
            case "ApplicationTransactionCounter": {
                return Optional.ofNullable(clazz.cast(this.applicationTransactionCounter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyEmv2000, T> g) {
        return obj -> g.apply((SessionKeyEmv2000)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryAccountNumber;
        private String panSequenceNumber;
        private String applicationTransactionCounter;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyEmv2000 model) {
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.panSequenceNumber(model.panSequenceNumber);
            this.applicationTransactionCounter(model.applicationTransactionCounter);
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getApplicationTransactionCounter() {
            return this.applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public SessionKeyEmv2000 build() {
            return new SessionKeyEmv2000(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionKeyEmv2000> {
        public Builder primaryAccountNumber(String var1);

        public Builder panSequenceNumber(String var1);

        public Builder applicationTransactionCounter(String var1);
    }
}

