/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyMacRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, VerifyMacRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(VerifyMacRequest.getter(VerifyMacRequest::keyIdentifier)).setter(VerifyMacRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> MAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mac").getter(VerifyMacRequest.getter(VerifyMacRequest::mac)).setter(VerifyMacRequest.setter(Builder::mac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mac").build()}).build();
    private static final SdkField<Integer> MAC_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MacLength").getter(VerifyMacRequest.getter(VerifyMacRequest::macLength)).setter(VerifyMacRequest.setter(Builder::macLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacLength").build()}).build();
    private static final SdkField<String> MESSAGE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageData").getter(VerifyMacRequest.getter(VerifyMacRequest::messageData)).setter(VerifyMacRequest.setter(Builder::messageData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageData").build()}).build();
    private static final SdkField<MacAttributes> VERIFICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationAttributes").getter(VerifyMacRequest.getter(VerifyMacRequest::verificationAttributes)).setter(VerifyMacRequest.setter(Builder::verificationAttributes)).constructor(MacAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, MAC_FIELD, MAC_LENGTH_FIELD, MESSAGE_DATA_FIELD, VERIFICATION_ATTRIBUTES_FIELD));
    private final String keyIdentifier;
    private final String mac;
    private final Integer macLength;
    private final String messageData;
    private final MacAttributes verificationAttributes;

    private VerifyMacRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.mac = builder.mac;
        this.macLength = builder.macLength;
        this.messageData = builder.messageData;
        this.verificationAttributes = builder.verificationAttributes;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final String mac() {
        return this.mac;
    }

    public final Integer macLength() {
        return this.macLength;
    }

    public final String messageData() {
        return this.messageData;
    }

    public final MacAttributes verificationAttributes() {
        return this.verificationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mac());
        hashCode = 31 * hashCode + Objects.hashCode(this.macLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageData());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyMacRequest)) {
            return false;
        }
        VerifyMacRequest other = (VerifyMacRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.mac(), other.mac()) && Objects.equals(this.macLength(), other.macLength()) && Objects.equals(this.messageData(), other.messageData()) && Objects.equals(this.verificationAttributes(), other.verificationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyMacRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("Mac", (Object)(this.mac() == null ? null : "*** Sensitive Data Redacted ***")).add("MacLength", (Object)this.macLength()).add("MessageData", (Object)(this.messageData() == null ? null : "*** Sensitive Data Redacted ***")).add("VerificationAttributes", (Object)this.verificationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "Mac": {
                return Optional.ofNullable(clazz.cast(this.mac()));
            }
            case "MacLength": {
                return Optional.ofNullable(clazz.cast(this.macLength()));
            }
            case "MessageData": {
                return Optional.ofNullable(clazz.cast(this.messageData()));
            }
            case "VerificationAttributes": {
                return Optional.ofNullable(clazz.cast(this.verificationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyMacRequest, T> g) {
        return obj -> g.apply((VerifyMacRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String mac;
        private Integer macLength;
        private String messageData;
        private MacAttributes verificationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyMacRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.mac(model.mac);
            this.macLength(model.macLength);
            this.messageData(model.messageData);
            this.verificationAttributes(model.verificationAttributes);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getMac() {
            return this.mac;
        }

        public final void setMac(String mac) {
            this.mac = mac;
        }

        @Override
        public final Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public final Integer getMacLength() {
            return this.macLength;
        }

        public final void setMacLength(Integer macLength) {
            this.macLength = macLength;
        }

        @Override
        public final Builder macLength(Integer macLength) {
            this.macLength = macLength;
            return this;
        }

        public final String getMessageData() {
            return this.messageData;
        }

        public final void setMessageData(String messageData) {
            this.messageData = messageData;
        }

        @Override
        public final Builder messageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public final MacAttributes.Builder getVerificationAttributes() {
            return this.verificationAttributes != null ? this.verificationAttributes.toBuilder() : null;
        }

        public final void setVerificationAttributes(MacAttributes.BuilderImpl verificationAttributes) {
            this.verificationAttributes = verificationAttributes != null ? verificationAttributes.build() : null;
        }

        @Override
        public final Builder verificationAttributes(MacAttributes verificationAttributes) {
            this.verificationAttributes = verificationAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyMacRequest build() {
            return new VerifyMacRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyMacRequest> {
        public Builder keyIdentifier(String var1);

        public Builder mac(String var1);

        public Builder macLength(Integer var1);

        public Builder messageData(String var1);

        public Builder verificationAttributes(MacAttributes var1);

        default public Builder verificationAttributes(Consumer<MacAttributes.Builder> verificationAttributes) {
            return this.verificationAttributes((MacAttributes)((MacAttributes.Builder)MacAttributes.builder().applyMutation(verificationAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

