/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DukptEncryptionMode {
    ECB("ECB"),
    CBC("CBC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DukptEncryptionMode> VALUE_MAP;
    private final String value;

    private DukptEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DukptEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DukptEncryptionMode> knownValues() {
        EnumSet<DukptEncryptionMode> knownValues = EnumSet.allOf(DukptEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DukptEncryptionMode.class, DukptEncryptionMode::toString);
    }
}

