/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReEncryptDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<ReEncryptDataRequest.Builder, ReEncryptDataRequest> {
    private static final SdkField<String> CIPHER_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CipherText").getter(getter(ReEncryptDataRequest::cipherText)).setter(setter(Builder::cipherText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CipherText").build()).build();

    private static final SdkField<ReEncryptionAttributes> INCOMING_ENCRYPTION_ATTRIBUTES_FIELD = SdkField
            .<ReEncryptionAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("IncomingEncryptionAttributes")
            .getter(getter(ReEncryptDataRequest::incomingEncryptionAttributes))
            .setter(setter(Builder::incomingEncryptionAttributes))
            .constructor(ReEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingEncryptionAttributes")
                    .build()).build();

    private static final SdkField<String> INCOMING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncomingKeyIdentifier").getter(getter(ReEncryptDataRequest::incomingKeyIdentifier))
            .setter(setter(Builder::incomingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IncomingKeyIdentifier").build())
            .build();

    private static final SdkField<ReEncryptionAttributes> OUTGOING_ENCRYPTION_ATTRIBUTES_FIELD = SdkField
            .<ReEncryptionAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("OutgoingEncryptionAttributes")
            .getter(getter(ReEncryptDataRequest::outgoingEncryptionAttributes))
            .setter(setter(Builder::outgoingEncryptionAttributes))
            .constructor(ReEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingEncryptionAttributes")
                    .build()).build();

    private static final SdkField<String> OUTGOING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutgoingKeyIdentifier").getter(getter(ReEncryptDataRequest::outgoingKeyIdentifier))
            .setter(setter(Builder::outgoingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingKeyIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHER_TEXT_FIELD,
            INCOMING_ENCRYPTION_ATTRIBUTES_FIELD, INCOMING_KEY_IDENTIFIER_FIELD, OUTGOING_ENCRYPTION_ATTRIBUTES_FIELD,
            OUTGOING_KEY_IDENTIFIER_FIELD));

    private final String cipherText;

    private final ReEncryptionAttributes incomingEncryptionAttributes;

    private final String incomingKeyIdentifier;

    private final ReEncryptionAttributes outgoingEncryptionAttributes;

    private final String outgoingKeyIdentifier;

    private ReEncryptDataRequest(BuilderImpl builder) {
        super(builder);
        this.cipherText = builder.cipherText;
        this.incomingEncryptionAttributes = builder.incomingEncryptionAttributes;
        this.incomingKeyIdentifier = builder.incomingKeyIdentifier;
        this.outgoingEncryptionAttributes = builder.outgoingEncryptionAttributes;
        this.outgoingKeyIdentifier = builder.outgoingKeyIdentifier;
    }

    /**
     * <p>
     * Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum allowed length is 4096 bytes.
     * </p>
     * 
     * @return Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum allowed length is 4096
     *         bytes.
     */
    public final String cipherText() {
        return cipherText;
    }

    /**
     * <p>
     * The attributes and values for incoming ciphertext.
     * </p>
     * 
     * @return The attributes and values for incoming ciphertext.
     */
    public final ReEncryptionAttributes incomingEncryptionAttributes() {
        return incomingEncryptionAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key of incoming ciphertext data.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key of incoming ciphertext data.
     */
    public final String incomingKeyIdentifier() {
        return incomingKeyIdentifier;
    }

    /**
     * <p>
     * The attributes and values for outgoing ciphertext data after encryption by Amazon Web Services Payment
     * Cryptography.
     * </p>
     * 
     * @return The attributes and values for outgoing ciphertext data after encryption by Amazon Web Services Payment
     *         Cryptography.
     */
    public final ReEncryptionAttributes outgoingEncryptionAttributes() {
        return outgoingEncryptionAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key of outgoing ciphertext data after encryption by Amazon Web Services
     * Payment Cryptography.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key of outgoing ciphertext data after encryption by Amazon Web
     *         Services Payment Cryptography.
     */
    public final String outgoingKeyIdentifier() {
        return outgoingKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cipherText());
        hashCode = 31 * hashCode + Objects.hashCode(incomingEncryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(incomingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingEncryptionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptDataRequest)) {
            return false;
        }
        ReEncryptDataRequest other = (ReEncryptDataRequest) obj;
        return Objects.equals(cipherText(), other.cipherText())
                && Objects.equals(incomingEncryptionAttributes(), other.incomingEncryptionAttributes())
                && Objects.equals(incomingKeyIdentifier(), other.incomingKeyIdentifier())
                && Objects.equals(outgoingEncryptionAttributes(), other.outgoingEncryptionAttributes())
                && Objects.equals(outgoingKeyIdentifier(), other.outgoingKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReEncryptDataRequest")
                .add("CipherText", cipherText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncomingEncryptionAttributes", incomingEncryptionAttributes())
                .add("IncomingKeyIdentifier", incomingKeyIdentifier())
                .add("OutgoingEncryptionAttributes", outgoingEncryptionAttributes())
                .add("OutgoingKeyIdentifier", outgoingKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CipherText":
            return Optional.ofNullable(clazz.cast(cipherText()));
        case "IncomingEncryptionAttributes":
            return Optional.ofNullable(clazz.cast(incomingEncryptionAttributes()));
        case "IncomingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(incomingKeyIdentifier()));
        case "OutgoingEncryptionAttributes":
            return Optional.ofNullable(clazz.cast(outgoingEncryptionAttributes()));
        case "OutgoingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(outgoingKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReEncryptDataRequest, T> g) {
        return obj -> g.apply((ReEncryptDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ReEncryptDataRequest> {
        /**
         * <p>
         * Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum allowed length is 4096 bytes.
         * </p>
         * 
         * @param cipherText
         *        Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum allowed length is 4096
         *        bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cipherText(String cipherText);

        /**
         * <p>
         * The attributes and values for incoming ciphertext.
         * </p>
         * 
         * @param incomingEncryptionAttributes
         *        The attributes and values for incoming ciphertext.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingEncryptionAttributes(ReEncryptionAttributes incomingEncryptionAttributes);

        /**
         * <p>
         * The attributes and values for incoming ciphertext.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReEncryptionAttributes.Builder} avoiding
         * the need to create one manually via {@link ReEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReEncryptionAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #incomingEncryptionAttributes(ReEncryptionAttributes)}.
         * 
         * @param incomingEncryptionAttributes
         *        a consumer that will call methods on {@link ReEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incomingEncryptionAttributes(ReEncryptionAttributes)
         */
        default Builder incomingEncryptionAttributes(Consumer<ReEncryptionAttributes.Builder> incomingEncryptionAttributes) {
            return incomingEncryptionAttributes(ReEncryptionAttributes.builder().applyMutation(incomingEncryptionAttributes)
                    .build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key of incoming ciphertext data.
         * </p>
         * 
         * @param incomingKeyIdentifier
         *        The <code>keyARN</code> of the encryption key of incoming ciphertext data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingKeyIdentifier(String incomingKeyIdentifier);

        /**
         * <p>
         * The attributes and values for outgoing ciphertext data after encryption by Amazon Web Services Payment
         * Cryptography.
         * </p>
         * 
         * @param outgoingEncryptionAttributes
         *        The attributes and values for outgoing ciphertext data after encryption by Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingEncryptionAttributes(ReEncryptionAttributes outgoingEncryptionAttributes);

        /**
         * <p>
         * The attributes and values for outgoing ciphertext data after encryption by Amazon Web Services Payment
         * Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReEncryptionAttributes.Builder} avoiding
         * the need to create one manually via {@link ReEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReEncryptionAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #outgoingEncryptionAttributes(ReEncryptionAttributes)}.
         * 
         * @param outgoingEncryptionAttributes
         *        a consumer that will call methods on {@link ReEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outgoingEncryptionAttributes(ReEncryptionAttributes)
         */
        default Builder outgoingEncryptionAttributes(Consumer<ReEncryptionAttributes.Builder> outgoingEncryptionAttributes) {
            return outgoingEncryptionAttributes(ReEncryptionAttributes.builder().applyMutation(outgoingEncryptionAttributes)
                    .build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key of outgoing ciphertext data after encryption by Amazon Web
         * Services Payment Cryptography.
         * </p>
         * 
         * @param outgoingKeyIdentifier
         *        The <code>keyARN</code> of the encryption key of outgoing ciphertext data after encryption by Amazon
         *        Web Services Payment Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingKeyIdentifier(String outgoingKeyIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String cipherText;

        private ReEncryptionAttributes incomingEncryptionAttributes;

        private String incomingKeyIdentifier;

        private ReEncryptionAttributes outgoingEncryptionAttributes;

        private String outgoingKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptDataRequest model) {
            super(model);
            cipherText(model.cipherText);
            incomingEncryptionAttributes(model.incomingEncryptionAttributes);
            incomingKeyIdentifier(model.incomingKeyIdentifier);
            outgoingEncryptionAttributes(model.outgoingEncryptionAttributes);
            outgoingKeyIdentifier(model.outgoingKeyIdentifier);
        }

        public final String getCipherText() {
            return cipherText;
        }

        public final void setCipherText(String cipherText) {
            this.cipherText = cipherText;
        }

        @Override
        public final Builder cipherText(String cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public final ReEncryptionAttributes.Builder getIncomingEncryptionAttributes() {
            return incomingEncryptionAttributes != null ? incomingEncryptionAttributes.toBuilder() : null;
        }

        public final void setIncomingEncryptionAttributes(ReEncryptionAttributes.BuilderImpl incomingEncryptionAttributes) {
            this.incomingEncryptionAttributes = incomingEncryptionAttributes != null ? incomingEncryptionAttributes.build()
                    : null;
        }

        @Override
        public final Builder incomingEncryptionAttributes(ReEncryptionAttributes incomingEncryptionAttributes) {
            this.incomingEncryptionAttributes = incomingEncryptionAttributes;
            return this;
        }

        public final String getIncomingKeyIdentifier() {
            return incomingKeyIdentifier;
        }

        public final void setIncomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
        }

        @Override
        public final Builder incomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
            return this;
        }

        public final ReEncryptionAttributes.Builder getOutgoingEncryptionAttributes() {
            return outgoingEncryptionAttributes != null ? outgoingEncryptionAttributes.toBuilder() : null;
        }

        public final void setOutgoingEncryptionAttributes(ReEncryptionAttributes.BuilderImpl outgoingEncryptionAttributes) {
            this.outgoingEncryptionAttributes = outgoingEncryptionAttributes != null ? outgoingEncryptionAttributes.build()
                    : null;
        }

        @Override
        public final Builder outgoingEncryptionAttributes(ReEncryptionAttributes outgoingEncryptionAttributes) {
            this.outgoingEncryptionAttributes = outgoingEncryptionAttributes;
            return this;
        }

        public final String getOutgoingKeyIdentifier() {
            return outgoingKeyIdentifier;
        }

        public final void setOutgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
        }

        @Override
        public final Builder outgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReEncryptDataRequest build() {
            return new ReEncryptDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
