/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for EMV MAC generation and verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MacAlgorithmEmv implements SdkPojo, Serializable, ToCopyableBuilder<MacAlgorithmEmv.Builder, MacAlgorithmEmv> {
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorKeyDerivationMode").getter(getter(MacAlgorithmEmv::majorKeyDerivationModeAsString))
            .setter(setter(Builder::majorKeyDerivationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build())
            .build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(MacAlgorithmEmv::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(MacAlgorithmEmv::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<String> SESSION_KEY_DERIVATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionKeyDerivationMode").getter(getter(MacAlgorithmEmv::sessionKeyDerivationModeAsString))
            .setter(setter(Builder::sessionKeyDerivationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeyDerivationMode").build())
            .build();

    private static final SdkField<SessionKeyDerivationValue> SESSION_KEY_DERIVATION_VALUE_FIELD = SdkField
            .<SessionKeyDerivationValue> builder(MarshallingType.SDK_POJO).memberName("SessionKeyDerivationValue")
            .getter(getter(MacAlgorithmEmv::sessionKeyDerivationValue)).setter(setter(Builder::sessionKeyDerivationValue))
            .constructor(SessionKeyDerivationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeyDerivationValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAJOR_KEY_DERIVATION_MODE_FIELD, PAN_SEQUENCE_NUMBER_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD,
            SESSION_KEY_DERIVATION_MODE_FIELD, SESSION_KEY_DERIVATION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String majorKeyDerivationMode;

    private final String panSequenceNumber;

    private final String primaryAccountNumber;

    private final String sessionKeyDerivationMode;

    private final SessionKeyDerivationValue sessionKeyDerivationValue;

    private MacAlgorithmEmv(BuilderImpl builder) {
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.sessionKeyDerivationMode = builder.sessionKeyDerivationMode;
        this.sessionKeyDerivationValue = builder.sessionKeyDerivationValue;
    }

    /**
     * <p>
     * The method to use when deriving the master key for EMV MAC generation or verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link MajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method to use when deriving the master key for EMV MAC generation or verification.
     * @see MajorKeyDerivationMode
     */
    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(majorKeyDerivationMode);
    }

    /**
     * <p>
     * The method to use when deriving the master key for EMV MAC generation or verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link MajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method to use when deriving the master key for EMV MAC generation or verification.
     * @see MajorKeyDerivationMode
     */
    public final String majorKeyDerivationModeAsString() {
        return majorKeyDerivationMode;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates the card
     * to a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates
     *         the card to a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * The method of deriving a session key for EMV MAC generation or verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sessionKeyDerivationMode} will return {@link SessionKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #sessionKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method of deriving a session key for EMV MAC generation or verification.
     * @see SessionKeyDerivationMode
     */
    public final SessionKeyDerivationMode sessionKeyDerivationMode() {
        return SessionKeyDerivationMode.fromValue(sessionKeyDerivationMode);
    }

    /**
     * <p>
     * The method of deriving a session key for EMV MAC generation or verification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sessionKeyDerivationMode} will return {@link SessionKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #sessionKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method of deriving a session key for EMV MAC generation or verification.
     * @see SessionKeyDerivationMode
     */
    public final String sessionKeyDerivationModeAsString() {
        return sessionKeyDerivationMode;
    }

    /**
     * <p>
     * Parameters that are required to generate session key for EMV generation and verification.
     * </p>
     * 
     * @return Parameters that are required to generate session key for EMV generation and verification.
     */
    public final SessionKeyDerivationValue sessionKeyDerivationValue() {
        return sessionKeyDerivationValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sessionKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionKeyDerivationValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAlgorithmEmv)) {
            return false;
        }
        MacAlgorithmEmv other = (MacAlgorithmEmv) obj;
        return Objects.equals(majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(sessionKeyDerivationModeAsString(), other.sessionKeyDerivationModeAsString())
                && Objects.equals(sessionKeyDerivationValue(), other.sessionKeyDerivationValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MacAlgorithmEmv").add("MajorKeyDerivationMode", majorKeyDerivationModeAsString())
                .add("PanSequenceNumber", panSequenceNumber())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionKeyDerivationMode", sessionKeyDerivationModeAsString())
                .add("SessionKeyDerivationValue", sessionKeyDerivationValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MajorKeyDerivationMode":
            return Optional.ofNullable(clazz.cast(majorKeyDerivationModeAsString()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "SessionKeyDerivationMode":
            return Optional.ofNullable(clazz.cast(sessionKeyDerivationModeAsString()));
        case "SessionKeyDerivationValue":
            return Optional.ofNullable(clazz.cast(sessionKeyDerivationValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MacAlgorithmEmv, T> g) {
        return obj -> g.apply((MacAlgorithmEmv) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MacAlgorithmEmv> {
        /**
         * <p>
         * The method to use when deriving the master key for EMV MAC generation or verification.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The method to use when deriving the master key for EMV MAC generation or verification.
         * @see MajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(String majorKeyDerivationMode);

        /**
         * <p>
         * The method to use when deriving the master key for EMV MAC generation or verification.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The method to use when deriving the master key for EMV MAC generation or verification.
         * @see MajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and associates the
         * card to a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN), a unique identifier for a payment credit or debit card and
         *        associates the card to a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * The method of deriving a session key for EMV MAC generation or verification.
         * </p>
         * 
         * @param sessionKeyDerivationMode
         *        The method of deriving a session key for EMV MAC generation or verification.
         * @see SessionKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionKeyDerivationMode
         */
        Builder sessionKeyDerivationMode(String sessionKeyDerivationMode);

        /**
         * <p>
         * The method of deriving a session key for EMV MAC generation or verification.
         * </p>
         * 
         * @param sessionKeyDerivationMode
         *        The method of deriving a session key for EMV MAC generation or verification.
         * @see SessionKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionKeyDerivationMode
         */
        Builder sessionKeyDerivationMode(SessionKeyDerivationMode sessionKeyDerivationMode);

        /**
         * <p>
         * Parameters that are required to generate session key for EMV generation and verification.
         * </p>
         * 
         * @param sessionKeyDerivationValue
         *        Parameters that are required to generate session key for EMV generation and verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionKeyDerivationValue(SessionKeyDerivationValue sessionKeyDerivationValue);

        /**
         * <p>
         * Parameters that are required to generate session key for EMV generation and verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyDerivationValue.Builder}
         * avoiding the need to create one manually via {@link SessionKeyDerivationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyDerivationValue.Builder#build()} is called immediately
         * and its result is passed to {@link #sessionKeyDerivationValue(SessionKeyDerivationValue)}.
         * 
         * @param sessionKeyDerivationValue
         *        a consumer that will call methods on {@link SessionKeyDerivationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionKeyDerivationValue(SessionKeyDerivationValue)
         */
        default Builder sessionKeyDerivationValue(Consumer<SessionKeyDerivationValue.Builder> sessionKeyDerivationValue) {
            return sessionKeyDerivationValue(SessionKeyDerivationValue.builder().applyMutation(sessionKeyDerivationValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String majorKeyDerivationMode;

        private String panSequenceNumber;

        private String primaryAccountNumber;

        private String sessionKeyDerivationMode;

        private SessionKeyDerivationValue sessionKeyDerivationValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MacAlgorithmEmv model) {
            majorKeyDerivationMode(model.majorKeyDerivationMode);
            panSequenceNumber(model.panSequenceNumber);
            primaryAccountNumber(model.primaryAccountNumber);
            sessionKeyDerivationMode(model.sessionKeyDerivationMode);
            sessionKeyDerivationValue(model.sessionKeyDerivationValue);
        }

        public final String getMajorKeyDerivationMode() {
            return majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getSessionKeyDerivationMode() {
            return sessionKeyDerivationMode;
        }

        public final void setSessionKeyDerivationMode(String sessionKeyDerivationMode) {
            this.sessionKeyDerivationMode = sessionKeyDerivationMode;
        }

        @Override
        public final Builder sessionKeyDerivationMode(String sessionKeyDerivationMode) {
            this.sessionKeyDerivationMode = sessionKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder sessionKeyDerivationMode(SessionKeyDerivationMode sessionKeyDerivationMode) {
            this.sessionKeyDerivationMode(sessionKeyDerivationMode == null ? null : sessionKeyDerivationMode.toString());
            return this;
        }

        public final SessionKeyDerivationValue.Builder getSessionKeyDerivationValue() {
            return sessionKeyDerivationValue != null ? sessionKeyDerivationValue.toBuilder() : null;
        }

        public final void setSessionKeyDerivationValue(SessionKeyDerivationValue.BuilderImpl sessionKeyDerivationValue) {
            this.sessionKeyDerivationValue = sessionKeyDerivationValue != null ? sessionKeyDerivationValue.build() : null;
        }

        @Override
        public final Builder sessionKeyDerivationValue(SessionKeyDerivationValue sessionKeyDerivationValue) {
            this.sessionKeyDerivationValue = sessionKeyDerivationValue;
            return this;
        }

        @Override
        public MacAlgorithmEmv build() {
            return new MacAlgorithmEmv(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
