/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to generate or verify Ibm3624 PIN verification PIN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ibm3624PinVerification implements SdkPojo, Serializable,
        ToCopyableBuilder<Ibm3624PinVerification.Builder, Ibm3624PinVerification> {
    private static final SdkField<String> DECIMALIZATION_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DecimalizationTable").getter(getter(Ibm3624PinVerification::decimalizationTable))
            .setter(setter(Builder::decimalizationTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalizationTable").build())
            .build();

    private static final SdkField<String> PIN_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinOffset").getter(getter(Ibm3624PinVerification::pinOffset)).setter(setter(Builder::pinOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinOffset").build()).build();

    private static final SdkField<String> PIN_VALIDATION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinValidationData").getter(getter(Ibm3624PinVerification::pinValidationData))
            .setter(setter(Builder::pinValidationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinValidationData").build()).build();

    private static final SdkField<String> PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PinValidationDataPadCharacter")
            .getter(getter(Ibm3624PinVerification::pinValidationDataPadCharacter))
            .setter(setter(Builder::pinValidationDataPadCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinValidationDataPadCharacter")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECIMALIZATION_TABLE_FIELD,
            PIN_OFFSET_FIELD, PIN_VALIDATION_DATA_FIELD, PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String decimalizationTable;

    private final String pinOffset;

    private final String pinValidationData;

    private final String pinValidationDataPadCharacter;

    private Ibm3624PinVerification(BuilderImpl builder) {
        this.decimalizationTable = builder.decimalizationTable;
        this.pinOffset = builder.pinOffset;
        this.pinValidationData = builder.pinValidationData;
        this.pinValidationDataPadCharacter = builder.pinValidationDataPadCharacter;
    }

    /**
     * <p>
     * The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
     * intermediate result from hexadecimal characters to decimal.
     * </p>
     * 
     * @return The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
     *         intermediate result from hexadecimal characters to decimal.
     */
    public final String decimalizationTable() {
        return decimalizationTable;
    }

    /**
     * <p>
     * The PIN offset value.
     * </p>
     * 
     * @return The PIN offset value.
     */
    public final String pinOffset() {
        return pinOffset;
    }

    /**
     * <p>
     * The unique data for cardholder identification.
     * </p>
     * 
     * @return The unique data for cardholder identification.
     */
    public final String pinValidationData() {
        return pinValidationData;
    }

    /**
     * <p>
     * The padding character for validation data.
     * </p>
     * 
     * @return The padding character for validation data.
     */
    public final String pinValidationDataPadCharacter() {
        return pinValidationDataPadCharacter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decimalizationTable());
        hashCode = 31 * hashCode + Objects.hashCode(pinOffset());
        hashCode = 31 * hashCode + Objects.hashCode(pinValidationData());
        hashCode = 31 * hashCode + Objects.hashCode(pinValidationDataPadCharacter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ibm3624PinVerification)) {
            return false;
        }
        Ibm3624PinVerification other = (Ibm3624PinVerification) obj;
        return Objects.equals(decimalizationTable(), other.decimalizationTable())
                && Objects.equals(pinOffset(), other.pinOffset())
                && Objects.equals(pinValidationData(), other.pinValidationData())
                && Objects.equals(pinValidationDataPadCharacter(), other.pinValidationDataPadCharacter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ibm3624PinVerification").add("DecimalizationTable", decimalizationTable())
                .add("PinOffset", pinOffset()).add("PinValidationData", pinValidationData())
                .add("PinValidationDataPadCharacter", pinValidationDataPadCharacter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecimalizationTable":
            return Optional.ofNullable(clazz.cast(decimalizationTable()));
        case "PinOffset":
            return Optional.ofNullable(clazz.cast(pinOffset()));
        case "PinValidationData":
            return Optional.ofNullable(clazz.cast(pinValidationData()));
        case "PinValidationDataPadCharacter":
            return Optional.ofNullable(clazz.cast(pinValidationDataPadCharacter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ibm3624PinVerification, T> g) {
        return obj -> g.apply((Ibm3624PinVerification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ibm3624PinVerification> {
        /**
         * <p>
         * The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
         * intermediate result from hexadecimal characters to decimal.
         * </p>
         * 
         * @param decimalizationTable
         *        The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
         *        intermediate result from hexadecimal characters to decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalizationTable(String decimalizationTable);

        /**
         * <p>
         * The PIN offset value.
         * </p>
         * 
         * @param pinOffset
         *        The PIN offset value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinOffset(String pinOffset);

        /**
         * <p>
         * The unique data for cardholder identification.
         * </p>
         * 
         * @param pinValidationData
         *        The unique data for cardholder identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinValidationData(String pinValidationData);

        /**
         * <p>
         * The padding character for validation data.
         * </p>
         * 
         * @param pinValidationDataPadCharacter
         *        The padding character for validation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinValidationDataPadCharacter(String pinValidationDataPadCharacter);
    }

    static final class BuilderImpl implements Builder {
        private String decimalizationTable;

        private String pinOffset;

        private String pinValidationData;

        private String pinValidationDataPadCharacter;

        private BuilderImpl() {
        }

        private BuilderImpl(Ibm3624PinVerification model) {
            decimalizationTable(model.decimalizationTable);
            pinOffset(model.pinOffset);
            pinValidationData(model.pinValidationData);
            pinValidationDataPadCharacter(model.pinValidationDataPadCharacter);
        }

        public final String getDecimalizationTable() {
            return decimalizationTable;
        }

        public final void setDecimalizationTable(String decimalizationTable) {
            this.decimalizationTable = decimalizationTable;
        }

        @Override
        public final Builder decimalizationTable(String decimalizationTable) {
            this.decimalizationTable = decimalizationTable;
            return this;
        }

        public final String getPinOffset() {
            return pinOffset;
        }

        public final void setPinOffset(String pinOffset) {
            this.pinOffset = pinOffset;
        }

        @Override
        public final Builder pinOffset(String pinOffset) {
            this.pinOffset = pinOffset;
            return this;
        }

        public final String getPinValidationData() {
            return pinValidationData;
        }

        public final void setPinValidationData(String pinValidationData) {
            this.pinValidationData = pinValidationData;
        }

        @Override
        public final Builder pinValidationData(String pinValidationData) {
            this.pinValidationData = pinValidationData;
            return this;
        }

        public final String getPinValidationDataPadCharacter() {
            return pinValidationDataPadCharacter;
        }

        public final void setPinValidationDataPadCharacter(String pinValidationDataPadCharacter) {
            this.pinValidationDataPadCharacter = pinValidationDataPadCharacter;
        }

        @Override
        public final Builder pinValidationDataPadCharacter(String pinValidationDataPadCharacter) {
            this.pinValidationDataPadCharacter = pinValidationDataPadCharacter;
            return this;
        }

        @Override
        public Ibm3624PinVerification build() {
            return new Ibm3624PinVerification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
