/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to generate or verify Dynamic Card Verification Value (dCVV).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicCardVerificationCode implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicCardVerificationCode.Builder, DynamicCardVerificationCode> {
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationTransactionCounter")
            .getter(getter(DynamicCardVerificationCode::applicationTransactionCounter))
            .setter(setter(Builder::applicationTransactionCounter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter")
                    .build()).build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(DynamicCardVerificationCode::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> TRACK_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackData").getter(getter(DynamicCardVerificationCode::trackData)).setter(setter(Builder::trackData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackData").build()).build();

    private static final SdkField<String> UNPREDICTABLE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpredictableNumber").getter(getter(DynamicCardVerificationCode::unpredictableNumber))
            .setter(setter(Builder::unpredictableNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpredictableNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_TRANSACTION_COUNTER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, TRACK_DATA_FIELD, UNPREDICTABLE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationTransactionCounter;

    private final String panSequenceNumber;

    private final String trackData;

    private final String unpredictableNumber;

    private DynamicCardVerificationCode(BuilderImpl builder) {
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.trackData = builder.trackData;
        this.unpredictableNumber = builder.unpredictableNumber;
    }

    /**
     * <p>
     * The transaction counter value that comes from the terminal.
     * </p>
     * 
     * @return The transaction counter value that comes from the terminal.
     */
    public final String applicationTransactionCounter() {
        return applicationTransactionCounter;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder name,
     * PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the data
     * received.
     * </p>
     * 
     * @return The data on the two tracks of magnetic cards used for financial transactions. This includes the
     *         cardholder name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to
     *         validate the data received.
     */
    public final String trackData() {
        return trackData;
    }

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     * 
     * @return A random number generated by the issuer.
     */
    public final String unpredictableNumber() {
        return unpredictableNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationTransactionCounter());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(trackData());
        hashCode = 31 * hashCode + Objects.hashCode(unpredictableNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicCardVerificationCode)) {
            return false;
        }
        DynamicCardVerificationCode other = (DynamicCardVerificationCode) obj;
        return Objects.equals(applicationTransactionCounter(), other.applicationTransactionCounter())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(trackData(), other.trackData())
                && Objects.equals(unpredictableNumber(), other.unpredictableNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicCardVerificationCode")
                .add("ApplicationTransactionCounter", applicationTransactionCounter())
                .add("PanSequenceNumber", panSequenceNumber()).add("TrackData", trackData())
                .add("UnpredictableNumber", unpredictableNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationTransactionCounter":
            return Optional.ofNullable(clazz.cast(applicationTransactionCounter()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "TrackData":
            return Optional.ofNullable(clazz.cast(trackData()));
        case "UnpredictableNumber":
            return Optional.ofNullable(clazz.cast(unpredictableNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicCardVerificationCode, T> g) {
        return obj -> g.apply((DynamicCardVerificationCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicCardVerificationCode> {
        /**
         * <p>
         * The transaction counter value that comes from the terminal.
         * </p>
         * 
         * @param applicationTransactionCounter
         *        The transaction counter value that comes from the terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTransactionCounter(String applicationTransactionCounter);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * The data on the two tracks of magnetic cards used for financial transactions. This includes the cardholder
         * name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses to validate the
         * data received.
         * </p>
         * 
         * @param trackData
         *        The data on the two tracks of magnetic cards used for financial transactions. This includes the
         *        cardholder name, PAN, expiration date, bank ID (BIN) and several other numbers the issuing bank uses
         *        to validate the data received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackData(String trackData);

        /**
         * <p>
         * A random number generated by the issuer.
         * </p>
         * 
         * @param unpredictableNumber
         *        A random number generated by the issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpredictableNumber(String unpredictableNumber);
    }

    static final class BuilderImpl implements Builder {
        private String applicationTransactionCounter;

        private String panSequenceNumber;

        private String trackData;

        private String unpredictableNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicCardVerificationCode model) {
            applicationTransactionCounter(model.applicationTransactionCounter);
            panSequenceNumber(model.panSequenceNumber);
            trackData(model.trackData);
            unpredictableNumber(model.unpredictableNumber);
        }

        public final String getApplicationTransactionCounter() {
            return applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getTrackData() {
            return trackData;
        }

        public final void setTrackData(String trackData) {
            this.trackData = trackData;
        }

        @Override
        public final Builder trackData(String trackData) {
            this.trackData = trackData;
            return this;
        }

        public final String getUnpredictableNumber() {
            return unpredictableNumber;
        }

        public final void setUnpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
        }

        @Override
        public final Builder unpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
            return this;
        }

        @Override
        public DynamicCardVerificationCode build() {
            return new DynamicCardVerificationCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
