/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.CertificateSubjectType;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.SigningAlgorithmType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCertificateSigningRequestRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, GetCertificateSigningRequestRequest> {
    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyIdentifier").getter(GetCertificateSigningRequestRequest.getter(GetCertificateSigningRequestRequest::keyIdentifier)).setter(GetCertificateSigningRequestRequest.setter(Builder::keyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(GetCertificateSigningRequestRequest.getter(GetCertificateSigningRequestRequest::signingAlgorithmAsString)).setter(GetCertificateSigningRequestRequest.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<CertificateSubjectType> CERTIFICATE_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateSubject").getter(GetCertificateSigningRequestRequest.getter(GetCertificateSigningRequestRequest::certificateSubject)).setter(GetCertificateSigningRequestRequest.setter(Builder::certificateSubject)).constructor(CertificateSubjectType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSubject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_IDENTIFIER_FIELD, SIGNING_ALGORITHM_FIELD, CERTIFICATE_SUBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCertificateSigningRequestRequest.memberNameToFieldInitializer();
    private final String keyIdentifier;
    private final String signingAlgorithm;
    private final CertificateSubjectType certificateSubject;

    private GetCertificateSigningRequestRequest(BuilderImpl builder) {
        super(builder);
        this.keyIdentifier = builder.keyIdentifier;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.certificateSubject = builder.certificateSubject;
    }

    public final String keyIdentifier() {
        return this.keyIdentifier;
    }

    public final SigningAlgorithmType signingAlgorithm() {
        return SigningAlgorithmType.fromValue(this.signingAlgorithm);
    }

    public final String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public final CertificateSubjectType certificateSubject() {
        return this.certificateSubject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSubject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificateSigningRequestRequest)) {
            return false;
        }
        GetCertificateSigningRequestRequest other = (GetCertificateSigningRequestRequest)((Object)obj);
        return Objects.equals(this.keyIdentifier(), other.keyIdentifier()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString()) && Objects.equals(this.certificateSubject(), other.certificateSubject());
    }

    public final String toString() {
        return ToString.builder((String)"GetCertificateSigningRequestRequest").add("KeyIdentifier", (Object)this.keyIdentifier()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).add("CertificateSubject", (Object)this.certificateSubject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.keyIdentifier()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
            case "CertificateSubject": {
                return Optional.ofNullable(clazz.cast(this.certificateSubject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyIdentifier", KEY_IDENTIFIER_FIELD);
        map.put("SigningAlgorithm", SIGNING_ALGORITHM_FIELD);
        map.put("CertificateSubject", CERTIFICATE_SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCertificateSigningRequestRequest, T> g) {
        return obj -> g.apply((GetCertificateSigningRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private String keyIdentifier;
        private String signingAlgorithm;
        private CertificateSubjectType certificateSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificateSigningRequestRequest model) {
            super(model);
            this.keyIdentifier(model.keyIdentifier);
            this.signingAlgorithm(model.signingAlgorithm);
            this.certificateSubject(model.certificateSubject);
        }

        public final String getKeyIdentifier() {
            return this.keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithmType signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final CertificateSubjectType.Builder getCertificateSubject() {
            return this.certificateSubject != null ? this.certificateSubject.toBuilder() : null;
        }

        public final void setCertificateSubject(CertificateSubjectType.BuilderImpl certificateSubject) {
            this.certificateSubject = certificateSubject != null ? certificateSubject.build() : null;
        }

        @Override
        public final Builder certificateSubject(CertificateSubjectType certificateSubject) {
            this.certificateSubject = certificateSubject;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCertificateSigningRequestRequest build() {
            return new GetCertificateSigningRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCertificateSigningRequestRequest> {
        public Builder keyIdentifier(String var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithmType var1);

        public Builder certificateSubject(CertificateSubjectType var1);

        default public Builder certificateSubject(Consumer<CertificateSubjectType.Builder> certificateSubject) {
            return this.certificateSubject((CertificateSubjectType)((CertificateSubjectType.Builder)CertificateSubjectType.builder().applyMutation(certificateSubject)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

