/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiffieHellmanDerivationData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiffieHellmanDerivationData> {
    private static final SdkField<String> SHARED_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedInformation").getter(DiffieHellmanDerivationData.getter(DiffieHellmanDerivationData::sharedInformation)).setter(DiffieHellmanDerivationData.setter(Builder::sharedInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_INFORMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DiffieHellmanDerivationData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sharedInformation;
    private final Type type;

    private DiffieHellmanDerivationData(BuilderImpl builder) {
        this.sharedInformation = builder.sharedInformation;
        this.type = builder.type;
    }

    public final String sharedInformation() {
        return this.sharedInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedInformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiffieHellmanDerivationData)) {
            return false;
        }
        DiffieHellmanDerivationData other = (DiffieHellmanDerivationData)obj;
        return Objects.equals(this.sharedInformation(), other.sharedInformation());
    }

    public final String toString() {
        return ToString.builder((String)"DiffieHellmanDerivationData").add("SharedInformation", (Object)this.sharedInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SharedInformation": {
                return Optional.ofNullable(clazz.cast(this.sharedInformation()));
            }
        }
        return Optional.empty();
    }

    public static DiffieHellmanDerivationData fromSharedInformation(String sharedInformation) {
        return (DiffieHellmanDerivationData)DiffieHellmanDerivationData.builder().sharedInformation(sharedInformation).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SharedInformation", SHARED_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiffieHellmanDerivationData, T> g) {
        return obj -> g.apply((DiffieHellmanDerivationData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SHARED_INFORMATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String sharedInformation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DiffieHellmanDerivationData model) {
            this.sharedInformation(model.sharedInformation);
        }

        public final String getSharedInformation() {
            return this.sharedInformation;
        }

        public final void setSharedInformation(String sharedInformation) {
            String oldValue = this.sharedInformation;
            this.sharedInformation = sharedInformation;
            this.handleUnionValueChange(Type.SHARED_INFORMATION, oldValue, this.sharedInformation);
        }

        @Override
        public final Builder sharedInformation(String sharedInformation) {
            String oldValue = this.sharedInformation;
            this.sharedInformation = sharedInformation;
            this.handleUnionValueChange(Type.SHARED_INFORMATION, oldValue, this.sharedInformation);
            return this;
        }

        public DiffieHellmanDerivationData build() {
            return new DiffieHellmanDerivationData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiffieHellmanDerivationData> {
        public Builder sharedInformation(String var1);
    }
}

