/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes for IPEK generation during export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportAttributes.Builder, ExportAttributes> {
    private static final SdkField<ExportDukptInitialKey> EXPORT_DUKPT_INITIAL_KEY_FIELD = SdkField
            .<ExportDukptInitialKey> builder(MarshallingType.SDK_POJO).memberName("ExportDukptInitialKey")
            .getter(getter(ExportAttributes::exportDukptInitialKey)).setter(setter(Builder::exportDukptInitialKey))
            .constructor(ExportDukptInitialKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDukptInitialKey").build())
            .build();

    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCheckValueAlgorithm").getter(getter(ExportAttributes::keyCheckValueAlgorithmAsString))
            .setter(setter(Builder::keyCheckValueAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPORT_DUKPT_INITIAL_KEY_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExportDukptInitialKey exportDukptInitialKey;

    private final String keyCheckValueAlgorithm;

    private ExportAttributes(BuilderImpl builder) {
        this.exportDukptInitialKey = builder.exportDukptInitialKey;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
    }

    /**
     * <p>
     * Parameter information for IPEK export.
     * </p>
     * 
     * @return Parameter information for IPEK export.
     */
    public final ExportDukptInitialKey exportDukptInitialKey() {
        return exportDukptInitialKey;
    }

    /**
     * <p>
     * The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is
     * used to validate the key integrity. Specify KCV for IPEK export only.
     * </p>
     * <p>
     * For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and
     * retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC
     * algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted
     * result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyCheckValueAlgorithm} will return {@link KeyCheckValueAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyCheckValueAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV).
     *         It is used to validate the key integrity. Specify KCV for IPEK export only.</p>
     *         <p>
     *         For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be
     *         checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is
     *         computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest
     *         order bytes of the encrypted result.
     * @see KeyCheckValueAlgorithm
     */
    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(keyCheckValueAlgorithm);
    }

    /**
     * <p>
     * The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It is
     * used to validate the key integrity. Specify KCV for IPEK export only.
     * </p>
     * <p>
     * For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and
     * retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC
     * algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted
     * result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyCheckValueAlgorithm} will return {@link KeyCheckValueAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyCheckValueAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV).
     *         It is used to validate the key integrity. Specify KCV for IPEK export only.</p>
     *         <p>
     *         For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be
     *         checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is
     *         computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest
     *         order bytes of the encrypted result.
     * @see KeyCheckValueAlgorithm
     */
    public final String keyCheckValueAlgorithmAsString() {
        return keyCheckValueAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportDukptInitialKey());
        hashCode = 31 * hashCode + Objects.hashCode(keyCheckValueAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAttributes)) {
            return false;
        }
        ExportAttributes other = (ExportAttributes) obj;
        return Objects.equals(exportDukptInitialKey(), other.exportDukptInitialKey())
                && Objects.equals(keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportAttributes").add("ExportDukptInitialKey", exportDukptInitialKey())
                .add("KeyCheckValueAlgorithm", keyCheckValueAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportDukptInitialKey":
            return Optional.ofNullable(clazz.cast(exportDukptInitialKey()));
        case "KeyCheckValueAlgorithm":
            return Optional.ofNullable(clazz.cast(keyCheckValueAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportDukptInitialKey", EXPORT_DUKPT_INITIAL_KEY_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportAttributes, T> g) {
        return obj -> g.apply((ExportAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportAttributes> {
        /**
         * <p>
         * Parameter information for IPEK export.
         * </p>
         * 
         * @param exportDukptInitialKey
         *        Parameter information for IPEK export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDukptInitialKey(ExportDukptInitialKey exportDukptInitialKey);

        /**
         * <p>
         * Parameter information for IPEK export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDukptInitialKey.Builder} avoiding
         * the need to create one manually via {@link ExportDukptInitialKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDukptInitialKey.Builder#build()} is called immediately and
         * its result is passed to {@link #exportDukptInitialKey(ExportDukptInitialKey)}.
         * 
         * @param exportDukptInitialKey
         *        a consumer that will call methods on {@link ExportDukptInitialKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDukptInitialKey(ExportDukptInitialKey)
         */
        default Builder exportDukptInitialKey(Consumer<ExportDukptInitialKey.Builder> exportDukptInitialKey) {
            return exportDukptInitialKey(ExportDukptInitialKey.builder().applyMutation(exportDukptInitialKey).build());
        }

        /**
         * <p>
         * The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It
         * is used to validate the key integrity. Specify KCV for IPEK export only.
         * </p>
         * <p>
         * For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked
         * and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a
         * CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the
         * encrypted result.
         * </p>
         * 
         * @param keyCheckValueAlgorithm
         *        The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value
         *        (KCV). It is used to validate the key integrity. Specify KCV for IPEK export only.</p>
         *        <p>
         *        For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be
         *        checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is
         *        computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest
         *        order bytes of the encrypted result.
         * @see KeyCheckValueAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyCheckValueAlgorithm
         */
        Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm);

        /**
         * <p>
         * The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value (KCV). It
         * is used to validate the key integrity. Specify KCV for IPEK export only.
         * </p>
         * <p>
         * For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked
         * and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a
         * CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the
         * encrypted result.
         * </p>
         * 
         * @param keyCheckValueAlgorithm
         *        The algorithm that Amazon Web Services Payment Cryptography uses to calculate the key check value
         *        (KCV). It is used to validate the key integrity. Specify KCV for IPEK export only.</p>
         *        <p>
         *        For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be
         *        checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is
         *        computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest
         *        order bytes of the encrypted result.
         * @see KeyCheckValueAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyCheckValueAlgorithm
         */
        Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm);
    }

    static final class BuilderImpl implements Builder {
        private ExportDukptInitialKey exportDukptInitialKey;

        private String keyCheckValueAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAttributes model) {
            exportDukptInitialKey(model.exportDukptInitialKey);
            keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
        }

        public final ExportDukptInitialKey.Builder getExportDukptInitialKey() {
            return exportDukptInitialKey != null ? exportDukptInitialKey.toBuilder() : null;
        }

        public final void setExportDukptInitialKey(ExportDukptInitialKey.BuilderImpl exportDukptInitialKey) {
            this.exportDukptInitialKey = exportDukptInitialKey != null ? exportDukptInitialKey.build() : null;
        }

        @Override
        public final Builder exportDukptInitialKey(ExportDukptInitialKey exportDukptInitialKey) {
            this.exportDukptInitialKey = exportDukptInitialKey;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        @Override
        public ExportAttributes build() {
            return new ExportAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
