/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyCheckValueAlgorithm {
    CMAC("CMAC"),
    ANSI_X9_24("ANSI_X9_24"),
    HMAC("HMAC"),
    SHA_1("SHA_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyCheckValueAlgorithm> VALUE_MAP;
    private final String value;

    private KeyCheckValueAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyCheckValueAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyCheckValueAlgorithm> knownValues() {
        EnumSet<KeyCheckValueAlgorithm> knownValues = EnumSet.allOf(KeyCheckValueAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyCheckValueAlgorithm.class, KeyCheckValueAlgorithm::toString);
    }
}

