/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.DiffieHellmanDerivationData;
import software.amazon.awssdk.services.paymentcryptography.model.KeyBlockHeaders;
import software.amazon.awssdk.services.paymentcryptography.model.KeyDerivationFunction;
import software.amazon.awssdk.services.paymentcryptography.model.KeyDerivationHashAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.SymmetricKeyAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportDiffieHellmanTr31KeyBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportDiffieHellmanTr31KeyBlock> {
    private static final SdkField<String> PRIVATE_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateKeyIdentifier").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::privateKeyIdentifier)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::privateKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyIdentifier").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::certificateAuthorityPublicKeyIdentifier)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKeyCertificate").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::publicKeyCertificate)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::publicKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build()}).build();
    private static final SdkField<String> DERIVE_KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeriveKeyAlgorithm").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::deriveKeyAlgorithmAsString)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::deriveKeyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeriveKeyAlgorithm").build()}).build();
    private static final SdkField<String> KEY_DERIVATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyDerivationFunction").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::keyDerivationFunctionAsString)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::keyDerivationFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationFunction").build()}).build();
    private static final SdkField<String> KEY_DERIVATION_HASH_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyDerivationHashAlgorithm").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::keyDerivationHashAlgorithmAsString)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::keyDerivationHashAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationHashAlgorithm").build()}).build();
    private static final SdkField<DiffieHellmanDerivationData> DERIVATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DerivationData").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::derivationData)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::derivationData)).constructor(DiffieHellmanDerivationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DerivationData").build()}).build();
    private static final SdkField<KeyBlockHeaders> KEY_BLOCK_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyBlockHeaders").getter(ExportDiffieHellmanTr31KeyBlock.getter(ExportDiffieHellmanTr31KeyBlock::keyBlockHeaders)).setter(ExportDiffieHellmanTr31KeyBlock.setter(Builder::keyBlockHeaders)).constructor(KeyBlockHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockHeaders").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_KEY_IDENTIFIER_FIELD, CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, PUBLIC_KEY_CERTIFICATE_FIELD, DERIVE_KEY_ALGORITHM_FIELD, KEY_DERIVATION_FUNCTION_FIELD, KEY_DERIVATION_HASH_ALGORITHM_FIELD, DERIVATION_DATA_FIELD, KEY_BLOCK_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportDiffieHellmanTr31KeyBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String privateKeyIdentifier;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final String publicKeyCertificate;
    private final String deriveKeyAlgorithm;
    private final String keyDerivationFunction;
    private final String keyDerivationHashAlgorithm;
    private final DiffieHellmanDerivationData derivationData;
    private final KeyBlockHeaders keyBlockHeaders;

    private ExportDiffieHellmanTr31KeyBlock(BuilderImpl builder) {
        this.privateKeyIdentifier = builder.privateKeyIdentifier;
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.publicKeyCertificate = builder.publicKeyCertificate;
        this.deriveKeyAlgorithm = builder.deriveKeyAlgorithm;
        this.keyDerivationFunction = builder.keyDerivationFunction;
        this.keyDerivationHashAlgorithm = builder.keyDerivationHashAlgorithm;
        this.derivationData = builder.derivationData;
        this.keyBlockHeaders = builder.keyBlockHeaders;
    }

    public final String privateKeyIdentifier() {
        return this.privateKeyIdentifier;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final String publicKeyCertificate() {
        return this.publicKeyCertificate;
    }

    public final SymmetricKeyAlgorithm deriveKeyAlgorithm() {
        return SymmetricKeyAlgorithm.fromValue(this.deriveKeyAlgorithm);
    }

    public final String deriveKeyAlgorithmAsString() {
        return this.deriveKeyAlgorithm;
    }

    public final KeyDerivationFunction keyDerivationFunction() {
        return KeyDerivationFunction.fromValue(this.keyDerivationFunction);
    }

    public final String keyDerivationFunctionAsString() {
        return this.keyDerivationFunction;
    }

    public final KeyDerivationHashAlgorithm keyDerivationHashAlgorithm() {
        return KeyDerivationHashAlgorithm.fromValue(this.keyDerivationHashAlgorithm);
    }

    public final String keyDerivationHashAlgorithmAsString() {
        return this.keyDerivationHashAlgorithm;
    }

    public final DiffieHellmanDerivationData derivationData() {
        return this.derivationData;
    }

    public final KeyBlockHeaders keyBlockHeaders() {
        return this.keyBlockHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deriveKeyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyDerivationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyDerivationHashAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.derivationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyBlockHeaders());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDiffieHellmanTr31KeyBlock)) {
            return false;
        }
        ExportDiffieHellmanTr31KeyBlock other = (ExportDiffieHellmanTr31KeyBlock)obj;
        return Objects.equals(this.privateKeyIdentifier(), other.privateKeyIdentifier()) && Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.publicKeyCertificate(), other.publicKeyCertificate()) && Objects.equals(this.deriveKeyAlgorithmAsString(), other.deriveKeyAlgorithmAsString()) && Objects.equals(this.keyDerivationFunctionAsString(), other.keyDerivationFunctionAsString()) && Objects.equals(this.keyDerivationHashAlgorithmAsString(), other.keyDerivationHashAlgorithmAsString()) && Objects.equals(this.derivationData(), other.derivationData()) && Objects.equals(this.keyBlockHeaders(), other.keyBlockHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"ExportDiffieHellmanTr31KeyBlock").add("PrivateKeyIdentifier", (Object)this.privateKeyIdentifier()).add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("PublicKeyCertificate", (Object)(this.publicKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).add("DeriveKeyAlgorithm", (Object)this.deriveKeyAlgorithmAsString()).add("KeyDerivationFunction", (Object)this.keyDerivationFunctionAsString()).add("KeyDerivationHashAlgorithm", (Object)this.keyDerivationHashAlgorithmAsString()).add("DerivationData", (Object)this.derivationData()).add("KeyBlockHeaders", (Object)this.keyBlockHeaders()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrivateKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.privateKeyIdentifier()));
            }
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "PublicKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.publicKeyCertificate()));
            }
            case "DeriveKeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.deriveKeyAlgorithmAsString()));
            }
            case "KeyDerivationFunction": {
                return Optional.ofNullable(clazz.cast(this.keyDerivationFunctionAsString()));
            }
            case "KeyDerivationHashAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyDerivationHashAlgorithmAsString()));
            }
            case "DerivationData": {
                return Optional.ofNullable(clazz.cast(this.derivationData()));
            }
            case "KeyBlockHeaders": {
                return Optional.ofNullable(clazz.cast(this.keyBlockHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrivateKeyIdentifier", PRIVATE_KEY_IDENTIFIER_FIELD);
        map.put("CertificateAuthorityPublicKeyIdentifier", CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD);
        map.put("PublicKeyCertificate", PUBLIC_KEY_CERTIFICATE_FIELD);
        map.put("DeriveKeyAlgorithm", DERIVE_KEY_ALGORITHM_FIELD);
        map.put("KeyDerivationFunction", KEY_DERIVATION_FUNCTION_FIELD);
        map.put("KeyDerivationHashAlgorithm", KEY_DERIVATION_HASH_ALGORITHM_FIELD);
        map.put("DerivationData", DERIVATION_DATA_FIELD);
        map.put("KeyBlockHeaders", KEY_BLOCK_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportDiffieHellmanTr31KeyBlock, T> g) {
        return obj -> g.apply((ExportDiffieHellmanTr31KeyBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String privateKeyIdentifier;
        private String certificateAuthorityPublicKeyIdentifier;
        private String publicKeyCertificate;
        private String deriveKeyAlgorithm;
        private String keyDerivationFunction;
        private String keyDerivationHashAlgorithm;
        private DiffieHellmanDerivationData derivationData;
        private KeyBlockHeaders keyBlockHeaders;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDiffieHellmanTr31KeyBlock model) {
            this.privateKeyIdentifier(model.privateKeyIdentifier);
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.publicKeyCertificate(model.publicKeyCertificate);
            this.deriveKeyAlgorithm(model.deriveKeyAlgorithm);
            this.keyDerivationFunction(model.keyDerivationFunction);
            this.keyDerivationHashAlgorithm(model.keyDerivationHashAlgorithm);
            this.derivationData(model.derivationData);
            this.keyBlockHeaders(model.keyBlockHeaders);
        }

        public final String getPrivateKeyIdentifier() {
            return this.privateKeyIdentifier;
        }

        public final void setPrivateKeyIdentifier(String privateKeyIdentifier) {
            this.privateKeyIdentifier = privateKeyIdentifier;
        }

        @Override
        public final Builder privateKeyIdentifier(String privateKeyIdentifier) {
            this.privateKeyIdentifier = privateKeyIdentifier;
            return this;
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return this.publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        public final String getDeriveKeyAlgorithm() {
            return this.deriveKeyAlgorithm;
        }

        public final void setDeriveKeyAlgorithm(String deriveKeyAlgorithm) {
            this.deriveKeyAlgorithm = deriveKeyAlgorithm;
        }

        @Override
        public final Builder deriveKeyAlgorithm(String deriveKeyAlgorithm) {
            this.deriveKeyAlgorithm = deriveKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder deriveKeyAlgorithm(SymmetricKeyAlgorithm deriveKeyAlgorithm) {
            this.deriveKeyAlgorithm(deriveKeyAlgorithm == null ? null : deriveKeyAlgorithm.toString());
            return this;
        }

        public final String getKeyDerivationFunction() {
            return this.keyDerivationFunction;
        }

        public final void setKeyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
        }

        @Override
        public final Builder keyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
            return this;
        }

        @Override
        public final Builder keyDerivationFunction(KeyDerivationFunction keyDerivationFunction) {
            this.keyDerivationFunction(keyDerivationFunction == null ? null : keyDerivationFunction.toString());
            return this;
        }

        public final String getKeyDerivationHashAlgorithm() {
            return this.keyDerivationHashAlgorithm;
        }

        public final void setKeyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
            return this;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm(keyDerivationHashAlgorithm == null ? null : keyDerivationHashAlgorithm.toString());
            return this;
        }

        public final DiffieHellmanDerivationData.Builder getDerivationData() {
            return this.derivationData != null ? this.derivationData.toBuilder() : null;
        }

        public final void setDerivationData(DiffieHellmanDerivationData.BuilderImpl derivationData) {
            this.derivationData = derivationData != null ? derivationData.build() : null;
        }

        @Override
        public final Builder derivationData(DiffieHellmanDerivationData derivationData) {
            this.derivationData = derivationData;
            return this;
        }

        public final KeyBlockHeaders.Builder getKeyBlockHeaders() {
            return this.keyBlockHeaders != null ? this.keyBlockHeaders.toBuilder() : null;
        }

        public final void setKeyBlockHeaders(KeyBlockHeaders.BuilderImpl keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders != null ? keyBlockHeaders.build() : null;
        }

        @Override
        public final Builder keyBlockHeaders(KeyBlockHeaders keyBlockHeaders) {
            this.keyBlockHeaders = keyBlockHeaders;
            return this;
        }

        public ExportDiffieHellmanTr31KeyBlock build() {
            return new ExportDiffieHellmanTr31KeyBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportDiffieHellmanTr31KeyBlock> {
        public Builder privateKeyIdentifier(String var1);

        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder publicKeyCertificate(String var1);

        public Builder deriveKeyAlgorithm(String var1);

        public Builder deriveKeyAlgorithm(SymmetricKeyAlgorithm var1);

        public Builder keyDerivationFunction(String var1);

        public Builder keyDerivationFunction(KeyDerivationFunction var1);

        public Builder keyDerivationHashAlgorithm(String var1);

        public Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm var1);

        public Builder derivationData(DiffieHellmanDerivationData var1);

        default public Builder derivationData(Consumer<DiffieHellmanDerivationData.Builder> derivationData) {
            return this.derivationData((DiffieHellmanDerivationData)((DiffieHellmanDerivationData.Builder)DiffieHellmanDerivationData.builder().applyMutation(derivationData)).build());
        }

        public Builder keyBlockHeaders(KeyBlockHeaders var1);

        default public Builder keyBlockHeaders(Consumer<KeyBlockHeaders.Builder> keyBlockHeaders) {
            return this.keyBlockHeaders((KeyBlockHeaders)((KeyBlockHeaders.Builder)KeyBlockHeaders.builder().applyMutation(keyBlockHeaders)).build());
        }
    }
}

