/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyDerivationHashAlgorithm {
    SHA_256("SHA_256"),
    SHA_384("SHA_384"),
    SHA_512("SHA_512"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyDerivationHashAlgorithm> VALUE_MAP;
    private final String value;

    private KeyDerivationHashAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyDerivationHashAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyDerivationHashAlgorithm> knownValues() {
        EnumSet<KeyDerivationHashAlgorithm> knownValues = EnumSet.allOf(KeyDerivationHashAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyDerivationHashAlgorithm.class, KeyDerivationHashAlgorithm::toString);
    }
}

