/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.paymentcryptography.DefaultPaymentCryptographyClientBuilder;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyClientBuilder;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyServiceClientConfiguration;
import software.amazon.awssdk.services.paymentcryptography.model.AccessDeniedException;
import software.amazon.awssdk.services.paymentcryptography.model.ConflictException;
import software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest;
import software.amazon.awssdk.services.paymentcryptography.model.CreateAliasResponse;
import software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.CreateKeyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest;
import software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasResponse;
import software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.ExportKeyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest;
import software.amazon.awssdk.services.paymentcryptography.model.GetAliasResponse;
import software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.GetKeyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest;
import software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportResponse;
import software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest;
import software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportResponse;
import software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest;
import software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.ImportKeyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.InternalServerException;
import software.amazon.awssdk.services.paymentcryptography.model.ListAliasesRequest;
import software.amazon.awssdk.services.paymentcryptography.model.ListAliasesResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest;
import software.amazon.awssdk.services.paymentcryptography.model.ListKeysResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyException;
import software.amazon.awssdk.services.paymentcryptography.model.ResourceNotFoundException;
import software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.paymentcryptography.model.ServiceUnavailableException;
import software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest;
import software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageResponse;
import software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest;
import software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageResponse;
import software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest;
import software.amazon.awssdk.services.paymentcryptography.model.TagResourceResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ThrottlingException;
import software.amazon.awssdk.services.paymentcryptography.model.UntagResourceRequest;
import software.amazon.awssdk.services.paymentcryptography.model.UntagResourceResponse;
import software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest;
import software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasResponse;
import software.amazon.awssdk.services.paymentcryptography.model.ValidationException;
import software.amazon.awssdk.services.paymentcryptography.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.paymentcryptography.paginators.ListKeysIterable;
import software.amazon.awssdk.services.paymentcryptography.paginators.ListTagsForResourceIterable;

@SdkPublicApi
@ThreadSafe
public interface PaymentCryptographyClient
extends AwsClient {
    public static final String SERVICE_NAME = "payment-cryptography";
    public static final String SERVICE_METADATA_ID = "controlplane.payment-cryptography";

    default public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public CreateAliasResponse createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.createAlias((CreateAliasRequest)((Object)((CreateAliasRequest.Builder)CreateAliasRequest.builder().applyMutation(createAliasRequest)).build()));
    }

    default public CreateKeyResponse createKey(CreateKeyRequest createKeyRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public CreateKeyResponse createKey(Consumer<CreateKeyRequest.Builder> createKeyRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.createKey((CreateKeyRequest)((Object)((CreateKeyRequest.Builder)CreateKeyRequest.builder().applyMutation(createKeyRequest)).build()));
    }

    default public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAliasResponse deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.deleteAlias((DeleteAliasRequest)((Object)((DeleteAliasRequest.Builder)DeleteAliasRequest.builder().applyMutation(deleteAliasRequest)).build()));
    }

    default public DeleteKeyResponse deleteKey(DeleteKeyRequest deleteKeyRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public DeleteKeyResponse deleteKey(Consumer<DeleteKeyRequest.Builder> deleteKeyRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.deleteKey((DeleteKeyRequest)((Object)((DeleteKeyRequest.Builder)DeleteKeyRequest.builder().applyMutation(deleteKeyRequest)).build()));
    }

    default public ExportKeyResponse exportKey(ExportKeyRequest exportKeyRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public ExportKeyResponse exportKey(Consumer<ExportKeyRequest.Builder> exportKeyRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.exportKey((ExportKeyRequest)((Object)((ExportKeyRequest.Builder)ExportKeyRequest.builder().applyMutation(exportKeyRequest)).build()));
    }

    default public GetAliasResponse getAlias(GetAliasRequest getAliasRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public GetAliasResponse getAlias(Consumer<GetAliasRequest.Builder> getAliasRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.getAlias((GetAliasRequest)((Object)((GetAliasRequest.Builder)GetAliasRequest.builder().applyMutation(getAliasRequest)).build()));
    }

    default public GetKeyResponse getKey(GetKeyRequest getKeyRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public GetKeyResponse getKey(Consumer<GetKeyRequest.Builder> getKeyRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.getKey((GetKeyRequest)((Object)((GetKeyRequest.Builder)GetKeyRequest.builder().applyMutation(getKeyRequest)).build()));
    }

    default public GetParametersForExportResponse getParametersForExport(GetParametersForExportRequest getParametersForExportRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public GetParametersForExportResponse getParametersForExport(Consumer<GetParametersForExportRequest.Builder> getParametersForExportRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.getParametersForExport((GetParametersForExportRequest)((Object)((GetParametersForExportRequest.Builder)GetParametersForExportRequest.builder().applyMutation(getParametersForExportRequest)).build()));
    }

    default public GetParametersForImportResponse getParametersForImport(GetParametersForImportRequest getParametersForImportRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public GetParametersForImportResponse getParametersForImport(Consumer<GetParametersForImportRequest.Builder> getParametersForImportRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.getParametersForImport((GetParametersForImportRequest)((Object)((GetParametersForImportRequest.Builder)GetParametersForImportRequest.builder().applyMutation(getParametersForImportRequest)).build()));
    }

    default public GetPublicKeyCertificateResponse getPublicKeyCertificate(GetPublicKeyCertificateRequest getPublicKeyCertificateRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public GetPublicKeyCertificateResponse getPublicKeyCertificate(Consumer<GetPublicKeyCertificateRequest.Builder> getPublicKeyCertificateRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.getPublicKeyCertificate((GetPublicKeyCertificateRequest)((Object)((GetPublicKeyCertificateRequest.Builder)GetPublicKeyCertificateRequest.builder().applyMutation(getPublicKeyCertificateRequest)).build()));
    }

    default public ImportKeyResponse importKey(ImportKeyRequest importKeyRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public ImportKeyResponse importKey(Consumer<ImportKeyRequest.Builder> importKeyRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.importKey((ImportKeyRequest)((Object)((ImportKeyRequest.Builder)ImportKeyRequest.builder().applyMutation(importKeyRequest)).build()));
    }

    default public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public ListAliasesResponse listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.listAliases((ListAliasesRequest)((Object)((ListAliasesRequest.Builder)ListAliasesRequest.builder().applyMutation(listAliasesRequest)).build()));
    }

    default public ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return new ListAliasesIterable(this, listAliasesRequest);
    }

    default public ListAliasesIterable listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.listAliasesPaginator((ListAliasesRequest)((Object)((ListAliasesRequest.Builder)ListAliasesRequest.builder().applyMutation(listAliasesRequest)).build()));
    }

    default public ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public ListKeysResponse listKeys(Consumer<ListKeysRequest.Builder> listKeysRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.listKeys((ListKeysRequest)((Object)((ListKeysRequest.Builder)ListKeysRequest.builder().applyMutation(listKeysRequest)).build()));
    }

    default public ListKeysIterable listKeysPaginator(ListKeysRequest listKeysRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return new ListKeysIterable(this, listKeysRequest);
    }

    default public ListKeysIterable listKeysPaginator(Consumer<ListKeysRequest.Builder> listKeysRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.listKeysPaginator((ListKeysRequest)((Object)((ListKeysRequest.Builder)ListKeysRequest.builder().applyMutation(listKeysRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    default public ListTagsForResourceIterable listTagsForResourcePaginator(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceUnavailableException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.listTagsForResourcePaginator((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public RestoreKeyResponse restoreKey(RestoreKeyRequest restoreKeyRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public RestoreKeyResponse restoreKey(Consumer<RestoreKeyRequest.Builder> restoreKeyRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.restoreKey((RestoreKeyRequest)((Object)((RestoreKeyRequest.Builder)RestoreKeyRequest.builder().applyMutation(restoreKeyRequest)).build()));
    }

    default public StartKeyUsageResponse startKeyUsage(StartKeyUsageRequest startKeyUsageRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public StartKeyUsageResponse startKeyUsage(Consumer<StartKeyUsageRequest.Builder> startKeyUsageRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.startKeyUsage((StartKeyUsageRequest)((Object)((StartKeyUsageRequest.Builder)StartKeyUsageRequest.builder().applyMutation(startKeyUsageRequest)).build()));
    }

    default public StopKeyUsageResponse stopKeyUsage(StopKeyUsageRequest stopKeyUsageRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public StopKeyUsageResponse stopKeyUsage(Consumer<StopKeyUsageRequest.Builder> stopKeyUsageRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.stopKeyUsage((StopKeyUsageRequest)((Object)((StopKeyUsageRequest.Builder)StopKeyUsageRequest.builder().applyMutation(stopKeyUsageRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceQuotaExceededException, ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        throw new UnsupportedOperationException();
    }

    default public UpdateAliasResponse updateAlias(Consumer<UpdateAliasRequest.Builder> updateAliasRequest) throws ServiceUnavailableException, ValidationException, ConflictException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, PaymentCryptographyException {
        return this.updateAlias((UpdateAliasRequest)((Object)((UpdateAliasRequest.Builder)UpdateAliasRequest.builder().applyMutation(updateAliasRequest)).build()));
    }

    public static PaymentCryptographyClient create() {
        return (PaymentCryptographyClient)PaymentCryptographyClient.builder().build();
    }

    public static PaymentCryptographyClientBuilder builder() {
        return new DefaultPaymentCryptographyClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public PaymentCryptographyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

