/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyModesOfUse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyModesOfUse> {
    private static final SdkField<Boolean> DECRYPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Decrypt").getter(KeyModesOfUse.getter(KeyModesOfUse::decrypt)).setter(KeyModesOfUse.setter(Builder::decrypt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decrypt").build()}).build();
    private static final SdkField<Boolean> DERIVE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeriveKey").getter(KeyModesOfUse.getter(KeyModesOfUse::deriveKey)).setter(KeyModesOfUse.setter(Builder::deriveKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeriveKey").build()}).build();
    private static final SdkField<Boolean> ENCRYPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypt").getter(KeyModesOfUse.getter(KeyModesOfUse::encrypt)).setter(KeyModesOfUse.setter(Builder::encrypt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypt").build()}).build();
    private static final SdkField<Boolean> GENERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Generate").getter(KeyModesOfUse.getter(KeyModesOfUse::generate)).setter(KeyModesOfUse.setter(Builder::generate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Generate").build()}).build();
    private static final SdkField<Boolean> NO_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoRestrictions").getter(KeyModesOfUse.getter(KeyModesOfUse::noRestrictions)).setter(KeyModesOfUse.setter(Builder::noRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoRestrictions").build()}).build();
    private static final SdkField<Boolean> SIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Sign").getter(KeyModesOfUse.getter(KeyModesOfUse::sign)).setter(KeyModesOfUse.setter(Builder::sign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sign").build()}).build();
    private static final SdkField<Boolean> UNWRAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Unwrap").getter(KeyModesOfUse.getter(KeyModesOfUse::unwrap)).setter(KeyModesOfUse.setter(Builder::unwrap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unwrap").build()}).build();
    private static final SdkField<Boolean> VERIFY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Verify").getter(KeyModesOfUse.getter(KeyModesOfUse::verify)).setter(KeyModesOfUse.setter(Builder::verify)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Verify").build()}).build();
    private static final SdkField<Boolean> WRAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Wrap").getter(KeyModesOfUse.getter(KeyModesOfUse::wrap)).setter(KeyModesOfUse.setter(Builder::wrap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wrap").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPT_FIELD, DERIVE_KEY_FIELD, ENCRYPT_FIELD, GENERATE_FIELD, NO_RESTRICTIONS_FIELD, SIGN_FIELD, UNWRAP_FIELD, VERIFY_FIELD, WRAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean decrypt;
    private final Boolean deriveKey;
    private final Boolean encrypt;
    private final Boolean generate;
    private final Boolean noRestrictions;
    private final Boolean sign;
    private final Boolean unwrap;
    private final Boolean verify;
    private final Boolean wrap;

    private KeyModesOfUse(BuilderImpl builder) {
        this.decrypt = builder.decrypt;
        this.deriveKey = builder.deriveKey;
        this.encrypt = builder.encrypt;
        this.generate = builder.generate;
        this.noRestrictions = builder.noRestrictions;
        this.sign = builder.sign;
        this.unwrap = builder.unwrap;
        this.verify = builder.verify;
        this.wrap = builder.wrap;
    }

    public final Boolean decrypt() {
        return this.decrypt;
    }

    public final Boolean deriveKey() {
        return this.deriveKey;
    }

    public final Boolean encrypt() {
        return this.encrypt;
    }

    public final Boolean generate() {
        return this.generate;
    }

    public final Boolean noRestrictions() {
        return this.noRestrictions;
    }

    public final Boolean sign() {
        return this.sign;
    }

    public final Boolean unwrap() {
        return this.unwrap;
    }

    public final Boolean verify() {
        return this.verify;
    }

    public final Boolean wrap() {
        return this.wrap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decrypt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deriveKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypt());
        hashCode = 31 * hashCode + Objects.hashCode(this.generate());
        hashCode = 31 * hashCode + Objects.hashCode(this.noRestrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sign());
        hashCode = 31 * hashCode + Objects.hashCode(this.unwrap());
        hashCode = 31 * hashCode + Objects.hashCode(this.verify());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrap());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyModesOfUse)) {
            return false;
        }
        KeyModesOfUse other = (KeyModesOfUse)obj;
        return Objects.equals(this.decrypt(), other.decrypt()) && Objects.equals(this.deriveKey(), other.deriveKey()) && Objects.equals(this.encrypt(), other.encrypt()) && Objects.equals(this.generate(), other.generate()) && Objects.equals(this.noRestrictions(), other.noRestrictions()) && Objects.equals(this.sign(), other.sign()) && Objects.equals(this.unwrap(), other.unwrap()) && Objects.equals(this.verify(), other.verify()) && Objects.equals(this.wrap(), other.wrap());
    }

    public final String toString() {
        return ToString.builder((String)"KeyModesOfUse").add("Decrypt", (Object)this.decrypt()).add("DeriveKey", (Object)this.deriveKey()).add("Encrypt", (Object)this.encrypt()).add("Generate", (Object)this.generate()).add("NoRestrictions", (Object)this.noRestrictions()).add("Sign", (Object)this.sign()).add("Unwrap", (Object)this.unwrap()).add("Verify", (Object)this.verify()).add("Wrap", (Object)this.wrap()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decrypt": {
                return Optional.ofNullable(clazz.cast(this.decrypt()));
            }
            case "DeriveKey": {
                return Optional.ofNullable(clazz.cast(this.deriveKey()));
            }
            case "Encrypt": {
                return Optional.ofNullable(clazz.cast(this.encrypt()));
            }
            case "Generate": {
                return Optional.ofNullable(clazz.cast(this.generate()));
            }
            case "NoRestrictions": {
                return Optional.ofNullable(clazz.cast(this.noRestrictions()));
            }
            case "Sign": {
                return Optional.ofNullable(clazz.cast(this.sign()));
            }
            case "Unwrap": {
                return Optional.ofNullable(clazz.cast(this.unwrap()));
            }
            case "Verify": {
                return Optional.ofNullable(clazz.cast(this.verify()));
            }
            case "Wrap": {
                return Optional.ofNullable(clazz.cast(this.wrap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyModesOfUse, T> g) {
        return obj -> g.apply((KeyModesOfUse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean decrypt;
        private Boolean deriveKey;
        private Boolean encrypt;
        private Boolean generate;
        private Boolean noRestrictions;
        private Boolean sign;
        private Boolean unwrap;
        private Boolean verify;
        private Boolean wrap;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyModesOfUse model) {
            this.decrypt(model.decrypt);
            this.deriveKey(model.deriveKey);
            this.encrypt(model.encrypt);
            this.generate(model.generate);
            this.noRestrictions(model.noRestrictions);
            this.sign(model.sign);
            this.unwrap(model.unwrap);
            this.verify(model.verify);
            this.wrap(model.wrap);
        }

        public final Boolean getDecrypt() {
            return this.decrypt;
        }

        public final void setDecrypt(Boolean decrypt) {
            this.decrypt = decrypt;
        }

        @Override
        public final Builder decrypt(Boolean decrypt) {
            this.decrypt = decrypt;
            return this;
        }

        public final Boolean getDeriveKey() {
            return this.deriveKey;
        }

        public final void setDeriveKey(Boolean deriveKey) {
            this.deriveKey = deriveKey;
        }

        @Override
        public final Builder deriveKey(Boolean deriveKey) {
            this.deriveKey = deriveKey;
            return this;
        }

        public final Boolean getEncrypt() {
            return this.encrypt;
        }

        public final void setEncrypt(Boolean encrypt) {
            this.encrypt = encrypt;
        }

        @Override
        public final Builder encrypt(Boolean encrypt) {
            this.encrypt = encrypt;
            return this;
        }

        public final Boolean getGenerate() {
            return this.generate;
        }

        public final void setGenerate(Boolean generate) {
            this.generate = generate;
        }

        @Override
        public final Builder generate(Boolean generate) {
            this.generate = generate;
            return this;
        }

        public final Boolean getNoRestrictions() {
            return this.noRestrictions;
        }

        public final void setNoRestrictions(Boolean noRestrictions) {
            this.noRestrictions = noRestrictions;
        }

        @Override
        public final Builder noRestrictions(Boolean noRestrictions) {
            this.noRestrictions = noRestrictions;
            return this;
        }

        public final Boolean getSign() {
            return this.sign;
        }

        public final void setSign(Boolean sign) {
            this.sign = sign;
        }

        @Override
        public final Builder sign(Boolean sign) {
            this.sign = sign;
            return this;
        }

        public final Boolean getUnwrap() {
            return this.unwrap;
        }

        public final void setUnwrap(Boolean unwrap) {
            this.unwrap = unwrap;
        }

        @Override
        public final Builder unwrap(Boolean unwrap) {
            this.unwrap = unwrap;
            return this;
        }

        public final Boolean getVerify() {
            return this.verify;
        }

        public final void setVerify(Boolean verify) {
            this.verify = verify;
        }

        @Override
        public final Builder verify(Boolean verify) {
            this.verify = verify;
            return this;
        }

        public final Boolean getWrap() {
            return this.wrap;
        }

        public final void setWrap(Boolean wrap) {
            this.wrap = wrap;
        }

        @Override
        public final Builder wrap(Boolean wrap) {
            this.wrap = wrap;
            return this;
        }

        public KeyModesOfUse build() {
            return new KeyModesOfUse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyModesOfUse> {
        public Builder decrypt(Boolean var1);

        public Builder deriveKey(Boolean var1);

        public Builder encrypt(Boolean var1);

        public Builder generate(Boolean var1);

        public Builder noRestrictions(Boolean var1);

        public Builder sign(Boolean var1);

        public Builder unwrap(Boolean var1);

        public Builder verify(Boolean var1);

        public Builder wrap(Boolean var1);
    }
}

