/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTr34KeyBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTr34KeyBlock> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::certificateAuthorityPublicKeyIdentifier)).setter(ExportTr34KeyBlock.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<String> EXPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToken").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::exportToken)).setter(ExportTr34KeyBlock.setter(Builder::exportToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToken").build()}).build();
    private static final SdkField<String> KEY_BLOCK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyBlockFormat").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::keyBlockFormatAsString)).setter(ExportTr34KeyBlock.setter(Builder::keyBlockFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockFormat").build()}).build();
    private static final SdkField<String> RANDOM_NONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RandomNonce").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::randomNonce)).setter(ExportTr34KeyBlock.setter(Builder::randomNonce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RandomNonce").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyCertificate").getter(ExportTr34KeyBlock.getter(ExportTr34KeyBlock::wrappingKeyCertificate)).setter(ExportTr34KeyBlock.setter(Builder::wrappingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyCertificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, EXPORT_TOKEN_FIELD, KEY_BLOCK_FORMAT_FIELD, RANDOM_NONCE_FIELD, WRAPPING_KEY_CERTIFICATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final String exportToken;
    private final String keyBlockFormat;
    private final String randomNonce;
    private final String wrappingKeyCertificate;

    private ExportTr34KeyBlock(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.exportToken = builder.exportToken;
        this.keyBlockFormat = builder.keyBlockFormat;
        this.randomNonce = builder.randomNonce;
        this.wrappingKeyCertificate = builder.wrappingKeyCertificate;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final String exportToken() {
        return this.exportToken;
    }

    public final Tr34KeyBlockFormat keyBlockFormat() {
        return Tr34KeyBlockFormat.fromValue(this.keyBlockFormat);
    }

    public final String keyBlockFormatAsString() {
        return this.keyBlockFormat;
    }

    public final String randomNonce() {
        return this.randomNonce;
    }

    public final String wrappingKeyCertificate() {
        return this.wrappingKeyCertificate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomNonce());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyCertificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTr34KeyBlock)) {
            return false;
        }
        ExportTr34KeyBlock other = (ExportTr34KeyBlock)obj;
        return Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.exportToken(), other.exportToken()) && Objects.equals(this.keyBlockFormatAsString(), other.keyBlockFormatAsString()) && Objects.equals(this.randomNonce(), other.randomNonce()) && Objects.equals(this.wrappingKeyCertificate(), other.wrappingKeyCertificate());
    }

    public final String toString() {
        return ToString.builder((String)"ExportTr34KeyBlock").add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("ExportToken", (Object)this.exportToken()).add("KeyBlockFormat", (Object)this.keyBlockFormatAsString()).add("RandomNonce", (Object)this.randomNonce()).add("WrappingKeyCertificate", (Object)(this.wrappingKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "ExportToken": {
                return Optional.ofNullable(clazz.cast(this.exportToken()));
            }
            case "KeyBlockFormat": {
                return Optional.ofNullable(clazz.cast(this.keyBlockFormatAsString()));
            }
            case "RandomNonce": {
                return Optional.ofNullable(clazz.cast(this.randomNonce()));
            }
            case "WrappingKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyCertificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTr34KeyBlock, T> g) {
        return obj -> g.apply((ExportTr34KeyBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;
        private String exportToken;
        private String keyBlockFormat;
        private String randomNonce;
        private String wrappingKeyCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTr34KeyBlock model) {
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.exportToken(model.exportToken);
            this.keyBlockFormat(model.keyBlockFormat);
            this.randomNonce(model.randomNonce);
            this.wrappingKeyCertificate(model.wrappingKeyCertificate);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getExportToken() {
            return this.exportToken;
        }

        public final void setExportToken(String exportToken) {
            this.exportToken = exportToken;
        }

        @Override
        public final Builder exportToken(String exportToken) {
            this.exportToken = exportToken;
            return this;
        }

        public final String getKeyBlockFormat() {
            return this.keyBlockFormat;
        }

        public final void setKeyBlockFormat(String keyBlockFormat) {
            this.keyBlockFormat = keyBlockFormat;
        }

        @Override
        public final Builder keyBlockFormat(String keyBlockFormat) {
            this.keyBlockFormat = keyBlockFormat;
            return this;
        }

        @Override
        public final Builder keyBlockFormat(Tr34KeyBlockFormat keyBlockFormat) {
            this.keyBlockFormat(keyBlockFormat == null ? null : keyBlockFormat.toString());
            return this;
        }

        public final String getRandomNonce() {
            return this.randomNonce;
        }

        public final void setRandomNonce(String randomNonce) {
            this.randomNonce = randomNonce;
        }

        @Override
        public final Builder randomNonce(String randomNonce) {
            this.randomNonce = randomNonce;
            return this;
        }

        public final String getWrappingKeyCertificate() {
            return this.wrappingKeyCertificate;
        }

        public final void setWrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
        }

        @Override
        public final Builder wrappingKeyCertificate(String wrappingKeyCertificate) {
            this.wrappingKeyCertificate = wrappingKeyCertificate;
            return this;
        }

        public ExportTr34KeyBlock build() {
            return new ExportTr34KeyBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTr34KeyBlock> {
        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder exportToken(String var1);

        public Builder keyBlockFormat(String var1);

        public Builder keyBlockFormat(Tr34KeyBlockFormat var1);

        public Builder randomNonce(String var1);

        public Builder wrappingKeyCertificate(String var1);
    }
}

