/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyMaterialType {
    TR34_KEY_BLOCK("TR34_KEY_BLOCK"),
    TR31_KEY_BLOCK("TR31_KEY_BLOCK"),
    ROOT_PUBLIC_KEY_CERTIFICATE("ROOT_PUBLIC_KEY_CERTIFICATE"),
    TRUSTED_PUBLIC_KEY_CERTIFICATE("TRUSTED_PUBLIC_KEY_CERTIFICATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyMaterialType> VALUE_MAP;
    private final String value;

    private KeyMaterialType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyMaterialType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyMaterialType> knownValues() {
        EnumSet<KeyMaterialType> knownValues = EnumSet.allOf(KeyMaterialType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyMaterialType.class, KeyMaterialType::toString);
    }
}

