/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ReasonCode;
import software.amazon.awssdk.services.partnercentralselling.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartEngagementByAcceptingInvitationTaskResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, StartEngagementByAcceptingInvitationTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::taskId)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::taskArn)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::startTime)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskStatus").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::taskStatusAsString)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::message)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReasonCode").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::reasonCodeAsString)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::reasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()}).build();
    private static final SdkField<String> OPPORTUNITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityId").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::opportunityId)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::opportunityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityId").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotJobId").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::resourceSnapshotJobId)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::resourceSnapshotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobId").build()}).build();
    private static final SdkField<String> ENGAGEMENT_INVITATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementInvitationId").getter(StartEngagementByAcceptingInvitationTaskResponse.getter(StartEngagementByAcceptingInvitationTaskResponse::engagementInvitationId)).setter(StartEngagementByAcceptingInvitationTaskResponse.setter(Builder::engagementInvitationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementInvitationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_ARN_FIELD, START_TIME_FIELD, TASK_STATUS_FIELD, MESSAGE_FIELD, REASON_CODE_FIELD, OPPORTUNITY_ID_FIELD, RESOURCE_SNAPSHOT_JOB_ID_FIELD, ENGAGEMENT_INVITATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartEngagementByAcceptingInvitationTaskResponse.memberNameToFieldInitializer();
    private final String taskId;
    private final String taskArn;
    private final Instant startTime;
    private final String taskStatus;
    private final String message;
    private final String reasonCode;
    private final String opportunityId;
    private final String resourceSnapshotJobId;
    private final String engagementInvitationId;

    private StartEngagementByAcceptingInvitationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskArn = builder.taskArn;
        this.startTime = builder.startTime;
        this.taskStatus = builder.taskStatus;
        this.message = builder.message;
        this.reasonCode = builder.reasonCode;
        this.opportunityId = builder.opportunityId;
        this.resourceSnapshotJobId = builder.resourceSnapshotJobId;
        this.engagementInvitationId = builder.engagementInvitationId;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final String message() {
        return this.message;
    }

    public final ReasonCode reasonCode() {
        return ReasonCode.fromValue(this.reasonCode);
    }

    public final String reasonCodeAsString() {
        return this.reasonCode;
    }

    public final String opportunityId() {
        return this.opportunityId;
    }

    public final String resourceSnapshotJobId() {
        return this.resourceSnapshotJobId;
    }

    public final String engagementInvitationId() {
        return this.engagementInvitationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementInvitationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEngagementByAcceptingInvitationTaskResponse)) {
            return false;
        }
        StartEngagementByAcceptingInvitationTaskResponse other = (StartEngagementByAcceptingInvitationTaskResponse)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.reasonCodeAsString(), other.reasonCodeAsString()) && Objects.equals(this.opportunityId(), other.opportunityId()) && Objects.equals(this.resourceSnapshotJobId(), other.resourceSnapshotJobId()) && Objects.equals(this.engagementInvitationId(), other.engagementInvitationId());
    }

    public final String toString() {
        return ToString.builder((String)"StartEngagementByAcceptingInvitationTaskResponse").add("TaskId", (Object)this.taskId()).add("TaskArn", (Object)this.taskArn()).add("StartTime", (Object)this.startTime()).add("TaskStatus", (Object)this.taskStatusAsString()).add("Message", (Object)this.message()).add("ReasonCode", (Object)this.reasonCodeAsString()).add("OpportunityId", (Object)this.opportunityId()).add("ResourceSnapshotJobId", (Object)this.resourceSnapshotJobId()).add("EngagementInvitationId", (Object)this.engagementInvitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ReasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCodeAsString()));
            }
            case "OpportunityId": {
                return Optional.ofNullable(clazz.cast(this.opportunityId()));
            }
            case "ResourceSnapshotJobId": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotJobId()));
            }
            case "EngagementInvitationId": {
                return Optional.ofNullable(clazz.cast(this.engagementInvitationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TaskStatus", TASK_STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ReasonCode", REASON_CODE_FIELD);
        map.put("OpportunityId", OPPORTUNITY_ID_FIELD);
        map.put("ResourceSnapshotJobId", RESOURCE_SNAPSHOT_JOB_ID_FIELD);
        map.put("EngagementInvitationId", ENGAGEMENT_INVITATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEngagementByAcceptingInvitationTaskResponse, T> g) {
        return obj -> g.apply((StartEngagementByAcceptingInvitationTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String taskId;
        private String taskArn;
        private Instant startTime;
        private String taskStatus;
        private String message;
        private String reasonCode;
        private String opportunityId;
        private String resourceSnapshotJobId;
        private String engagementInvitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEngagementByAcceptingInvitationTaskResponse model) {
            super(model);
            this.taskId(model.taskId);
            this.taskArn(model.taskArn);
            this.startTime(model.startTime);
            this.taskStatus(model.taskStatus);
            this.message(model.message);
            this.reasonCode(model.reasonCode);
            this.opportunityId(model.opportunityId);
            this.resourceSnapshotJobId(model.resourceSnapshotJobId);
            this.engagementInvitationId(model.engagementInvitationId);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        @Override
        public final Builder reasonCode(ReasonCode reasonCode) {
            this.reasonCode(reasonCode == null ? null : reasonCode.toString());
            return this;
        }

        public final String getOpportunityId() {
            return this.opportunityId;
        }

        public final void setOpportunityId(String opportunityId) {
            this.opportunityId = opportunityId;
        }

        @Override
        public final Builder opportunityId(String opportunityId) {
            this.opportunityId = opportunityId;
            return this;
        }

        public final String getResourceSnapshotJobId() {
            return this.resourceSnapshotJobId;
        }

        public final void setResourceSnapshotJobId(String resourceSnapshotJobId) {
            this.resourceSnapshotJobId = resourceSnapshotJobId;
        }

        @Override
        public final Builder resourceSnapshotJobId(String resourceSnapshotJobId) {
            this.resourceSnapshotJobId = resourceSnapshotJobId;
            return this;
        }

        public final String getEngagementInvitationId() {
            return this.engagementInvitationId;
        }

        public final void setEngagementInvitationId(String engagementInvitationId) {
            this.engagementInvitationId = engagementInvitationId;
        }

        @Override
        public final Builder engagementInvitationId(String engagementInvitationId) {
            this.engagementInvitationId = engagementInvitationId;
            return this;
        }

        @Override
        public StartEngagementByAcceptingInvitationTaskResponse build() {
            return new StartEngagementByAcceptingInvitationTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartEngagementByAcceptingInvitationTaskResponse> {
        public Builder taskId(String var1);

        public Builder taskArn(String var1);

        public Builder startTime(Instant var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder message(String var1);

        public Builder reasonCode(String var1);

        public Builder reasonCode(ReasonCode var1);

        public Builder opportunityId(String var1);

        public Builder resourceSnapshotJobId(String var1);

        public Builder engagementInvitationId(String var1);
    }
}

