/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RelatedEntityType {
    SOLUTIONS("Solutions"),
    AWS_PRODUCTS("AwsProducts"),
    AWS_MARKETPLACE_OFFERS("AwsMarketplaceOffers"),
    AWS_MARKETPLACE_OFFER_SETS("AwsMarketplaceOfferSets"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RelatedEntityType> VALUE_MAP;
    private final String value;

    private RelatedEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelatedEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelatedEntityType> knownValues() {
        EnumSet<RelatedEntityType> knownValues = EnumSet.allOf(RelatedEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RelatedEntityType.class, RelatedEntityType::toString);
    }
}

