/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceSnapshotsResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListResourceSnapshotsResponse> {
    private static final SdkField<List<ResourceSnapshotSummary>> RESOURCE_SNAPSHOT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSnapshotSummaries").getter(ListResourceSnapshotsResponse.getter(ListResourceSnapshotsResponse::resourceSnapshotSummaries)).setter(ListResourceSnapshotsResponse.setter(Builder::resourceSnapshotSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSnapshotSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceSnapshotsResponse.getter(ListResourceSnapshotsResponse::nextToken)).setter(ListResourceSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SNAPSHOT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourceSnapshotsResponse.memberNameToFieldInitializer();
    private final List<ResourceSnapshotSummary> resourceSnapshotSummaries;
    private final String nextToken;

    private ListResourceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSnapshotSummaries = builder.resourceSnapshotSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceSnapshotSummaries() {
        return this.resourceSnapshotSummaries != null && !(this.resourceSnapshotSummaries instanceof SdkAutoConstructList);
    }

    public final List<ResourceSnapshotSummary> resourceSnapshotSummaries() {
        return this.resourceSnapshotSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSnapshotSummaries() ? this.resourceSnapshotSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSnapshotsResponse)) {
            return false;
        }
        ListResourceSnapshotsResponse other = (ListResourceSnapshotsResponse)((Object)obj);
        return this.hasResourceSnapshotSummaries() == other.hasResourceSnapshotSummaries() && Objects.equals(this.resourceSnapshotSummaries(), other.resourceSnapshotSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceSnapshotsResponse").add("ResourceSnapshotSummaries", this.hasResourceSnapshotSummaries() ? this.resourceSnapshotSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSnapshotSummaries": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceSnapshotSummaries", RESOURCE_SNAPSHOT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSnapshotsResponse, T> g) {
        return obj -> g.apply((ListResourceSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private List<ResourceSnapshotSummary> resourceSnapshotSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSnapshotsResponse model) {
            super(model);
            this.resourceSnapshotSummaries(model.resourceSnapshotSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceSnapshotSummary.Builder> getResourceSnapshotSummaries() {
            List<ResourceSnapshotSummary.Builder> result = ResourceSnapshotSummaryListCopier.copyToBuilder(this.resourceSnapshotSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSnapshotSummaries(Collection<ResourceSnapshotSummary.BuilderImpl> resourceSnapshotSummaries) {
            this.resourceSnapshotSummaries = ResourceSnapshotSummaryListCopier.copyFromBuilder(resourceSnapshotSummaries);
        }

        @Override
        public final Builder resourceSnapshotSummaries(Collection<ResourceSnapshotSummary> resourceSnapshotSummaries) {
            this.resourceSnapshotSummaries = ResourceSnapshotSummaryListCopier.copy(resourceSnapshotSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotSummaries(ResourceSnapshotSummary ... resourceSnapshotSummaries) {
            this.resourceSnapshotSummaries(Arrays.asList(resourceSnapshotSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotSummaries(Consumer<ResourceSnapshotSummary.Builder> ... resourceSnapshotSummaries) {
            this.resourceSnapshotSummaries(Stream.of(resourceSnapshotSummaries).map(c -> (ResourceSnapshotSummary)((ResourceSnapshotSummary.Builder)ResourceSnapshotSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceSnapshotsResponse build() {
            return new ListResourceSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceSnapshotsResponse> {
        public Builder resourceSnapshotSummaries(Collection<ResourceSnapshotSummary> var1);

        public Builder resourceSnapshotSummaries(ResourceSnapshotSummary ... var1);

        public Builder resourceSnapshotSummaries(Consumer<ResourceSnapshotSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

