/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.LeadContact;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LeadInteraction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LeadInteraction> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(LeadInteraction.getter(LeadInteraction::sourceType)).setter(LeadInteraction.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceId").getter(LeadInteraction.getter(LeadInteraction::sourceId)).setter(LeadInteraction.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceName").getter(LeadInteraction.getter(LeadInteraction::sourceName)).setter(LeadInteraction.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()}).build();
    private static final SdkField<String> USECASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Usecase").getter(LeadInteraction.getter(LeadInteraction::usecase)).setter(LeadInteraction.setter(Builder::usecase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usecase").build()}).build();
    private static final SdkField<Instant> INTERACTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InteractionDate").getter(LeadInteraction.getter(LeadInteraction::interactionDate)).setter(LeadInteraction.setter(Builder::interactionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InteractionDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOMER_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerAction").getter(LeadInteraction.getter(LeadInteraction::customerAction)).setter(LeadInteraction.setter(Builder::customerAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAction").build()}).build();
    private static final SdkField<String> BUSINESS_PROBLEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessProblem").getter(LeadInteraction.getter(LeadInteraction::businessProblem)).setter(LeadInteraction.setter(Builder::businessProblem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessProblem").build()}).build();
    private static final SdkField<LeadContact> CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Contact").getter(LeadInteraction.getter(LeadInteraction::contact)).setter(LeadInteraction.setter(Builder::contact)).constructor(LeadContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, SOURCE_ID_FIELD, SOURCE_NAME_FIELD, USECASE_FIELD, INTERACTION_DATE_FIELD, CUSTOMER_ACTION_FIELD, BUSINESS_PROBLEM_FIELD, CONTACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LeadInteraction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final String sourceId;
    private final String sourceName;
    private final String usecase;
    private final Instant interactionDate;
    private final String customerAction;
    private final String businessProblem;
    private final LeadContact contact;

    private LeadInteraction(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceId = builder.sourceId;
        this.sourceName = builder.sourceName;
        this.usecase = builder.usecase;
        this.interactionDate = builder.interactionDate;
        this.customerAction = builder.customerAction;
        this.businessProblem = builder.businessProblem;
        this.contact = builder.contact;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final String usecase() {
        return this.usecase;
    }

    public final Instant interactionDate() {
        return this.interactionDate;
    }

    public final String customerAction() {
        return this.customerAction;
    }

    public final String businessProblem() {
        return this.businessProblem;
    }

    public final LeadContact contact() {
        return this.contact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.usecase());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessProblem());
        hashCode = 31 * hashCode + Objects.hashCode(this.contact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LeadInteraction)) {
            return false;
        }
        LeadInteraction other = (LeadInteraction)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.usecase(), other.usecase()) && Objects.equals(this.interactionDate(), other.interactionDate()) && Objects.equals(this.customerAction(), other.customerAction()) && Objects.equals(this.businessProblem(), other.businessProblem()) && Objects.equals(this.contact(), other.contact());
    }

    public final String toString() {
        return ToString.builder((String)"LeadInteraction").add("SourceType", (Object)this.sourceType()).add("SourceId", (Object)this.sourceId()).add("SourceName", (Object)this.sourceName()).add("Usecase", (Object)this.usecase()).add("InteractionDate", (Object)this.interactionDate()).add("CustomerAction", (Object)this.customerAction()).add("BusinessProblem", (Object)(this.businessProblem() == null ? null : "*** Sensitive Data Redacted ***")).add("Contact", (Object)this.contact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "SourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "Usecase": {
                return Optional.ofNullable(clazz.cast(this.usecase()));
            }
            case "InteractionDate": {
                return Optional.ofNullable(clazz.cast(this.interactionDate()));
            }
            case "CustomerAction": {
                return Optional.ofNullable(clazz.cast(this.customerAction()));
            }
            case "BusinessProblem": {
                return Optional.ofNullable(clazz.cast(this.businessProblem()));
            }
            case "Contact": {
                return Optional.ofNullable(clazz.cast(this.contact()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("SourceName", SOURCE_NAME_FIELD);
        map.put("Usecase", USECASE_FIELD);
        map.put("InteractionDate", INTERACTION_DATE_FIELD);
        map.put("CustomerAction", CUSTOMER_ACTION_FIELD);
        map.put("BusinessProblem", BUSINESS_PROBLEM_FIELD);
        map.put("Contact", CONTACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LeadInteraction, T> g) {
        return obj -> g.apply((LeadInteraction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceId;
        private String sourceName;
        private String usecase;
        private Instant interactionDate;
        private String customerAction;
        private String businessProblem;
        private LeadContact contact;

        private BuilderImpl() {
        }

        private BuilderImpl(LeadInteraction model) {
            this.sourceType(model.sourceType);
            this.sourceId(model.sourceId);
            this.sourceName(model.sourceName);
            this.usecase(model.usecase);
            this.interactionDate(model.interactionDate);
            this.customerAction(model.customerAction);
            this.businessProblem(model.businessProblem);
            this.contact(model.contact);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getUsecase() {
            return this.usecase;
        }

        public final void setUsecase(String usecase) {
            this.usecase = usecase;
        }

        @Override
        public final Builder usecase(String usecase) {
            this.usecase = usecase;
            return this;
        }

        public final Instant getInteractionDate() {
            return this.interactionDate;
        }

        public final void setInteractionDate(Instant interactionDate) {
            this.interactionDate = interactionDate;
        }

        @Override
        public final Builder interactionDate(Instant interactionDate) {
            this.interactionDate = interactionDate;
            return this;
        }

        public final String getCustomerAction() {
            return this.customerAction;
        }

        public final void setCustomerAction(String customerAction) {
            this.customerAction = customerAction;
        }

        @Override
        public final Builder customerAction(String customerAction) {
            this.customerAction = customerAction;
            return this;
        }

        public final String getBusinessProblem() {
            return this.businessProblem;
        }

        public final void setBusinessProblem(String businessProblem) {
            this.businessProblem = businessProblem;
        }

        @Override
        public final Builder businessProblem(String businessProblem) {
            this.businessProblem = businessProblem;
            return this;
        }

        public final LeadContact.Builder getContact() {
            return this.contact != null ? this.contact.toBuilder() : null;
        }

        public final void setContact(LeadContact.BuilderImpl contact) {
            this.contact = contact != null ? contact.build() : null;
        }

        @Override
        public final Builder contact(LeadContact contact) {
            this.contact = contact;
            return this;
        }

        public LeadInteraction build() {
            return new LeadInteraction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LeadInteraction> {
        public Builder sourceType(String var1);

        public Builder sourceId(String var1);

        public Builder sourceName(String var1);

        public Builder usecase(String var1);

        public Builder interactionDate(Instant var1);

        public Builder customerAction(String var1);

        public Builder businessProblem(String var1);

        public Builder contact(LeadContact var1);

        default public Builder contact(Consumer<LeadContact.Builder> contact) {
            return this.contact((LeadContact)((LeadContact.Builder)LeadContact.builder().applyMutation(contact)).build());
        }
    }
}

