/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralselling.model.CustomerProjectsContext;
import software.amazon.awssdk.services.partnercentralselling.model.LeadContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EngagementContextPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EngagementContextPayload> {
    private static final SdkField<CustomerProjectsContext> CUSTOMER_PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerProject").getter(EngagementContextPayload.getter(EngagementContextPayload::customerProject)).setter(EngagementContextPayload.setter(Builder::customerProject)).constructor(CustomerProjectsContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProject").build()}).build();
    private static final SdkField<LeadContext> LEAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lead").getter(EngagementContextPayload.getter(EngagementContextPayload::lead)).setter(EngagementContextPayload.setter(Builder::lead)).constructor(LeadContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lead").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_PROJECT_FIELD, LEAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EngagementContextPayload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomerProjectsContext customerProject;
    private final LeadContext lead;
    private final Type type;

    private EngagementContextPayload(BuilderImpl builder) {
        this.customerProject = builder.customerProject;
        this.lead = builder.lead;
        this.type = builder.type;
    }

    public final CustomerProjectsContext customerProject() {
        return this.customerProject;
    }

    public final LeadContext lead() {
        return this.lead;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerProject());
        hashCode = 31 * hashCode + Objects.hashCode(this.lead());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementContextPayload)) {
            return false;
        }
        EngagementContextPayload other = (EngagementContextPayload)obj;
        return Objects.equals(this.customerProject(), other.customerProject()) && Objects.equals(this.lead(), other.lead());
    }

    public final String toString() {
        return ToString.builder((String)"EngagementContextPayload").add("CustomerProject", (Object)this.customerProject()).add("Lead", (Object)this.lead()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerProject": {
                return Optional.ofNullable(clazz.cast(this.customerProject()));
            }
            case "Lead": {
                return Optional.ofNullable(clazz.cast(this.lead()));
            }
        }
        return Optional.empty();
    }

    public static EngagementContextPayload fromCustomerProject(CustomerProjectsContext customerProject) {
        return (EngagementContextPayload)EngagementContextPayload.builder().customerProject(customerProject).build();
    }

    public static EngagementContextPayload fromCustomerProject(Consumer<CustomerProjectsContext.Builder> customerProject) {
        CustomerProjectsContext.Builder builder = CustomerProjectsContext.builder();
        customerProject.accept(builder);
        return EngagementContextPayload.fromCustomerProject((CustomerProjectsContext)builder.build());
    }

    public static EngagementContextPayload fromLead(LeadContext lead) {
        return (EngagementContextPayload)EngagementContextPayload.builder().lead(lead).build();
    }

    public static EngagementContextPayload fromLead(Consumer<LeadContext.Builder> lead) {
        LeadContext.Builder builder = LeadContext.builder();
        lead.accept(builder);
        return EngagementContextPayload.fromLead((LeadContext)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CustomerProject", CUSTOMER_PROJECT_FIELD);
        map.put("Lead", LEAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementContextPayload, T> g) {
        return obj -> g.apply((EngagementContextPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CUSTOMER_PROJECT,
        LEAD,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CustomerProjectsContext customerProject;
        private LeadContext lead;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementContextPayload model) {
            this.customerProject(model.customerProject);
            this.lead(model.lead);
        }

        public final CustomerProjectsContext.Builder getCustomerProject() {
            return this.customerProject != null ? this.customerProject.toBuilder() : null;
        }

        public final void setCustomerProject(CustomerProjectsContext.BuilderImpl customerProject) {
            CustomerProjectsContext oldValue = this.customerProject;
            this.customerProject = customerProject != null ? customerProject.build() : null;
            this.handleUnionValueChange(Type.CUSTOMER_PROJECT, oldValue, this.customerProject);
        }

        @Override
        public final Builder customerProject(CustomerProjectsContext customerProject) {
            CustomerProjectsContext oldValue = this.customerProject;
            this.customerProject = customerProject;
            this.handleUnionValueChange(Type.CUSTOMER_PROJECT, oldValue, this.customerProject);
            return this;
        }

        public final LeadContext.Builder getLead() {
            return this.lead != null ? this.lead.toBuilder() : null;
        }

        public final void setLead(LeadContext.BuilderImpl lead) {
            LeadContext oldValue = this.lead;
            this.lead = lead != null ? lead.build() : null;
            this.handleUnionValueChange(Type.LEAD, oldValue, this.lead);
        }

        @Override
        public final Builder lead(LeadContext lead) {
            LeadContext oldValue = this.lead;
            this.lead = lead;
            this.handleUnionValueChange(Type.LEAD, oldValue, this.lead);
            return this;
        }

        public EngagementContextPayload build() {
            return new EngagementContextPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EngagementContextPayload> {
        public Builder customerProject(CustomerProjectsContext var1);

        default public Builder customerProject(Consumer<CustomerProjectsContext.Builder> customerProject) {
            return this.customerProject((CustomerProjectsContext)((CustomerProjectsContext.Builder)CustomerProjectsContext.builder().applyMutation(customerProject)).build());
        }

        public Builder lead(LeadContext var1);

        default public Builder lead(Consumer<LeadContext.Builder> lead) {
            return this.lead((LeadContext)((LeadContext.Builder)LeadContext.builder().applyMutation(lead)).build());
        }
    }
}

