/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionBase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionBase> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(SolutionBase.getter(SolutionBase::arn)).setter(SolutionBase.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(SolutionBase.getter(SolutionBase::catalog)).setter(SolutionBase.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(SolutionBase.getter(SolutionBase::category)).setter(SolutionBase.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(SolutionBase.getter(SolutionBase::createdDate)).setter(SolutionBase.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SolutionBase.getter(SolutionBase::id)).setter(SolutionBase.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SolutionBase.getter(SolutionBase::name)).setter(SolutionBase.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SolutionBase.getter(SolutionBase::statusAsString)).setter(SolutionBase.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD, CATEGORY_FIELD, CREATED_DATE_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SolutionBase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String catalog;
    private final String category;
    private final Instant createdDate;
    private final String id;
    private final String name;
    private final String status;

    private SolutionBase(BuilderImpl builder) {
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.category = builder.category;
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String category() {
        return this.category;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final SolutionStatus status() {
        return SolutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionBase)) {
            return false;
        }
        SolutionBase other = (SolutionBase)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SolutionBase").add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("Category", (Object)this.category()).add("CreatedDate", (Object)this.createdDate()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SolutionBase, T> g) {
        return obj -> g.apply((SolutionBase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String catalog;
        private String category;
        private Instant createdDate;
        private String id;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionBase model) {
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.category(model.category);
            this.createdDate(model.createdDate);
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SolutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public SolutionBase build() {
            return new SolutionBase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionBase> {
        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder category(String var1);

        public Builder createdDate(Instant var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(SolutionStatus var1);
    }
}

